/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.broadinstitute.sting.gatk.datasources.reads.BlockLoader;
import org.broadinstitute.sting.gatk.datasources.reads.FileHandleCache;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderPosition;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BGZFBlockLoadingDispatcher {
    private final FileHandleCache fileHandleCache;
    private final ExecutorService threadPool;
    private final Queue<SAMReaderPosition> inputQueue;

    public BGZFBlockLoadingDispatcher(int numThreads, int numFileHandles) {
        this.threadPool = Executors.newFixedThreadPool(numThreads);
        this.fileHandleCache = new FileHandleCache(numFileHandles);
        this.inputQueue = new LinkedList<SAMReaderPosition>();
        this.threadPool.execute(new BlockLoader(this, this.fileHandleCache, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueBlockLoad(SAMReaderPosition readerPosition) {
        Queue<SAMReaderPosition> queue = this.inputQueue;
        synchronized (queue) {
            this.inputQueue.add(readerPosition);
            this.inputQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SAMReaderPosition claimNextWorkRequest() {
        Queue<SAMReaderPosition> queue = this.inputQueue;
        synchronized (queue) {
            while (this.inputQueue.isEmpty()) {
                try {
                    this.inputQueue.wait();
                }
                catch (InterruptedException ex) {
                    throw new ReviewedStingException("Interrupt occurred waiting for next block reader work item");
                }
            }
            return this.inputQueue.poll();
        }
    }
}

