/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.gatk.iterators.PushbackIterator;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;

public class GenomicMap
implements Iterable<Map.Entry<String, Collection<GenomeLoc>>> {
    private Map<String, Collection<GenomeLoc>> map;

    public GenomicMap(int initialContigs) {
        this.map = new HashMap<String, Collection<GenomeLoc>>(initialContigs);
    }

    public GenomicMap() {
        this(1000);
    }

    public void addCustomContig(String name, Collection<GenomeLoc> c) {
        if (name == null) {
            throw new ReviewedStingException("Custom contig name can not be null");
        }
        if (this.map.containsKey(name)) {
            throw new ReviewedStingException("Custom contig " + name + " already exists");
        }
        this.map.put(name, c);
    }

    public Collection<GenomeLoc> getContigMapping(String name) {
        return this.map.get(name);
    }

    public void readArachne(SAMSequenceDictionary sequenceDictionary, GenomeLocParser genomeLocParser, File f) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int p2;
                int p1;
                String[] halves = line.split("#", 2);
                if (halves.length < 2) {
                    throw new UserException.MalformedFile(f, "Line: " + line + "\nin map file " + f + "\n does not contain contig name");
                }
                for (p1 = 0; p1 < halves[1].length() && Character.isWhitespace(halves[1].charAt(p1)); ++p1) {
                }
                for (p2 = p1; p2 < halves[1].length() && !Character.isWhitespace(halves[1].charAt(p2)); ++p2) {
                }
                if (p1 == p2) {
                    throw new UserException.MalformedFile(f, "Line: " + line + "\n in map file " + f + "\nNo contig name found after '#'");
                }
                String name = halves[1].substring(p1, p2);
                String[] coord_parts = halves[0].split("\\s");
                if (coord_parts.length % 3 != 0) {
                    throw new UserException.MalformedFile(f, "Line: " + line + "\n in map file " + f + "\nNumber of coordinate fields is not a multiple of 3");
                }
                ArrayList<GenomeLoc> segments = new ArrayList<GenomeLoc>(coord_parts.length / 3);
                for (int i = 0; i < coord_parts.length; i += 3) {
                    int index = Integer.parseInt(coord_parts[i]);
                    String contig = sequenceDictionary.getSequence(index).getSequenceName();
                    int start = Integer.parseInt(coord_parts[i + 1]);
                    int stop = Integer.parseInt(coord_parts[i + 2]);
                    segments.add(genomeLocParser.createGenomeLoc(contig, start + 1, stop + 1));
                }
                this.addCustomContig(name, segments);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(f, (Exception)e);
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(f, (Exception)e);
        }
    }

    public void read(GenomeLocParser genomeLocParser, File f) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int p2;
                int p1;
                for (p1 = 0; p1 < line.length() && Character.isWhitespace(line.charAt(p1)); ++p1) {
                }
                for (p2 = p1; p2 < line.length() && !Character.isWhitespace(line.charAt(p2)); ++p2) {
                }
                if (p1 == p2) continue;
                String name = line.substring(p1, p2);
                ArrayList<GenomeLoc> segments = new ArrayList<GenomeLoc>(5);
                for (p1 = p2 + 1; p1 < line.length() && Character.isWhitespace(line.charAt(p1)); ++p1) {
                }
                for (p2 = p1; p2 < line.length() && line.charAt(p2) != ','; ++p2) {
                }
                while (p2 != p1) {
                    GenomeLoc newSegment = genomeLocParser.parseGenomeLoc(line.substring(p1, p2));
                    if (segments.size() > 0 && ((GenomeLoc)segments.get(segments.size() - 1)).getStop() + 1 == newSegment.getStart() && ((GenomeLoc)segments.get(segments.size() - 1)).getContigIndex() == newSegment.getContigIndex()) {
                        System.out.println("WARNING: strictly adjacent segments found in custom contig " + name);
                    }
                    segments.add(newSegment);
                    for (p1 = p2 + 1; p1 < line.length() && Character.isWhitespace(line.charAt(p1)); ++p1) {
                    }
                    for (p2 = p1; p2 < line.length() && line.charAt(p2) != ','; ++p2) {
                    }
                }
                if (segments.size() == 0) {
                    throw new ReviewedStingException("Line " + line + " has no intervals specified");
                }
                this.addCustomContig(name, segments);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(f, (Exception)e);
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(f, (Exception)e);
        }
    }

    public void write(File f) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            for (String name : this.nameSet()) {
                writer.append(name + " ");
                Iterator<GenomeLoc> iter = this.getContigMapping(name).iterator();
                if (iter.hasNext()) {
                    writer.append(iter.next().toString());
                }
                while (iter.hasNext()) {
                    writer.append(',');
                    writer.append(iter.next().toString());
                }
                writer.append('\n');
            }
            writer.close();
        }
        catch (IOException e) {
            throw new UserException.CouldNotCreateOutputFile(f, e);
        }
    }

    public SAMRecord remapToMasterReference(SAMRecord r, SAMFileHeader h, boolean discardCrossContig) {
        if (AlignmentUtils.isReadUnmapped(r)) {
            r.setReferenceIndex(-1);
            r.setAlignmentStart(0);
            r.setMappingQuality(0);
            r.setCigar(new Cigar());
            r.setNotPrimaryAlignmentFlag(false);
            if (r.getReadNegativeStrandFlag()) {
                r.setReadBases(BaseUtils.simpleReverseComplement(r.getReadBases()));
                r.setBaseQualities(Utils.reverse(r.getBaseQualities()));
                r.setReadNegativeStrandFlag(false);
            }
            return r;
        }
        int customStart = r.getAlignmentStart();
        Collection<GenomeLoc> segments = this.getContigMapping(r.getReferenceName());
        if (segments == null) {
            throw new UserException.MalformedBAM(r, "Can not remap a record: unknown custom contig name " + r.getReferenceName());
        }
        Pair<PushbackIterator<GenomeLoc>, Integer> p = this.seekForward(segments, customStart);
        Iterator iter = (Iterator)p.first;
        GenomeLoc gl = (GenomeLoc)iter.next();
        int refPos = (Integer)p.second + gl.getStart() - 1;
        String oldRefName = r.getReferenceName();
        int oldStart = r.getAlignmentStart();
        int oldEnd = r.getAlignmentEnd();
        r.setAlignmentStart(refPos);
        r.setHeader(h);
        r.setReferenceIndex(gl.getContigIndex());
        Cigar oldCigar = r.getCigar();
        Cigar newCigar = new Cigar();
        int N = oldCigar.numCigarElements();
        long currStop = gl.getStop();
        int delayedGap = 0;
        block5: for (int k = 0; k < N; ++k) {
            CigarElement ce = oldCigar.getCigarElement(k);
            int len = ce.getLength();
            switch (ce.getOperator()) {
                case S: 
                case H: {
                    if (k != 0 && k != N - 1) {
                        throw new ReviewedStingException("Don't know what to do with S or N cigar element that is not at the either end of the cigar. Cigar: " + r.getCigarString());
                    }
                }
                case I: {
                    newCigar.add(new CigarElement(len, ce.getOperator()));
                    continue block5;
                }
                case D: 
                case M: {
                    if (delayedGap > 0) {
                        newCigar.add(new CigarElement(delayedGap, CigarOperator.N));
                        delayedGap = 0;
                    }
                    while ((long)(refPos + len - 1) > currStop) {
                        int currLength = (int)(currStop - (long)refPos + 1L);
                        if (currLength > 0) {
                            newCigar.add(new CigarElement(currLength, ce.getOperator()));
                            len -= currLength;
                        }
                        if (!iter.hasNext()) {
                            String message = "Record " + r.getReadName() + " extends beyond its custom contig." + "\nRead aligns to: " + oldRefName + ":" + oldStart + "-" + oldEnd + "; cigar=" + r.getCigarString() + "; contig length=" + this.contigLength(segments);
                            if (discardCrossContig) {
                                return null;
                            }
                            throw new UserException.MalformedBAM(r, message);
                        }
                        gl = (GenomeLoc)iter.next();
                        refPos = gl.getStart();
                        if (gl.getContigIndex() != r.getReferenceIndex().intValue()) {
                            throw new UserException.MalformedBAM(r, "Contig " + oldRefName + " has segments on different master contigs: currently unsupported");
                        }
                        if ((long)refPos < currStop + 1L) {
                            throw new UserException.MalformedBAM(r, "Contig " + oldRefName + " has segments that are out of order or strictly adjacent: currently unsupported");
                        }
                        if (len > 0 && (long)refPos > currStop + 1L) {
                            newCigar.add(new CigarElement((int)((long)refPos - currStop - 1L), CigarOperator.N));
                        } else {
                            delayedGap = (int)((long)refPos - currStop - 1L);
                        }
                        currStop = gl.getStop();
                    }
                    if (len > 0) {
                        newCigar.add(new CigarElement(len, ce.getOperator()));
                    }
                    refPos += len;
                }
            }
        }
        r.setCigar(newCigar);
        return r;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<Map.Entry<String, Collection<GenomeLoc>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public Iterator<String> nameIterator() {
        return this.map.keySet().iterator();
    }

    public Set<String> nameSet() {
        return this.map.keySet();
    }

    private Pair<PushbackIterator<GenomeLoc>, Integer> seekForward(Collection<GenomeLoc> segments, int position) {
        if (position < 1) {
            throw new ReviewedStingException("Position " + position + " is outside of custom contig boundaries");
        }
        PushbackIterator<GenomeLoc> iter = new PushbackIterator<GenomeLoc>(segments.iterator());
        while (iter.hasNext()) {
            GenomeLoc current = iter.next();
            long length = current.getStop() - current.getStart() + 1;
            if ((long)position <= length) {
                iter.pushback(current);
                return new Pair<PushbackIterator<GenomeLoc>, Integer>(iter, position);
            }
            position = (int)((long)position - length);
        }
        throw new ReviewedStingException("Position " + position + " is outside of custom contig boundaries");
    }

    private long contigLength(Collection<GenomeLoc> segments) {
        long l = 0L;
        for (GenomeLoc g : segments) {
            l += (long)(g.getStop() - g.getStart() + 1);
        }
        return l;
    }

    public static void main(String[] argv) {
        SAMFileReader reader = new SAMFileReader(new File("X:/asivache/cDNA/new_pipeline/30BV1/test.1.sam"));
        SAMRecord r = new SAMRecord(reader.getFileHeader());
        GenomeLocParser genomeLocParser = new GenomeLocParser(reader.getFileHeader().getSequenceDictionary());
        r.setReferenceName("ENST00000378466");
        r.setAlignmentStart(1235);
        r.setCigarString("24M1D27M");
        GenomicMap m = new GenomicMap(5);
        m.read(genomeLocParser, new File("W:/berger/cDNA_BAM/refs/Ensembl52.plus.Genome.map"));
        m.remapToMasterReference(r, reader.getFileHeader(), true);
        boolean cnt = false;
        System.out.println(m.size() + " contigs loaded");
        System.out.println("new alignment: " + r.format());
        reader.close();
    }
}

