/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentDefinitionGroup;
import org.broadinstitute.sting.commandline.ArgumentDefinitions;
import org.broadinstitute.sting.commandline.ArgumentMatchSource;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.help.ApplicationDetails;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

public class HelpFormatter {
    private static Logger logger = Logger.getLogger(HelpFormatter.class);
    public static final int FIELD_SEPARATION_WIDTH = 3;

    public void printHelp(ApplicationDetails applicationDetails, ArgumentDefinitions argumentDefinitions) {
        List<ArgumentDefinitionGroup> argumentGroups = this.prepareArgumentGroups(argumentDefinitions);
        List<String> header = applicationDetails.applicationHeader;
        String barrier = HelpFormatter.createBarrier(header);
        System.out.printf("%s%n", barrier);
        for (String headerLine : header) {
            System.out.printf("%s%n", headerLine);
        }
        System.out.printf("%s%n", barrier);
        for (String attributionLine : applicationDetails.attribution) {
            System.out.printf("%s%n", attributionLine);
        }
        System.out.printf("%s%n", barrier);
        String synopsis = this.getSynopsis(applicationDetails.runningInstructions, argumentGroups);
        String additionalDetails = applicationDetails.additionalHelp != null ? applicationDetails.additionalHelp : "";
        String detailedDescription = this.getDetailed(argumentGroups);
        System.out.printf("%s%n%s%n%s%n", synopsis, detailedDescription, additionalDetails);
    }

    private String getSynopsis(String runningInstructions, List<ArgumentDefinitionGroup> argumentGroups) {
        StringBuilder lineBuilder = new StringBuilder();
        Formatter lineFormatter = new Formatter(lineBuilder);
        lineFormatter.format("java %s", runningInstructions);
        for (ArgumentDefinitionGroup argumentGroup : argumentGroups) {
            for (ArgumentDefinition argumentDefinition : argumentGroup.argumentDefinitions) {
                if (argumentDefinition.isHidden) continue;
                lineFormatter.format(" ", new Object[0]);
                if (!argumentDefinition.required) {
                    lineFormatter.format("[", new Object[0]);
                }
                if (argumentDefinition.shortName != null) {
                    lineFormatter.format("-%s", argumentDefinition.shortName);
                } else {
                    lineFormatter.format("--%s", argumentDefinition.fullName);
                }
                if (!argumentDefinition.isFlag) {
                    lineFormatter.format(" <%s>", argumentDefinition.fullName);
                }
                if (argumentDefinition.required) continue;
                lineFormatter.format("]", new Object[0]);
            }
        }
        List<String> wrappedSynopsis = TextFormattingUtils.wordWrap(lineBuilder.toString(), 120);
        String header = "usage: ";
        int headerLength = header.length();
        StringBuilder synopsisBuilder = new StringBuilder();
        Formatter synopsisFormatter = new Formatter(synopsisBuilder);
        for (String synopsisLine : wrappedSynopsis) {
            synopsisFormatter.format("%" + headerLength + "s%s%n", header, synopsisLine);
            header = "";
        }
        return synopsisBuilder.toString();
    }

    private String getDetailed(List<ArgumentDefinitionGroup> argumentGroups) {
        StringBuilder builder = new StringBuilder();
        for (ArgumentDefinitionGroup argumentGroup : argumentGroups) {
            builder.append(this.getDetailForGroup(argumentGroup));
        }
        return builder.toString();
    }

    private String getDetailForGroup(ArgumentDefinitionGroup argumentDefinitionGroup) {
        if (argumentDefinitionGroup.allHidden()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder);
        if (argumentDefinitionGroup.groupName != null && argumentDefinitionGroup.argumentDefinitions.size() != 0) {
            builder.append(String.format("%nArguments for %s:%n", argumentDefinitionGroup.groupName));
        }
        ArrayList<ArgumentDefinition> argumentDefinitions = new ArrayList<ArgumentDefinition>();
        for (ArgumentDefinition argumentDefinition : argumentDefinitionGroup.argumentDefinitions) {
            if (argumentDefinition.isHidden) continue;
            argumentDefinitions.add(argumentDefinition);
        }
        int argWidth = Math.min(this.findLongestArgumentCallingInfo(argumentDefinitions), 87);
        int docWidth = 120 - argWidth - 3;
        for (ArgumentDefinition argumentDefinition : argumentDefinitions) {
            Iterator<String> wordWrappedArgs = TextFormattingUtils.wordWrap(this.getArgumentCallingInfo(argumentDefinition), argWidth).iterator();
            Iterator<String> wordWrappedDoc = TextFormattingUtils.wordWrap(this.getArgumentDoc(argumentDefinition), docWidth).iterator();
            while (wordWrappedArgs.hasNext() || wordWrappedDoc.hasNext()) {
                String arg = wordWrappedArgs.hasNext() ? wordWrappedArgs.next() : "";
                String doc = wordWrappedDoc.hasNext() ? wordWrappedDoc.next() : "";
                String formatString = "%-" + argWidth + "s%" + 3 + "s%s%n";
                formatter.format(formatString, arg, "", doc);
            }
        }
        return builder.toString();
    }

    private String getArgumentCallingInfo(ArgumentDefinition argumentDefinition) {
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder);
        formatter.format(" ", new Object[0]);
        if (argumentDefinition.shortName != null) {
            formatter.format("-%s,", argumentDefinition.shortName);
        }
        formatter.format("--%s", argumentDefinition.fullName);
        if (!argumentDefinition.isFlag) {
            formatter.format(" <%s>", argumentDefinition.fullName);
        }
        return builder.toString();
    }

    private String getArgumentDoc(ArgumentDefinition argumentDefinition) {
        StringBuilder builder = new StringBuilder();
        builder.append(argumentDefinition.doc);
        if (argumentDefinition.validOptions != null) {
            builder.append(" (");
            builder.append(Utils.join("|", argumentDefinition.validOptions));
            builder.append(")");
        }
        return builder.toString();
    }

    private int findLongestArgumentCallingInfo(Collection<ArgumentDefinition> argumentDefinitions) {
        int longest = 0;
        for (ArgumentDefinition argumentDefinition : argumentDefinitions) {
            String argumentText = this.getArgumentCallingInfo(argumentDefinition);
            if (longest >= argumentText.length()) continue;
            longest = argumentText.length();
        }
        return longest;
    }

    private List<ArgumentDefinitionGroup> prepareArgumentGroups(ArgumentDefinitions argumentDefinitions) {
        Comparator<ArgumentDefinition> definitionComparator = new Comparator<ArgumentDefinition>(){

            @Override
            public int compare(ArgumentDefinition lhs, ArgumentDefinition rhs) {
                if (lhs.required && rhs.required) {
                    return 0;
                }
                if (lhs.required) {
                    return -1;
                }
                if (rhs.required) {
                    return 1;
                }
                return 0;
            }
        };
        ArrayList<ArgumentDefinitionGroup> argumentGroups = new ArrayList<ArgumentDefinitionGroup>();
        for (ArgumentDefinitionGroup argumentGroup : argumentDefinitions.getArgumentDefinitionGroups()) {
            ArrayList<ArgumentDefinition> sortedDefinitions = new ArrayList<ArgumentDefinition>(argumentGroup.argumentDefinitions);
            Collections.sort(sortedDefinitions, definitionComparator);
            argumentGroups.add(new ArgumentDefinitionGroup(argumentGroup.groupName, sortedDefinitions));
        }
        Comparator<ArgumentDefinitionGroup> groupComparator = new Comparator<ArgumentDefinitionGroup>(){

            @Override
            public int compare(ArgumentDefinitionGroup lhs, ArgumentDefinitionGroup rhs) {
                if (lhs.groupName == null && rhs.groupName == null) {
                    return 0;
                }
                if (lhs.groupName == null) {
                    return -1;
                }
                if (rhs.groupName == null) {
                    return 1;
                }
                return lhs.groupName.compareTo(rhs.groupName);
            }
        };
        Collections.sort(argumentGroups, groupComparator);
        return argumentGroups;
    }

    public static void generateHeaderInformation(ApplicationDetails applicationDetails, Map<ArgumentMatchSource, List<String>> parsedArgs) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        String barrier = HelpFormatter.createBarrier(applicationDetails.applicationHeader);
        logger.info(barrier);
        for (String string : applicationDetails.applicationHeader) {
            logger.info(string);
        }
        logger.debug("Current directory: " + System.getProperty("user.dir"));
        for (Map.Entry entry : parsedArgs.entrySet()) {
            String sourceName;
            ArgumentMatchSource matchSource = (ArgumentMatchSource)entry.getKey();
            switch (matchSource.getType()) {
                case CommandLine: {
                    sourceName = "Program";
                    break;
                }
                case File: {
                    sourceName = matchSource.getFile().getPath();
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected argument match source type: " + (Object)((Object)matchSource.getType()));
                }
            }
            String output = sourceName + " Args:";
            for (String str : (List)entry.getValue()) {
                output = output + " " + str;
            }
            logger.info(output);
        }
        logger.info("Date/Time: " + dateFormat.format(date));
        logger.info(barrier);
        for (String string : applicationDetails.attribution) {
            logger.info(string);
        }
        logger.info(barrier);
    }

    private static String createBarrier(List<String> text) {
        int barrierWidth = 0;
        for (String headerLine : text) {
            barrierWidth = Math.max(headerLine.length(), barrierWidth);
        }
        return String.format("%0" + barrierWidth + "d", 0).replace('0', '-');
    }
}

