/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import net.sf.samtools.BAMFileReader;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.BrowseableBAMIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordComparator;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMTextReader;
import net.sf.samtools.util.BlockCompressedInputStream;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.SeekableBufferedStream;
import net.sf.samtools.util.SeekableHTTPStream;
import net.sf.samtools.util.SeekableStream;

public class SAMFileReader
implements Iterable<SAMRecord>,
Closeable {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean mIsBinary = false;
    private BAMIndex mIndex = null;
    private ReaderImplementation mReader = null;
    private File samFile = null;

    public static ValidationStringency getDefaultValidationStringency() {
        return defaultValidationStringency;
    }

    public static void setDefaultValidationStringency(ValidationStringency defaultValidationStringency) {
        SAMFileReader.defaultValidationStringency = defaultValidationStringency;
    }

    public SAMFileReader(InputStream stream) {
        this(stream, false);
    }

    public SAMFileReader(File file) {
        this(file, null, false);
    }

    public SAMFileReader(File file, File indexFile) {
        this(file, indexFile, false);
    }

    public SAMFileReader(InputStream stream, boolean eagerDecode) {
        this.init(stream, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(File file, boolean eagerDecode) {
        this.init(file, null, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(File file, File indexFile, boolean eagerDecode) {
        this.init(file, indexFile, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(URL url, File indexFile, boolean eagerDecode) {
        this.init(new SeekableBufferedStream(new SeekableHTTPStream(url)), indexFile, eagerDecode, defaultValidationStringency);
    }

    public SAMFileReader(SeekableStream strm, File indexFile, boolean eagerDecode) {
        this.init(strm, indexFile, eagerDecode, defaultValidationStringency);
    }

    @Override
    public void close() {
        if (this.mReader != null) {
            this.mReader.close();
        }
        this.mReader = null;
        this.mIndex = null;
    }

    public void enableFileSource(boolean enabled) {
        this.mReader.enableFileSource(this, enabled);
    }

    public void enableIndexCaching(boolean enabled) {
        if (this.mIndex != null) {
            throw new SAMException("Unable to turn on index caching; index file has already been loaded.");
        }
        this.mReader.enableIndexCaching(enabled);
    }

    public void enableCrcChecking(boolean enabled) {
        this.mReader.enableCrcChecking(enabled);
    }

    public boolean isBinary() {
        return this.mIsBinary;
    }

    public boolean hasIndex() {
        return this.mReader.hasIndex();
    }

    public BAMIndex getIndex() {
        return this.mReader.getIndex();
    }

    public boolean hasBrowseableIndex() {
        return this.hasIndex() && this.getIndex() instanceof BrowseableBAMIndex;
    }

    public BrowseableBAMIndex getBrowseableIndex() {
        BAMIndex index = this.getIndex();
        if (!(index instanceof BrowseableBAMIndex)) {
            throw new SAMException("Cannot return index: index created by BAM is not browseable.");
        }
        return (BrowseableBAMIndex)BrowseableBAMIndex.class.cast(index);
    }

    public SAMFileHeader getFileHeader() {
        return this.mReader.getFileHeader();
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.mReader.setValidationStringency(validationStringency);
    }

    public SAMRecordIterator iterator() {
        return new AssertableIterator(this.mReader.getIterator());
    }

    public SAMRecordIterator iterator(SAMFileSpan chunks) {
        return new AssertableIterator(this.mReader.getIterator(chunks));
    }

    public SAMFileSpan getFilePointerSpanningReads() {
        return this.mReader.getFilePointerSpanningReads();
    }

    public SAMRecordIterator query(String sequence, int start, int end, boolean contained) {
        return new AssertableIterator(this.mReader.query(sequence, start, end, contained));
    }

    public SAMRecordIterator queryOverlapping(String sequence, int start, int end) {
        return this.query(sequence, start, end, false);
    }

    public SAMRecordIterator queryContained(String sequence, int start, int end) {
        return this.query(sequence, start, end, true);
    }

    public SAMRecordIterator queryUnmapped() {
        return new AssertableIterator(this.mReader.queryUnmapped());
    }

    public SAMRecordIterator queryAlignmentStart(String sequence, int start) {
        return new AssertableIterator(this.mReader.queryAlignmentStart(sequence, start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAMRecord queryMate(SAMRecord rec) {
        if (!rec.getReadPairedFlag()) {
            throw new IllegalArgumentException("queryMate called for unpaired read.");
        }
        if (rec.getFirstOfPairFlag() == rec.getSecondOfPairFlag()) {
            throw new IllegalArgumentException("SAMRecord must be either first and second of pair, but not both.");
        }
        boolean firstOfPair = rec.getFirstOfPairFlag();
        SAMRecordIterator it = rec.getMateReferenceIndex() == -1 ? this.queryUnmapped() : this.queryAlignmentStart(rec.getMateReferenceName(), rec.getMateAlignmentStart());
        try {
            SAMRecord mateRec = null;
            while (it.hasNext()) {
                SAMRecord next = (SAMRecord)it.next();
                if (!next.getReadPairedFlag()) {
                    if (!rec.getReadName().equals(next.getReadName())) continue;
                    throw new SAMFormatException("Paired and unpaired reads with same name: " + rec.getReadName());
                }
                if ((!firstOfPair ? next.getSecondOfPairFlag() : next.getFirstOfPairFlag()) || !rec.getReadName().equals(next.getReadName())) continue;
                if (mateRec != null) {
                    throw new SAMFormatException("Multiple SAMRecord with read name " + rec.getReadName() + " for " + (firstOfPair ? "second" : "first") + " end.");
                }
                mateRec = next;
            }
            SAMRecord sAMRecord = mateRec;
            return sAMRecord;
        }
        finally {
            it.close();
        }
    }

    private void init(InputStream stream, boolean eagerDecode, ValidationStringency validationStringency) {
        try {
            BufferedInputStream bufferedStream = IOUtil.toBufferedStream(stream);
            if (this.isBAMFile(bufferedStream)) {
                this.mIsBinary = true;
                this.mReader = new BAMFileReader(bufferedStream, null, eagerDecode, validationStringency);
            } else if (this.isGzippedSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedStream), validationStringency);
            } else if (this.isSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedStream, validationStringency);
            } else {
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(validationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void init(SeekableStream strm, File indexFile, boolean eagerDecode, ValidationStringency validationStringency) {
        try {
            if (strm.getSource() != null && !strm.getSource().toLowerCase().endsWith(".bam")) {
                throw new SAMFormatException("Unrecognized file format: " + strm);
            }
            this.mIsBinary = true;
            this.mReader = new BAMFileReader(strm, indexFile, eagerDecode, validationStringency);
            this.setValidationStringency(validationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private void init(File file, File indexFile, boolean eagerDecode, ValidationStringency validationStringency) {
        this.samFile = file;
        try {
            BufferedInputStream bufferedStream = new BufferedInputStream(new FileInputStream(file));
            if (this.isBAMFile(bufferedStream)) {
                this.mIsBinary = true;
                if (!file.isFile()) {
                    this.mReader = new BAMFileReader(bufferedStream, indexFile, eagerDecode, validationStringency);
                } else {
                    bufferedStream.close();
                    BAMFileReader reader = new BAMFileReader(file, indexFile, eagerDecode, validationStringency);
                    this.mReader = reader;
                }
            } else if (this.isGzippedSAMFile(bufferedStream)) {
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(new GZIPInputStream(bufferedStream), validationStringency);
            } else if (this.isSAMFile(bufferedStream)) {
                if (indexFile != null) {
                    bufferedStream.close();
                    throw new RuntimeException("Cannot use index file with textual SAM file");
                }
                this.mIsBinary = false;
                this.mReader = new SAMTextReader(bufferedStream, file, validationStringency);
            } else {
                bufferedStream.close();
                throw new SAMFormatException("Unrecognized file format");
            }
            this.setValidationStringency(validationStringency);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private boolean isBAMFile(InputStream stream) throws IOException {
        return BlockCompressedInputStream.isValidFile(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGzippedSAMFile(BufferedInputStream stream) {
        if (!stream.markSupported()) {
            throw new IllegalArgumentException("Cannot test a stream that doesn't support marking.");
        }
        stream.mark(8000);
        try {
            GZIPInputStream gunzip = new GZIPInputStream(stream);
            int ch = gunzip.read();
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not reset stream.");
            }
        }
    }

    private boolean isSAMFile(InputStream stream) {
        return true;
    }

    public String toString() {
        if (this.samFile == null) {
            return this.getClass().getSimpleName() + "{initialized with stream}";
        }
        return this.getClass().getSimpleName() + "{" + this.samFile.getAbsolutePath() + "}";
    }

    static class AssertableIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> wrappedIterator;
        private SAMRecord previous = null;
        private SAMRecordComparator comparator = null;

        public AssertableIterator(CloseableIterator<SAMRecord> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            if (sortOrder == null || sortOrder == SAMFileHeader.SortOrder.unsorted) {
                this.comparator = null;
                return this;
            }
            this.comparator = sortOrder.getComparatorInstance();
            return this;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = (SAMRecord)this.wrappedIterator.next();
            if (this.comparator != null) {
                if (this.previous != null && this.comparator.fileOrderCompare(this.previous, result) > 0) {
                    throw new IllegalStateException("Records " + this.previous.getReadName() + " (" + this.previous.getReferenceName() + ":" + this.previous.getAlignmentStart() + ") " + "should come after " + result.getReadName() + " (" + result.getReferenceName() + ":" + result.getAlignmentStart() + ") when sorting with " + this.comparator.getClass().getName());
                }
                this.previous = result;
            }
            return result;
        }

        @Override
        public void close() {
            this.wrappedIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }
    }

    static abstract class ReaderImplementation {
        ReaderImplementation() {
        }

        abstract void enableFileSource(SAMFileReader var1, boolean var2);

        abstract void enableIndexCaching(boolean var1);

        abstract void enableCrcChecking(boolean var1);

        abstract boolean hasIndex();

        abstract BAMIndex getIndex();

        abstract SAMFileHeader getFileHeader();

        abstract CloseableIterator<SAMRecord> getIterator();

        abstract CloseableIterator<SAMRecord> getIterator(SAMFileSpan var1);

        abstract SAMFileSpan getFilePointerSpanningReads();

        abstract CloseableIterator<SAMRecord> query(String var1, int var2, int var3, boolean var4);

        abstract CloseableIterator<SAMRecord> queryAlignmentStart(String var1, int var2);

        public abstract CloseableIterator<SAMRecord> queryUnmapped();

        abstract void close();

        abstract void setValidationStringency(ValidationStringency var1);

        abstract ValidationStringency getValidationStringency();
    }

    public static enum ValidationStringency {
        STRICT,
        LENIENT,
        SILENT;

        public static final ValidationStringency DEFAULT_STRINGENCY;

        static {
            DEFAULT_STRINGENCY = STRICT;
        }
    }
}

