/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu;

import edu.unc.bioinf.ubu.fastq.FastqFormatter;
import edu.unc.bioinf.ubu.fastq.Sam2Fastq;
import edu.unc.bioinf.ubu.sam.GenomeToTranscriptome;
import edu.unc.bioinf.ubu.sam.SAMFilter;
import edu.unc.bioinf.ubu.sam.SamConverter;
import edu.unc.bioinf.ubu.sam.SamFileDiff;
import edu.unc.bioinf.ubu.sam.SamSummarizer;
import edu.unc.bioinf.ubu.sam.SpliceJunctionCounter;
import java.util.Arrays;

public class Ubu {
    private static final String TRANSLATE = "sam-xlate";
    private static final String SAM_DIFF = "sam-diff";
    private static final String SAM_FILTER = "sam-filter";
    private static final String SAM_SUMMARIZE = "sam-summary";
    private static final String SAM_CONVERT = "sam-convert";
    private static final String JUNC = "sam-junc";
    private static final String SAM2FASTQ = "sam2fastq";
    private static final String FASTQ_FORMAT = "fastq-format";
    private static final int MAX_CMD_LEN = 15;

    public void run(String[] args) throws Exception {
        if (args.length == 0) {
            this.printAvailablePrograms();
        } else {
            String cmd = args[0];
            String[] argz = Arrays.copyOfRange(args, 1, args.length);
            if (cmd.equals(TRANSLATE)) {
                GenomeToTranscriptome.run(argz);
            } else if (cmd.equals(SAM_DIFF)) {
                SamFileDiff.run(argz);
            } else if (cmd.equals(SAM_FILTER)) {
                SAMFilter.run(argz);
            } else if (cmd.equals(JUNC)) {
                SpliceJunctionCounter.run(argz);
            } else if (cmd.equals(FASTQ_FORMAT)) {
                FastqFormatter.run(argz);
            } else if (cmd.equals(SAM_SUMMARIZE)) {
                SamSummarizer.run(argz);
            } else if (cmd.equals(SAM_CONVERT)) {
                SamConverter.run(argz);
            } else if (cmd.equals(SAM2FASTQ)) {
                Sam2Fastq.run(argz);
            } else {
                System.out.println("Command [" + cmd + "] is unrecognized.");
                this.printAvailablePrograms();
            }
        }
    }

    private void printAvailablePrograms() {
        System.out.println("UNC-Chapel Hill Bioinformatics Utilities");
        System.out.println("Available commands:");
        this.printProgram(this.getPaddedString(TRANSLATE), "Translate from genome to transcriptome coordinates");
        this.printProgram(this.getPaddedString(SAM_DIFF), "Diff two SAM/BAM files outputting discrepant reads in corresponding SAM/BAM files");
        this.printProgram(this.getPaddedString(SAM_FILTER), "Filter reads from a paired end SAM or BAM file (only outputs paired reads)");
        this.printProgram(this.getPaddedString(SAM_SUMMARIZE), "Output summary statistics per reference for a SAM/BAM file (Aligned reads only).");
        this.printProgram(this.getPaddedString(SAM_CONVERT), "Convert SAM/BAM file content (i.e. convert quality from phred64 to phred33)");
        this.printProgram(this.getPaddedString(JUNC), "Count splice junctions in a SAM or BAM file");
        this.printProgram(this.getPaddedString(SAM2FASTQ), "Convert SAM/BAM file to FASTQ");
        this.printProgram(this.getPaddedString(FASTQ_FORMAT), "Format a single FASTQ file (clean up read ids and/or convert quality scoring)");
    }

    private String getPaddedString(String str) {
        int pad = 15 - str.length();
        for (int i = 0; i < pad; ++i) {
            str = str + ' ';
        }
        return str;
    }

    private void printProgram(String name, String desc) {
        System.out.println("\t" + name + "\t" + desc);
    }

    public static void main(String[] args) throws Exception {
        new Ubu().run(args);
    }
}

