/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.util.QualityConverter;
import java.util.Arrays;

public class FastqRecord {
    public static final int NUM_LINES = 4;
    private String[] lines = new String[4];
    private QualityConverter qualityConverter;

    public FastqRecord(String[] lines) {
        if (lines.length != 4) {
            throw new IllegalArgumentException("Invalid number of lines for FastqRecord: [" + Arrays.toString(lines) + "]");
        }
        this.lines = lines;
    }

    FastqRecord(String id, String sequence, String quality) {
        this.lines[0] = id;
        this.lines[1] = sequence;
        this.lines[2] = "+";
        this.lines[3] = quality;
    }

    public String getId() {
        return this.lines[0];
    }

    public String[] getLines() {
        return this.lines;
    }

    public void setQualityConverter(QualityConverter qualityConverter) {
        this.qualityConverter = qualityConverter;
    }

    public String getBaseId() {
        int slashIdx = this.getId().indexOf("/");
        int spaceIdx = this.getId().indexOf(" ");
        if (slashIdx == -1 && spaceIdx == -1) {
            return this.getId();
        }
        int idx = -1;
        idx = slashIdx == -1 ? spaceIdx : (spaceIdx == -1 ? slashIdx : (spaceIdx < slashIdx ? spaceIdx : slashIdx));
        return this.getId().substring(0, idx);
    }

    public boolean hasSameBaseId(FastqRecord rec) {
        return rec != null && this.getBaseId().equals(rec.getBaseId());
    }

    public String toString() {
        return Arrays.toString(this.lines);
    }

    public int hashcode() {
        return Arrays.hashCode(this.lines);
    }

    public boolean equals(Object obj) {
        FastqRecord that = (FastqRecord)obj;
        return Arrays.equals(this.lines, that.lines);
    }

    public void stripNonReadInfoInId() {
        int idx = this.lines[0].indexOf(" ");
        if (idx > 0) {
            this.lines[0] = this.lines[0].substring(0, idx);
        }
    }

    public void appendToId(String suffix) {
        if (!this.lines[0].endsWith(suffix)) {
            this.lines[0] = this.lines[0] + suffix;
        }
    }

    String getQuality() {
        return this.lines[3];
    }

    public String getSequence() {
        return this.lines[1];
    }

    private void setQuality(String quality) {
        this.lines[3] = quality;
    }

    public void phred33To64() {
        if (this.qualityConverter == null) {
            throw new RuntimeException("Please set QualityConverter.");
        }
        String phred33 = this.getQuality();
        this.setQuality(this.qualityConverter.phred33ToPhred64(phred33));
    }
}

