/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.Arrays;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ExtendedEventPileupElement
extends PileupElement {
    private Type type = null;
    private int eventLength = -1;
    private String eventBases = null;
    private SAMRecord read;
    private int offset;

    public ExtendedEventPileupElement(GATKSAMRecord read, int offset, int eventLength, String eventBases, Type type) {
        super(read, offset, type == Type.DELETION, false, false, false, null, -1);
        this.read = read;
        this.offset = offset;
        this.eventLength = eventLength;
        this.eventBases = eventBases;
        this.type = type;
    }

    public ExtendedEventPileupElement(GATKSAMRecord read, int offset, int length, byte[] eventBases) {
        this(read, offset, length, new String(eventBases).toUpperCase(), Type.INSERTION);
    }

    public ExtendedEventPileupElement(GATKSAMRecord read, int offset) {
        this(read, offset, -1, null, Type.NOEVENT);
    }

    public ExtendedEventPileupElement(GATKSAMRecord read, int offset, int length) {
        this(read, offset, length, null, Type.DELETION);
    }

    @Override
    public boolean isDeletion() {
        return this.type == Type.DELETION;
    }

    public boolean isInsertion() {
        return this.type == Type.INSERTION;
    }

    public boolean isIndel() {
        return this.isDeletion() || this.isInsertion();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public byte getBase() {
        return this.getBase(this.offset >= 0 ? this.offset : this.offset + this.eventLength);
    }

    @Override
    public int getBaseIndex() {
        return this.getBaseIndex(this.offset >= 0 ? this.offset : this.offset + this.eventLength);
    }

    @Override
    public byte getQual() {
        return this.getQual(this.offset >= 0 ? this.offset : this.offset + this.eventLength);
    }

    @Override
    public int getEventLength() {
        return this.eventLength;
    }

    @Override
    public String getEventBases() {
        return this.eventBases;
    }

    @Override
    public String toString() {
        char c = '.';
        String fillStr = null;
        if (this.isDeletion()) {
            c = '-';
            char[] filler = new char[this.eventLength];
            Arrays.fill(filler, 'D');
            fillStr = new String(filler);
        } else if (this.isInsertion()) {
            c = '+';
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = this.getRead().getReadName();
        objectArray[1] = this.getOffset();
        objectArray[2] = Character.valueOf(c);
        objectArray[3] = this.isIndel() ? (this.isInsertion() ? this.eventBases : fillStr) : "";
        objectArray[4] = this.getMappingQual();
        return String.format("%s @ %d = %c%s MQ%d", objectArray);
    }

    public static enum Type {
        NOEVENT,
        DELETION,
        INSERTION;

    }
}

