/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public enum GATKReportVersion {
    V0_1("v0.1"),
    V0_2("v0.2");

    public final String versionString;

    private GATKReportVersion(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }

    public static GATKReportVersion fromHeader(String header) {
        if (header.startsWith("##:GATKReport.v0.1 ")) {
            return V0_1;
        }
        if (header.startsWith("##:GATKReport.v0.2 ")) {
            return V0_2;
        }
        throw new ReviewedStingException("Unknown GATK report version in header: " + header);
    }
}

