/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;

public class PileupWalker
extends LocusWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @Output
    PrintStream out;
    @Argument(fullName="showIndelPileups", shortName="show_indels", doc="In addition to base pileups, generate pileups of extended indel events")
    public boolean SHOW_INDEL_PILEUPS = false;
    @Input(fullName="metadata", shortName="metadata", doc="Add these ROD bindings to the output Pileup", required=false)
    public List<RodBinding<Feature>> rods = Collections.emptyList();

    @Override
    public void initialize() {
    }

    @Override
    public boolean generateExtendedEvents() {
        return this.SHOW_INDEL_PILEUPS;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        String rods = this.getReferenceOrderedData(tracker);
        if (context.hasBasePileup()) {
            ReadBackedPileup basePileup = context.getBasePileup();
            this.out.printf("%s %s%n", basePileup.getPileupString(Character.valueOf(ref.getBaseAsChar())), rods);
        }
        if (context.hasExtendedEventPileup()) {
            int i;
            ReadBackedExtendedEventPileup indelPileup = context.getExtendedEventPileup();
            List<Pair<String, Integer>> eventCounts = indelPileup.getEventStringsWithCounts(ref.getBases());
            this.out.printf("%s %s ", indelPileup.getShortPileupString(), rods);
            for (i = 0; i < eventCounts.size() - 1; ++i) {
                this.out.printf("%s:%d,", eventCounts.get((int)i).first, eventCounts.get((int)i).second);
            }
            this.out.printf("%s:%d%n", eventCounts.get((int)i).first, eventCounts.get((int)i).second);
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return this.treeReduce(sum, value);
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    private String getReferenceOrderedData(RefMetaDataTracker tracker) {
        ArrayList<String> rodStrings = new ArrayList<String>();
        for (Feature datum : tracker.getValues(this.rods)) {
            rodStrings.add(datum.toString());
        }
        String rodString = Utils.join(", ", rodStrings);
        if (!rodString.equals("")) {
            rodString = "[ROD: " + rodString + "]";
        }
        return rodString;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.out.println("[REDUCE RESULT] Traversal result is: " + result);
    }
}

