/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.util.ArrayList;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.CallableStatus;
import org.broadinstitute.sting.gatk.walkers.diagnostics.targets.IntervalStatisticLocus;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class IntervalStatistics {
    private final GenomeLoc interval;
    private final ArrayList<IntervalStatisticLocus> loci;
    private final int minimumCoverageThreshold;
    private final int maximumCoverageThreshold;
    private final int minimumMappingQuality;
    private final int minimumBaseQuality;
    private int preComputedTotalCoverage = -1;

    private IntervalStatistics(GenomeLoc interval, ArrayList<IntervalStatisticLocus> loci, int minimumCoverageThreshold, int maximumCoverageThreshold, int minimumMappingQuality, int minimumBaseQuality) {
        this.interval = interval;
        this.loci = loci;
        this.minimumCoverageThreshold = minimumCoverageThreshold;
        this.maximumCoverageThreshold = maximumCoverageThreshold;
        this.minimumMappingQuality = minimumMappingQuality;
        this.minimumBaseQuality = minimumBaseQuality;
    }

    public IntervalStatistics(GenomeLoc interval, int minimumCoverageThreshold, int maximumCoverageThreshold, int minimumMappingQuality, int minimumBaseQuality) {
        this(interval, new ArrayList<IntervalStatisticLocus>(interval.size()), minimumCoverageThreshold, maximumCoverageThreshold, minimumMappingQuality, minimumBaseQuality);
        for (int i = 0; i < interval.size(); ++i) {
            this.loci.add(i, new IntervalStatisticLocus());
        }
    }

    public long totalCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return this.preComputedTotalCoverage;
    }

    public double averageCoverage() {
        if (this.preComputedTotalCoverage < 0) {
            this.calculateTotalCoverage();
        }
        return (double)this.preComputedTotalCoverage / (double)this.loci.size();
    }

    public CallableStatus callableStatus() {
        long max = -1L;
        CallableStatus maxCallableStatus = null;
        HashMap<CallableStatus, Integer> statusCounts = new HashMap<CallableStatus, Integer>(CallableStatus.values().length);
        for (CallableStatus key : CallableStatus.values()) {
            statusCounts.put(key, 0);
        }
        for (int i = 0; i < this.loci.size(); ++i) {
            CallableStatus status = this.callableStatus(i);
            int count = (Integer)statusCounts.get((Object)status) + 1;
            statusCounts.put(status, count);
            if ((long)count <= max) continue;
            max = count;
            maxCallableStatus = status;
        }
        return maxCallableStatus;
    }

    public void addLocus(GenomeLoc locus, IntervalStatisticLocus locusData) {
        if (!this.interval.containsP(locus)) {
            throw new ReviewedStingException(String.format("Locus %s is not part of the Interval", locus));
        }
        int locusIndex = locus.getStart() - this.interval.getStart();
        this.loci.add(locusIndex, locusData);
    }

    private CallableStatus callableStatus(int locusIndex) {
        if (this.loci.get(locusIndex).getCoverage() > this.maximumCoverageThreshold) {
            return CallableStatus.EXCESSIVE_COVERAGE;
        }
        if (this.loci.get(locusIndex).getCoverage() >= this.minimumCoverageThreshold) {
            return CallableStatus.CALLABLE;
        }
        if (this.loci.get(locusIndex).getRawCoverage() >= this.minimumCoverageThreshold) {
            return CallableStatus.POOR_QUALITY;
        }
        if (this.loci.get(locusIndex).getRawCoverage() > 0) {
            return CallableStatus.LOW_COVERAGE;
        }
        return CallableStatus.NO_COVERAGE;
    }

    private void calculateTotalCoverage() {
        this.preComputedTotalCoverage = 0;
        for (IntervalStatisticLocus locus : this.loci) {
            this.preComputedTotalCoverage += locus.getCoverage();
        }
    }
}

