/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

class PreciseNonNegativeDouble
implements Comparable<PreciseNonNegativeDouble> {
    private static final double EQUALS_THRESH = 1.0E-6;
    private static final double INFINITY = Double.POSITIVE_INFINITY;
    private double log10Value;

    public PreciseNonNegativeDouble(double d) {
        this(d, false);
    }

    public PreciseNonNegativeDouble(double d, boolean isLog10) {
        if (isLog10) {
            this.log10Value = d;
        } else {
            if (d < 0.0) {
                throw new IllegalArgumentException("non-log PreciseNonNegativeDouble argument must be non-negative");
            }
            this.log10Value = Math.log10(d);
        }
    }

    public PreciseNonNegativeDouble(PreciseNonNegativeDouble pd) {
        this.log10Value = pd.log10Value;
    }

    public double getValue() {
        return Math.pow(10.0, this.log10Value);
    }

    public double getLog10Value() {
        return this.log10Value;
    }

    public PreciseNonNegativeDouble setEqual(PreciseNonNegativeDouble other) {
        this.log10Value = other.log10Value;
        return this;
    }

    public PreciseNonNegativeDouble plus(PreciseNonNegativeDouble other) {
        return new PreciseNonNegativeDouble(this).plusEqual(other);
    }

    public PreciseNonNegativeDouble times(PreciseNonNegativeDouble other) {
        return new PreciseNonNegativeDouble(this).timesEqual(other);
    }

    public PreciseNonNegativeDouble div(PreciseNonNegativeDouble other) {
        return new PreciseNonNegativeDouble(this).divEqual(other);
    }

    public PreciseNonNegativeDouble absDiff(PreciseNonNegativeDouble other) {
        return new PreciseNonNegativeDouble(this.absSubLog(this.log10Value, other.log10Value), true);
    }

    @Override
    public int compareTo(PreciseNonNegativeDouble other) {
        double logValDiff = this.log10Value - other.log10Value;
        if (Math.abs(logValDiff) <= 1.0E-6) {
            return 0;
        }
        return new Double(Math.signum(logValDiff)).intValue();
    }

    public boolean equals(PreciseNonNegativeDouble other) {
        return this.compareTo(other) == 0;
    }

    public boolean gt(PreciseNonNegativeDouble other) {
        return this.compareTo(other) > 0;
    }

    public boolean lt(PreciseNonNegativeDouble other) {
        return this.compareTo(other) < 0;
    }

    public PreciseNonNegativeDouble plusEqual(PreciseNonNegativeDouble other) {
        this.log10Value = PreciseNonNegativeDouble.addInLogSpace(this.log10Value, other.log10Value);
        return this;
    }

    public PreciseNonNegativeDouble timesEqual(PreciseNonNegativeDouble other) {
        this.log10Value += other.log10Value;
        return this;
    }

    public PreciseNonNegativeDouble divEqual(PreciseNonNegativeDouble other) {
        this.log10Value -= other.log10Value;
        return this;
    }

    private static double addInLogSpace(double x, double y) {
        double negDiff;
        double maxVal;
        if (x == Double.POSITIVE_INFINITY || y == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return y;
        }
        if (y == Double.NEGATIVE_INFINITY) {
            return x;
        }
        if (x > y) {
            maxVal = x;
            negDiff = y - x;
        } else {
            maxVal = y;
            negDiff = x - y;
        }
        return maxVal + Math.log10(1.0 + Math.pow(10.0, negDiff));
    }

    private double absSubLog(double x, double y) {
        if (x == Double.NEGATIVE_INFINITY && y == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (x >= y) {
            return x + Math.log10(1.0 - Math.pow(10.0, y - x));
        }
        return y + Math.log10(1.0 - Math.pow(10.0, x - y));
    }

    public String toString() {
        return "" + this.getValue();
    }
}

