/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.samples.Sample;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.MendelianViolation;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Mendelian Violation Evaluator", description="Mendelian Violation Evaluator")
public class MendelianViolationEvaluator
extends VariantEvaluator {
    @DataPoint(description="Number of variants found with at least one family having genotypes")
    long nVariants;
    @DataPoint(description="Number of variants found with no family having genotypes -- these sites do not count in the nNoCall")
    long nSkipped;
    @DataPoint(description="Number of variants x families called (no missing genotype or lowqual)")
    long nFamCalled;
    @DataPoint(description="Number of variants x families called (no missing genotype or lowqual) that contain at least one var allele.")
    long nVarFamCalled;
    @DataPoint(description="Number of variants x families discarded as low quality")
    long nLowQual;
    @DataPoint(description="Number of variants x families discarded as no call")
    long nNoCall;
    @DataPoint(description="Number of loci with mendelian violations")
    long nLociViolations;
    @DataPoint(description="Number of mendelian violations found")
    long nViolations;
    @DataPoint(description="Number of mendelian violations of the type HOM_REF/HOM_REF -> HOM_VAR")
    long mvRefRef_Var;
    @DataPoint(description="Number of mendelian violations of the type HOM_REF/HOM_REF -> HET")
    long mvRefRef_Het;
    @DataPoint(description="Number of mendelian violations of the type HOM_REF/HET -> HOM_VAR")
    long mvRefHet_Var;
    @DataPoint(description="Number of mendelian violations of the type HOM_REF/HOM_VAR -> HOM_VAR")
    long mvRefVar_Var;
    @DataPoint(description="Number of mendelian violations of the type HOM_REF/HOM_VAR -> HOM_REF")
    long mvRefVar_Ref;
    @DataPoint(description="Number of mendelian violations of the type HOM_VAR/HET -> HOM_REF")
    long mvVarHet_Ref;
    @DataPoint(description="Number of mendelian violations of the type HOM_VAR/HOM_VAR -> HOM_REF")
    long mvVarVar_Ref;
    @DataPoint(description="Number of mendelian violations of the type HOM_VAR/HOM_VAR -> HET")
    long mvVarVar_Het;
    @DataPoint(description="Number of HomRef/HomRef/HomRef trios")
    long HomRefHomRef_HomRef;
    @DataPoint(description="Number of Het/Het/Het trios")
    long HetHet_Het;
    @DataPoint(description="Number of Het/Het/HomRef trios")
    long HetHet_HomRef;
    @DataPoint(description="Number of Het/Het/HomVar trios")
    long HetHet_HomVar;
    @DataPoint(description="Number of HomVar/HomVar/HomVar trios")
    long HomVarHomVar_HomVar;
    @DataPoint(description="Number of HomRef/HomVar/Het trios")
    long HomRefHomVAR_Het;
    @DataPoint(description="Number of ref alleles inherited from het/het parents")
    long HetHet_inheritedRef;
    @DataPoint(description="Number of var alleles inherited from het/het parents")
    long HetHet_inheritedVar;
    @DataPoint(description="Number of ref alleles inherited from homRef/het parents")
    long HomRefHet_inheritedRef;
    @DataPoint(description="Number of var alleles inherited from homRef/het parents")
    long HomRefHet_inheritedVar;
    @DataPoint(description="Number of ref alleles inherited from homVar/het parents")
    long HomVarHet_inheritedRef;
    @DataPoint(description="Number of var alleles inherited from homVar/het parents")
    long HomVarHet_inheritedVar;
    MendelianViolation mv;
    PrintStream mvFile;
    Map<String, Set<Sample>> families;

    @Override
    public void initialize(VariantEvalWalker walker) {
        this.mv = new MendelianViolation(walker.getMendelianViolationQualThreshold(), false);
        this.families = walker.getSampleDB().getFamilies();
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String getName() {
        return "mendelian_violations";
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public String update1(VariantContext vc, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (vc.isBiallelic() && vc.hasGenotypes()) {
            if (this.mv.countViolations(this.families, vc) > 0) {
                ++this.nLociViolations;
                this.nViolations += (long)this.mv.getViolationsCount();
                this.mvRefRef_Var += (long)this.mv.getParentsRefRefChildVar();
                this.mvRefRef_Het += (long)this.mv.getParentsRefRefChildHet();
                this.mvRefHet_Var += (long)this.mv.getParentsRefHetChildVar();
                this.mvRefVar_Var += (long)this.mv.getParentsRefVarChildVar();
                this.mvRefVar_Ref += (long)this.mv.getParentsRefVarChildRef();
                this.mvVarHet_Ref += (long)this.mv.getParentsVarHetChildRef();
                this.mvVarVar_Ref += (long)this.mv.getParentsVarVarChildRef();
                this.mvVarVar_Het += (long)this.mv.getParentsVarVarChildHet();
            }
            this.HomRefHomRef_HomRef += (long)this.mv.getRefRefRef();
            this.HetHet_Het += (long)this.mv.getHetHetHet();
            this.HetHet_HomRef += (long)this.mv.getHetHetHomRef();
            this.HetHet_HomVar += (long)this.mv.getHetHetHomVar();
            this.HomVarHomVar_HomVar += (long)this.mv.getVarVarVar();
            this.HomRefHomVAR_Het += (long)this.mv.getRefVarHet();
            this.HetHet_inheritedRef += (long)this.mv.getParentsHetHetInheritedRef();
            this.HetHet_inheritedVar += (long)this.mv.getParentsHetHetInheritedVar();
            this.HomRefHet_inheritedRef += (long)this.mv.getParentsRefHetInheritedRef();
            this.HomRefHet_inheritedVar += (long)this.mv.getParentsRefHetInheritedVar();
            this.HomVarHet_inheritedRef += (long)this.mv.getParentsVarHetInheritedRef();
            this.HomVarHet_inheritedVar += (long)this.mv.getParentsVarHetInheritedVar();
            if (this.mv.getFamilyCalledCount() > 0) {
                ++this.nVariants;
                this.nFamCalled += (long)this.mv.getFamilyCalledCount();
                this.nLowQual += (long)this.mv.getFamilyLowQualsCount();
                this.nNoCall += (long)this.mv.getFamilyNoCallCount();
                this.nVarFamCalled += (long)this.mv.getVarFamilyCalledCount();
            } else {
                ++this.nSkipped;
            }
            return null;
        }
        return null;
    }
}

