/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.datasources.providers.LocusShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.LocusView;
import org.broadinstitute.sting.gatk.iterators.GenomeLocusIterator;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class AllLocusView
extends LocusView {
    private GenomeLocusIterator locusIterator;
    private GenomeLoc nextPosition = null;
    private AlignmentContext nextLocus = null;
    private boolean atNextElement = false;
    private static final List<GATKSAMRecord> EMPTY_PILEUP_READS = Collections.emptyList();
    private static final List<Integer> EMPTY_PILEUP_OFFSETS = Collections.emptyList();

    public AllLocusView(LocusShardDataProvider provider) {
        super(provider);
        this.locusIterator = new GenomeLocusIterator(this.genomeLocParser, provider.getLocus());
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.nextPosition != null;
    }

    @Override
    public AlignmentContext next() {
        this.advance();
        if (this.nextPosition == null) {
            throw new NoSuchElementException("No next is available in the all locus view");
        }
        this.atNextElement = false;
        AlignmentContext currentLocus = this.nextLocus != null && this.nextLocus.getLocation().equals(this.nextPosition) ? this.nextLocus : this.createEmptyLocus(this.nextPosition);
        return currentLocus;
    }

    private void advance() {
        if (this.atNextElement) {
            return;
        }
        if (this.nextPosition == null && !this.locusIterator.hasNext()) {
            return;
        }
        if (this.nextPosition != null && this.nextLocus != null && !this.nextLocus.getLocation().isPast(this.nextPosition)) {
            this.nextLocus = null;
            if (this.hasNextLocus()) {
                this.nextLocus = this.nextLocus();
                if (this.nextPosition.equals(this.nextLocus.getLocation())) {
                    this.atNextElement = true;
                    return;
                }
            }
        }
        if (!this.locusIterator.hasNext()) {
            this.nextPosition = null;
            return;
        }
        this.nextPosition = this.locusIterator.next();
        this.atNextElement = true;
        while (this.nextLocus == null || this.nextLocus.getLocation().isBefore(this.nextPosition)) {
            this.nextLocus = null;
            if (!this.hasNextLocus()) break;
            this.nextLocus = this.nextLocus();
        }
    }

    private AlignmentContext createEmptyLocus(GenomeLoc site) {
        return new AlignmentContext(site, new ReadBackedPileupImpl(site, EMPTY_PILEUP_READS, EMPTY_PILEUP_OFFSETS));
    }
}

