/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.fastq;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class Sam2FastqOptions
extends Options {
    private static final String INPUT_SAM = "in";
    private static final String FASTQ1 = "fastq1";
    private static final String FASTQ2 = "fastq2";
    private static final String END1_SUFFIX = "end1";
    private static final String END2_SUFFIX = "end2";
    private OptionParser parser;
    private boolean isValid;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(INPUT_SAM, "Required input sam or bam file").withRequiredArg().ofType(String.class);
            this.parser.accepts(FASTQ1, "Required output FASTQ file").withRequiredArg().ofType(String.class);
            this.parser.accepts(FASTQ2, "Second FASTQ file for paired end").withRequiredArg().ofType(String.class);
            this.parser.accepts(END1_SUFFIX, "Id suffix used to identify the first read in a pair.  i.e. /1 (omit this option to use bit flag)").withRequiredArg().ofType(String.class);
            this.parser.accepts(END2_SUFFIX, "Id suffix used to identify the second read in a pair.  i.e. /2 (omit this option to use bit flag)").withRequiredArg().ofType(String.class);
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(INPUT_SAM)) {
            this.isValid = false;
            System.err.println("Missing required input SAM/BAM file");
        }
        if (!this.getOptions().hasArgument(FASTQ1)) {
            this.isValid = false;
            System.err.println("Missing required output SAM/BAM file");
        }
        if (this.getOptions().has(END1_SUFFIX) && !this.getOptions().has(FASTQ2)) {
            this.isValid = false;
            System.err.println("end1 only applicable for paired end.");
        }
        if (this.getOptions().has(END2_SUFFIX) && !this.getOptions().has(FASTQ2)) {
            this.isValid = false;
            System.err.println("end2 only applicable for paired end.");
        }
        if (this.getOptions().has(END1_SUFFIX) && !this.getOptions().has(END2_SUFFIX) || !this.getOptions().has(END1_SUFFIX) && this.getOptions().has(END2_SUFFIX)) {
            this.isValid = false;
            System.err.println("Please either specify both end1 and end2 or neither.");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public String getInputFile() {
        return (String)this.getOptions().valueOf(INPUT_SAM);
    }

    public String getFastq1() {
        return (String)this.getOptions().valueOf(FASTQ1);
    }

    public String getFastq2() {
        return (String)this.getOptions().valueOf(FASTQ2);
    }

    public boolean isPairedEnd() {
        return this.getOptions().hasArgument(FASTQ2);
    }

    public boolean shouldIdEndByReadName() {
        return this.getOptions().hasArgument(END1_SUFFIX);
    }

    public String getEnd1Suffix() {
        return (String)this.getOptions().valueOf(END1_SUFFIX);
    }

    public String getEnd2Suffix() {
        return (String)this.getOptions().valueOf(END2_SUFFIX);
    }

    public boolean isValid() {
        return this.isValid;
    }
}

