/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.SamFileDiffOptions;
import edu.unc.bioinf.ubu.sam.SamMultiMappingReader;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import org.apache.commons.lang.StringUtils;

public class SamFileDiff {
    private SAMRecord cachedRead1;
    private SAMRecord cachedRead2;
    private SAMRecordComparator comparator = new SAMRecordComparator();
    private List<SAMRecord> cachedReadList1;
    private List<SAMRecord> cachedReadList2;
    private Iterator<List<SAMRecord>> iter1;
    private Iterator<List<SAMRecord>> iter2;
    private boolean isReadIdComparisonOnly;

    public void diff(String samInputFileName1, String samInputFileName2, String samOutputFileName1, String samOutputFileName2) {
        System.out.println("in1:\t" + samInputFileName1);
        System.out.println("in2:\t" + samInputFileName2);
        System.out.println("out1:\t" + samOutputFileName1);
        System.out.println("out2:\t" + samOutputFileName2);
        SamMultiMappingReader in1 = new SamMultiMappingReader(samInputFileName1);
        SamMultiMappingReader in2 = new SamMultiMappingReader(samInputFileName2);
        SAMFileHeader header1 = in1.getFileHeader();
        header1.setSortOrder(SAMFileHeader.SortOrder.unsorted);
        SAMFileHeader header2 = in2.getFileHeader();
        header2.setSortOrder(SAMFileHeader.SortOrder.unsorted);
        SAMFileWriter out1 = new SAMFileWriterFactory().makeSAMOrBAMWriter(header1, true, new File(samOutputFileName1));
        SAMFileWriter out2 = new SAMFileWriterFactory().makeSAMOrBAMWriter(header2, true, new File(samOutputFileName2));
        this.iter1 = in1.iterator();
        this.iter2 = in2.iterator();
        while (this.hasNextList1() && this.hasNextList2()) {
            List<SAMRecord> readList1 = this.getNextList1();
            List<SAMRecord> readList2 = this.getNextList2();
            int compare = this.compareReadNames(readList1.get(0), readList2.get(0));
            if (compare < 0) {
                this.addAlignments(out1, readList1);
                this.cachedReadList2 = readList2;
                continue;
            }
            if (compare > 0) {
                this.addAlignments(out2, readList2);
                this.cachedReadList1 = readList1;
                continue;
            }
            if (this.isReadIdComparisonOnly) continue;
            this.diffReadLists(readList1, readList2, out1, out2);
        }
        while (this.hasNextList1()) {
            this.addAlignments(out1, this.getNextList1());
        }
        while (this.hasNextList2()) {
            this.addAlignments(out2, this.getNextList2());
        }
        out1.close();
        out2.close();
    }

    public void setReadIdComparisonOnly(boolean isReadIdComparisonOnly) {
        this.isReadIdComparisonOnly = isReadIdComparisonOnly;
    }

    private void addAlignments(SAMFileWriter out, List<SAMRecord> reads) {
        for (SAMRecord read : reads) {
            out.addAlignment(read);
        }
    }

    private boolean hasNextList1() {
        return this.cachedReadList1 != null || this.iter1.hasNext();
    }

    private boolean hasNextList2() {
        return this.cachedReadList2 != null || this.iter2.hasNext();
    }

    private List<SAMRecord> getNextList1() {
        List<SAMRecord> list;
        if (this.cachedReadList1 != null) {
            list = this.cachedReadList1;
            this.cachedReadList1 = null;
        } else {
            list = this.iter1.next();
        }
        return list;
    }

    private List<SAMRecord> getNextList2() {
        List<SAMRecord> list;
        if (this.cachedReadList2 != null) {
            list = this.cachedReadList2;
            this.cachedReadList2 = null;
        } else {
            list = this.iter2.next();
        }
        return list;
    }

    private boolean hasNextRead1(Iterator<SAMRecord> iter) {
        return this.cachedRead1 != null || iter.hasNext();
    }

    private boolean hasNextRead2(Iterator<SAMRecord> iter) {
        return this.cachedRead2 != null || iter.hasNext();
    }

    private SAMRecord getNextRead1(Iterator<SAMRecord> iter) {
        SAMRecord read = null;
        if (this.cachedRead1 != null) {
            read = this.cachedRead1;
            this.cachedRead1 = null;
        } else {
            read = iter.next();
        }
        return read;
    }

    private SAMRecord getNextRead2(Iterator<SAMRecord> iter) {
        SAMRecord read = null;
        if (this.cachedRead2 != null) {
            read = this.cachedRead2;
            this.cachedRead2 = null;
        } else {
            read = iter.next();
        }
        return read;
    }

    private void diffReadLists(List<SAMRecord> readList1, List<SAMRecord> readList2, SAMFileWriter out1, SAMFileWriter out2) {
        SAMRecord read1;
        Collections.sort(readList1, this.comparator);
        Collections.sort(readList2, this.comparator);
        Iterator<SAMRecord> iter1 = readList1.iterator();
        Iterator<SAMRecord> iter2 = readList2.iterator();
        while (this.hasNextRead1(iter1) && this.hasNextRead2(iter2)) {
            read1 = this.getNextRead1(iter1);
            SAMRecord read2 = this.getNextRead2(iter2);
            int compare = read1.getSAMString().compareTo(read2.getSAMString());
            if (compare < 0) {
                out1.addAlignment(read1);
                this.cachedRead2 = read2;
                continue;
            }
            if (compare <= 0) continue;
            out2.addAlignment(read2);
            this.cachedRead1 = read1;
        }
        while (this.hasNextRead1(iter1)) {
            read1 = this.getNextRead1(iter1);
            out1.addAlignment(read1);
        }
        while (this.hasNextRead2(iter2)) {
            SAMRecord read2 = this.getNextRead2(iter2);
            out2.addAlignment(read2);
        }
        this.cachedRead1 = null;
        this.cachedRead2 = null;
    }

    private int compareReadNames(SAMRecord read1, SAMRecord read2) {
        int compare = 0;
        String[] name1 = read1.getReadName().split("[:/]");
        String[] name2 = read2.getReadName().split("[:/]");
        for (int idx = 0; idx < name1.length && idx < name2.length && compare == 0; ++idx) {
            if (StringUtils.isNumeric(name1[idx]) && StringUtils.isNumeric(name2[idx])) {
                int field1 = Integer.parseInt(name1[idx]);
                int field2 = Integer.parseInt(name2[idx]);
                compare = field1 - field2;
                continue;
            }
            compare = name1[idx].compareTo(name2[idx]);
        }
        return compare;
    }

    public static void run(String[] args) {
        SamFileDiffOptions options = new SamFileDiffOptions();
        options.parseOptions(args);
        if (options.isValid()) {
            long s = System.currentTimeMillis();
            SamFileDiff diff = new SamFileDiff();
            diff.setReadIdComparisonOnly(options.isReadIdComparisonOnly());
            diff.diff(options.getInput1File(), options.getInput2File(), options.getOutput1File(), options.getOutput2File());
            long e = System.currentTimeMillis();
            System.out.println("Done.  Elapsed secs: " + (e - s) / 1000L);
        }
    }

    static class SAMRecordComparator
    implements Comparator<SAMRecord> {
        SAMRecordComparator() {
        }

        @Override
        public int compare(SAMRecord read1, SAMRecord read2) {
            return read1.getSAMString().compareTo(read2.getSAMString());
        }
    }
}

