/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.util.Options;
import joptsimple.OptionParser;

public class SamFilterOptions
extends Options {
    private static final String INPUT_FILE = "in";
    private static final String OUTPUT_FILE = "out";
    private static final String STRIP_INDELS = "strip-indels";
    private static final String MAX_INSERT_LEN = "max-insert";
    private static final String MAPPING_QUALITY = "mapq";
    private static final String SINGLE_END = "single";
    private static final String INCLUDE_INDELS_ONLY = "indels-only";
    private OptionParser parser;
    private boolean isValid;

    @Override
    protected OptionParser getOptionParser() {
        if (this.parser == null) {
            this.parser = new OptionParser();
            this.parser.accepts(INPUT_FILE, "Required input sam or bam file").withRequiredArg().ofType(String.class);
            this.parser.accepts(OUTPUT_FILE, "Required output sam or bam file").withRequiredArg().ofType(String.class);
            this.parser.accepts(SINGLE_END, "If specified, process bam as single end, discarding reads independently (default paired end)");
            this.parser.accepts(STRIP_INDELS, "If specified, discard read pairs containing indels from output (default off)");
            this.parser.accepts(MAX_INSERT_LEN, "If specified, discard clusters greater than specified insert length").withRequiredArg().ofType(Integer.class);
            this.parser.accepts(MAPPING_QUALITY, "If specified, discard clusters with mapping quality less than the specified value").withRequiredArg().ofType(Integer.class);
            this.parser.accepts(INCLUDE_INDELS_ONLY, "If specified, discard reads not containing indels (default off)");
        }
        return this.parser;
    }

    @Override
    protected void validate() {
        this.isValid = true;
        if (!this.getOptions().hasArgument(INPUT_FILE)) {
            this.isValid = false;
            System.err.println("Missing required input SAM/BAM file");
        }
        if (!this.getOptions().hasArgument(OUTPUT_FILE)) {
            this.isValid = false;
            System.err.println("Missing required output SAM/BAM file");
        }
        if (!(this.getOptions().has(STRIP_INDELS) || this.getOptions().hasArgument(MAX_INSERT_LEN) || this.getOptions().hasArgument(MAPPING_QUALITY) || this.getOptions().has(INCLUDE_INDELS_ONLY) || !this.getOptions().has(SINGLE_END))) {
            this.isValid = false;
            System.err.println("At least one filtering option must be specified");
        }
        if (this.getOptions().has(STRIP_INDELS) && this.getOptions().has(INCLUDE_INDELS_ONLY)) {
            this.isValid = false;
            System.err.println("Cannot specify both strip-indels and indels-only");
        }
        if (!this.isValid) {
            this.printHelp();
        }
    }

    public String getInputFile() {
        return (String)this.getOptions().valueOf(INPUT_FILE);
    }

    public String getOutputFile() {
        return (String)this.getOptions().valueOf(OUTPUT_FILE);
    }

    public boolean shouldStripIndels() {
        return this.getOptions().has(STRIP_INDELS);
    }

    public boolean shouldIncludeIndelsOnly() {
        return this.getOptions().has(INCLUDE_INDELS_ONLY);
    }

    public boolean isPairedEnd() {
        return !this.getOptions().has(SINGLE_END);
    }

    public int getMaxInsertLen() {
        int maxLen = -1;
        if (this.getOptions().hasArgument(MAX_INSERT_LEN)) {
            maxLen = (Integer)this.getOptions().valueOf(MAX_INSERT_LEN);
        }
        return maxLen;
    }

    public int getMinMappingQuality() {
        int minMapQ = -1;
        if (this.getOptions().hasArgument(MAPPING_QUALITY)) {
            minMapQ = (Integer)this.getOptions().valueOf(MAPPING_QUALITY);
        }
        return minMapQ;
    }

    public boolean isValid() {
        return this.isValid;
    }
}

