/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.SpliceJunction;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpliceJunctionMap {
    private Map<SpliceJunction, String> junctions = new HashMap<SpliceJunction, String>();
    private List<SpliceJunction> junctionList = new ArrayList<SpliceJunction>();

    public SpliceJunctionMap(String junctionFile) throws FileNotFoundException, IOException {
        this.init(junctionFile);
    }

    public List<SpliceJunction> getAllSpliceJunctions() {
        return this.junctionList;
    }

    public void init(String junctionFile) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(junctionFile));
        String line = reader.readLine();
        while (line != null) {
            String[] range = line.split(",");
            if (range.length != 2) {
                throw new IllegalArgumentException("Invalid splice junction format: [" + line + "]");
            }
            String[] start = range[0].split(":");
            String[] stop = range[1].split(":");
            if (start.length != 3 || stop.length != 3) {
                throw new IllegalArgumentException("Invalid splice junction format: [" + line + "]");
            }
            String startChromosome = start[0];
            int startPos = this.toInt(start[1], line);
            String startStrand = start[2];
            String stopChromosome = stop[0];
            int stopPos = this.toInt(stop[1], line);
            String stopStrand = stop[2];
            if (!startChromosome.equals(stopChromosome) || !startStrand.equals(stopStrand)) {
                throw new IllegalArgumentException("Invalid splice junction format: [" + line + "]");
            }
            if (startPos > stopPos) {
                int temp = startPos;
                startPos = stopPos;
                stopPos = temp;
            }
            SpliceJunction junction = new SpliceJunction(startChromosome, startPos + 1, stopPos - 1);
            this.junctions.put(junction, line);
            this.junctionList.add(junction);
            line = reader.readLine();
        }
        reader.close();
    }

    private int toInt(String value, String line) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid splice junction format: [" + line + "]");
        }
    }

    public String getJunctionKey(SpliceJunction junction) {
        return this.junctions.get(junction);
    }

    public static void main(String[] args) throws Exception {
        SpliceJunctionMap map = new SpliceJunctionMap("/home/lisle/gaf/splice_junctions.txt");
        System.out.println("Size: " + map.junctions.size());
    }
}

