/*
 * Decompiled with CFR 0.152.
 */
package edu.unc.bioinf.ubu.sam;

import edu.unc.bioinf.ubu.sam.IsoformGeneMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;

public class GeneReadCounterBWA {
    private Map<String, Long> totalGeneCounts = new HashMap<String, Long>();
    private Map<String, Long> uniqueGeneCounts = new HashMap<String, Long>();
    private IsoformGeneMap isoformGeneMap = new IsoformGeneMap();
    private static final Long ONE = 1L;
    private static final Long ZERO = 0L;

    public void count(IsoformGeneMap isoformGeneMap, String inputSam, String outputFile) throws IOException {
        this.isoformGeneMap = isoformGeneMap;
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, false));
        this.countGenes(inputSam);
        this.outputCounts(writer);
        writer.close();
    }

    private void countGenes(String inputFile) {
        File file = new File(inputFile);
        SAMFileReader reader = new SAMFileReader(file);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        int cnt = 0;
        for (SAMRecord read : reader) {
            if (!read.getReadUnmappedFlag()) {
                String xaTag;
                HashSet<String> genes = new HashSet<String>();
                String isoform = read.getReferenceName();
                String gene = this.isoformGeneMap.getGene(isoform);
                genes.add(gene);
                int x0 = 1;
                Integer x0Tag = read.getIntegerAttribute("X0");
                if (x0Tag != null) {
                    x0 = x0Tag;
                }
                if ((xaTag = read.getStringAttribute("XA")) != null) {
                    String[] isos;
                    for (String iso : isos = xaTag.split(";")) {
                        String[] fields = iso.split(",");
                        if (fields.length <= 0) continue;
                        String isoId = fields[0];
                        String geneId = this.isoformGeneMap.getGene(isoId);
                        genes.add(geneId);
                    }
                }
                if (genes.size() == 1 && x0 < 100) {
                    this.incrementCount(this.uniqueGeneCounts, gene);
                }
                this.incrementCount(this.totalGeneCounts, gene);
            }
            if (cnt++ % 1000000 != 0) continue;
            System.out.println("Processed " + cnt + " reads.");
        }
    }

    private void outputCounts(BufferedWriter writer) throws IOException {
        List<String> genes = this.isoformGeneMap.getSortedGeneList();
        for (String gene : genes) {
            StringBuffer line = new StringBuffer();
            long totalCount = this.getCount(this.totalGeneCounts, gene);
            long uniqueCount = this.getCount(this.uniqueGeneCounts, gene);
            line.append(gene);
            line.append('\t');
            line.append(totalCount);
            line.append('\t');
            line.append(uniqueCount);
            line.append('\n');
            writer.write(line.toString());
        }
    }

    private void incrementCount(Map<String, Long> counts, String gene) {
        Long count = counts.get(gene);
        if (count == null) {
            counts.put(gene, ONE);
        } else {
            counts.put(gene, count + 1L);
        }
    }

    private long getCount(Map<String, Long> counts, String gene) {
        Long count = counts.get(gene);
        if (count == null) {
            count = ZERO;
        }
        return count;
    }

    public static void main(String[] args) throws IOException {
        String isoformGeneFile = args[0];
        String input = args[1];
        String output = args[2];
        long s = System.currentTimeMillis();
        IsoformGeneMap isoformGeneMap = new IsoformGeneMap();
        isoformGeneMap.init(isoformGeneFile);
        new GeneReadCounterBWA().count(isoformGeneMap, input, output);
        long e = System.currentTimeMillis();
        System.out.println("Done.  Elapsed secs: " + (e - s) / 1000L);
    }
}

