/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa.java;

import java.io.File;
import java.io.FileNotFoundException;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.alignment.Alignment;
import org.broadinstitute.sting.alignment.bwa.java.AlignmentState;
import org.broadinstitute.sting.alignment.bwa.java.BWAAlignment;
import org.broadinstitute.sting.alignment.bwa.java.BWAJavaAligner;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class AlignerTestHarness {
    public static void main(String[] argv) throws FileNotFoundException {
        if (argv.length != 6) {
            System.out.println("PerfectAlignerTestHarness <fasta> <bwt> <rbwt> <sa> <rsa> <bam>");
            System.exit(1);
        }
        File referenceFile = new File(argv[0]);
        File bwtFile = new File(argv[1]);
        File rbwtFile = new File(argv[2]);
        File suffixArrayFile = new File(argv[3]);
        File reverseSuffixArrayFile = new File(argv[4]);
        File bamFile = new File(argv[5]);
        AlignerTestHarness.align(referenceFile, bwtFile, rbwtFile, suffixArrayFile, reverseSuffixArrayFile, bamFile);
    }

    private static void align(File referenceFile, File bwtFile, File rbwtFile, File suffixArrayFile, File reverseSuffixArrayFile, File bamFile) throws FileNotFoundException {
        BWAJavaAligner aligner = new BWAJavaAligner(bwtFile, rbwtFile, suffixArrayFile, reverseSuffixArrayFile);
        int count = 0;
        SAMFileReader reader = new SAMFileReader(bamFile);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        int mismatches = 0;
        int failures = 0;
        for (SAMRecord read : reader) {
            if (++count > 200000) break;
            SAMRecord alignmentCleaned = null;
            try {
                alignmentCleaned = (SAMRecord)read.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new ReviewedStingException("SAMRecord clone not supported", ex);
            }
            if (alignmentCleaned.getReadNegativeStrandFlag()) {
                alignmentCleaned.setReadBases(BaseUtils.simpleReverseComplement(alignmentCleaned.getReadBases()));
            }
            alignmentCleaned.setReferenceIndex(-1);
            alignmentCleaned.setAlignmentStart(0);
            alignmentCleaned.setMappingQuality(0);
            alignmentCleaned.setCigarString("*");
            alignmentCleaned.setFlags(alignmentCleaned.getFlags() & 0xA1 | 0xC);
            Iterable<Alignment[]> alignments = aligner.getAllAlignments(alignmentCleaned.getReadBases());
            if (!alignments.iterator().hasNext()) {
                System.out.printf("Unable to align read %s to reference; count = %d%n", read.getReadName(), count);
                ++failures;
            }
            Alignment foundAlignment = null;
            for (Alignment[] alignmentsOfQuality : alignments) {
                for (Alignment alignment : alignmentsOfQuality) {
                    if (read.getReadNegativeStrandFlag() != alignment.isNegativeStrand() || (long)read.getAlignmentStart() != alignment.getAlignmentStart()) continue;
                    foundAlignment = alignment;
                }
            }
            if (foundAlignment == null) {
                System.out.printf("Error aligning read %s%n", read.getReadName());
                ++mismatches;
                IndexedFastaSequenceFile reference = new IndexedFastaSequenceFile(referenceFile);
                System.out.printf("read          = %s, position = %d, negative strand = %b%n", AlignerTestHarness.formatBasesBasedOnCigar(read.getReadString(), read.getCigar(), CigarOperator.DELETION), read.getAlignmentStart(), read.getReadNegativeStrandFlag());
                int numDeletions = AlignerTestHarness.numDeletionsInCigar(read.getCigar());
                String expectedRef = new String(reference.getSubsequenceAt(reference.getSequenceDictionary().getSequences().get(0).getSequenceName(), read.getAlignmentStart(), read.getAlignmentStart() + read.getReadLength() + numDeletions - 1).getBases());
                System.out.printf("expected ref  = %s%n", AlignerTestHarness.formatBasesBasedOnCigar(expectedRef, read.getCigar(), CigarOperator.INSERTION));
                for (Alignment[] alignmentsOfQuality : alignments) {
                    for (Alignment alignment : alignmentsOfQuality) {
                        System.out.println();
                        Cigar cigar = ((BWAAlignment)alignment).getCigar();
                        System.out.printf("read          = %s%n", AlignerTestHarness.formatBasesBasedOnCigar(read.getReadString(), cigar, CigarOperator.DELETION));
                        int deletionCount = ((BWAAlignment)alignment).getNumberOfBasesMatchingState(AlignmentState.DELETION);
                        String alignedRef = new String(reference.getSubsequenceAt(reference.getSequenceDictionary().getSequences().get(0).getSequenceName(), alignment.getAlignmentStart(), alignment.getAlignmentStart() + (long)read.getReadLength() + (long)deletionCount - 1L).getBases());
                        System.out.printf("actual ref    = %s, position = %d, negative strand = %b%n", AlignerTestHarness.formatBasesBasedOnCigar(alignedRef, cigar, CigarOperator.INSERTION), alignment.getAlignmentStart(), alignment.isNegativeStrand());
                    }
                }
            }
            if (count % 1000 != 0) continue;
            System.out.printf("%d reads examined.%n", count);
        }
        System.out.printf("%d reads examined; %d mismatches; %d failures.%n", count, mismatches, failures);
    }

    private static String formatBasesBasedOnCigar(String bases, Cigar cigar, CigarOperator toBlank) {
        StringBuilder formatted = new StringBuilder();
        int readIndex = 0;
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            int number;
            if (cigarElement.getOperator() == toBlank) {
                number = cigarElement.getLength();
                while (number-- > 0) {
                    formatted.append(' ');
                }
                continue;
            }
            number = cigarElement.getLength();
            while (number-- > 0) {
                formatted.append(bases.charAt(readIndex++));
            }
        }
        return formatted.toString();
    }

    private static int numDeletionsInCigar(Cigar cigar) {
        int numDeletions = 0;
        for (CigarElement cigarElement : cigar.getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.DELETION) continue;
            numDeletions += cigarElement.getLength();
        }
        return numDeletions;
    }
}

