/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentDefinitions;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentMatch;
import org.broadinstitute.sting.commandline.ArgumentMatchSite;
import org.broadinstitute.sting.commandline.DefinitionMatcher;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.utils.Utils;

public abstract class ParsingMethod {
    private final Pattern pattern;
    private final DefinitionMatcher definitionMatcher;
    private static final String ARGUMENT_TEXT = "[A-Za-z_][\\w\\-\\.]*";
    private static final String TAG_TEXT = "[\\w\\-\\.\\=]*";
    public static ParsingMethod FullNameParsingMethod = new ParsingMethod(Pattern.compile(String.format("\\s*--(%1$s)(?:\\:(%2$s(?:,%2$s)*))?\\s*", "[A-Za-z_][\\w\\-\\.]*", "[\\w\\-\\.\\=]*")), ArgumentDefinitions.FullNameDefinitionMatcher){};
    public static ParsingMethod ShortNameParsingMethod = new ParsingMethod(Pattern.compile(String.format("\\s*-(%1$s)(?:\\:(%2$s(?:,%2$s)*))?\\s*", "[A-Za-z_][\\w\\-\\.]*", "[\\w\\-\\.\\=]*")), ArgumentDefinitions.ShortNameDefinitionMatcher){};

    private ParsingMethod(Pattern pattern, DefinitionMatcher definitionMatcher) {
        this.pattern = pattern;
        this.definitionMatcher = definitionMatcher;
    }

    public boolean matches(String token) {
        Matcher matcher = this.pattern.matcher(token);
        return matcher.matches();
    }

    public ArgumentMatch match(ArgumentDefinitions definitions, String token, ArgumentMatchSite position) {
        Matcher matcher = this.pattern.matcher(token);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Unable to parse token %s with pattern %s", token, this.pattern.pattern()));
        }
        String argument = matcher.group(1).trim();
        Tags tags = new Tags();
        if (matcher.group(2) != null) {
            for (String tag : Utils.split(matcher.group(2), ",")) {
                int equalDelimiterPos = tag.indexOf(61);
                if (equalDelimiterPos >= 0) {
                    if (tag.indexOf(61, equalDelimiterPos + 1) >= 0) {
                        throw new ArgumentException(String.format("Tag %s passed to argument %s is malformed.  Please ensure that key-value tags are of the form <key>=<value>, and neither key nor value contain the '=' character", tag, argument));
                    }
                    tags.addKeyValueTag(tag.substring(0, equalDelimiterPos), tag.substring(equalDelimiterPos + 1));
                    continue;
                }
                tags.addPositionalTag(tag);
            }
        }
        ArgumentDefinition argumentDefinition = definitions.findArgumentDefinition(argument, this.definitionMatcher);
        return new ArgumentMatch(argument, argumentDefinition, position, tags);
    }
}

