/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.filters.ReadFilter;

public class BadCigarFilter
extends ReadFilter {
    @Override
    public boolean filterOut(SAMRecord rec) {
        Cigar c = rec.getCigar();
        boolean lastElementWasIndel = false;
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getOperator() == CigarOperator.D || ce.getOperator() == CigarOperator.I) {
                if (lastElementWasIndel) {
                    return true;
                }
                lastElementWasIndel = true;
                continue;
            }
            lastElementWasIndel = false;
        }
        return false;
    }
}

