/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.lang.math.NumberUtils;
import org.broadinstitute.sting.gatk.report.GATKReportColumnFormat;

public class GATKReportColumn
extends TreeMap<Object, Object> {
    private final String columnName;
    private final Object defaultValue;
    private final String format;
    private final boolean display;
    private static final Collection<String> RIGHT_ALIGN_STRINGS = Arrays.asList("null", "NA", String.valueOf(Double.POSITIVE_INFINITY), String.valueOf(Double.NEGATIVE_INFINITY), String.valueOf(Double.NaN));

    public GATKReportColumn(String columnName, Object defaultValue, boolean display, String format) {
        this.columnName = columnName;
        this.defaultValue = defaultValue;
        this.display = display;
        this.format = format == null ? null : (format.equals("") ? null : format);
    }

    public void initialize(Object primaryKey) {
        this.put(primaryKey, this.defaultValue);
    }

    private Object getWithoutSideEffects(Object primaryKey) {
        if (!this.containsKey(primaryKey)) {
            return this.defaultValue;
        }
        return this.get(primaryKey);
    }

    public String getStringValue(Object primaryKey) {
        return this.formatValue(this.getWithoutSideEffects(primaryKey));
    }

    public boolean isDisplayable() {
        return this.display;
    }

    public GATKReportColumnFormat getColumnFormat() {
        int maxWidth = this.columnName.length();
        GATKReportColumnFormat.Alignment alignment = GATKReportColumnFormat.Alignment.RIGHT;
        for (Object obj : this.values()) {
            if (obj == null) continue;
            String formatted = this.formatValue(obj);
            int width = formatted.length();
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (alignment != GATKReportColumnFormat.Alignment.RIGHT || GATKReportColumn.isRightAlign(formatted)) continue;
            alignment = GATKReportColumnFormat.Alignment.LEFT;
        }
        return new GATKReportColumnFormat(maxWidth, alignment);
    }

    protected static boolean isRightAlign(String value) {
        return value == null || RIGHT_ALIGN_STRINGS.contains(value) || NumberUtils.isNumber(value);
    }

    private String formatValue(Object obj) {
        String value = obj == null ? "null" : (this.format != null ? String.format(this.format, obj) : (obj instanceof Float ? String.format("%.8f", (Float)obj) : (obj instanceof Double ? String.format("%.8f", (Double)obj) : obj.toString())));
        return value;
    }

    public String getColumnName() {
        return this.columnName;
    }
}

