/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.GenotypeAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Hidden
public class ReadDepthAndAllelicFractionBySample
extends GenotypeAnnotation {
    private static String REF_ALLELE = "REF";
    private static String DEL = "DEL";

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, AlignmentContext stratifiedContext, VariantContext vc, Genotype g) {
        if (g == null || !g.isCalled()) {
            return null;
        }
        if (vc.isSNP()) {
            return this.annotateSNP(stratifiedContext, vc);
        }
        if (vc.isIndel()) {
            return this.annotateIndel(stratifiedContext, vc);
        }
        return null;
    }

    private Map<String, Object> annotateSNP(AlignmentContext stratifiedContext, VariantContext vc) {
        if (!stratifiedContext.hasBasePileup()) {
            return null;
        }
        HashMap<Byte, Integer> alleleCounts = new HashMap<Byte, Integer>();
        for (Allele allele : vc.getAlternateAlleles()) {
            alleleCounts.put(allele.getBases()[0], 0);
        }
        ReadBackedPileup pileup = stratifiedContext.getBasePileup();
        int totalDepth = pileup.getNumberOfElements();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), totalDepth);
        if (totalDepth == 0) {
            return map;
        }
        int mq0 = 0;
        for (PileupElement p : pileup) {
            if (p.getMappingQual() == 0) {
                ++mq0;
                continue;
            }
            if (!alleleCounts.containsKey(p.getBase())) continue;
            alleleCounts.put(p.getBase(), (Integer)alleleCounts.get(p.getBase()) + 1);
        }
        if (mq0 == totalDepth) {
            return map;
        }
        String[] fracs = new String[alleleCounts.size()];
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            fracs[i] = String.format("%.3f", Float.valueOf((float)((Integer)alleleCounts.get(vc.getAlternateAllele(i).getBases()[0])).intValue() / (float)(totalDepth - mq0)));
        }
        map.put(this.getKeyNames().get(1), fracs);
        return map;
    }

    private Map<String, Object> annotateIndel(AlignmentContext stratifiedContext, VariantContext vc) {
        if (!stratifiedContext.hasExtendedEventPileup()) {
            return null;
        }
        ReadBackedExtendedEventPileup pileup = stratifiedContext.getExtendedEventPileup();
        if (pileup == null) {
            return null;
        }
        int totalDepth = pileup.getNumberOfElements();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), totalDepth);
        if (totalDepth == 0) {
            return map;
        }
        int mq0 = 0;
        HashMap<String, Integer> alleleCounts = new HashMap<String, Integer>();
        Allele refAllele = vc.getReference();
        for (Allele allele : vc.getAlternateAlleles()) {
            if (allele.isNoCall()) continue;
            alleleCounts.put(this.getAlleleRepresentation(allele), 0);
        }
        for (ExtendedEventPileupElement e : pileup.toExtendedIterable()) {
            String b;
            if (e.getMappingQual() == 0) {
                ++mq0;
                continue;
            }
            if (e.isInsertion()) {
                b = e.getEventBases();
                if (!alleleCounts.containsKey(b)) continue;
                alleleCounts.put(b, (Integer)alleleCounts.get(b) + 1);
                continue;
            }
            if (!e.isDeletion() || e.getEventLength() != refAllele.length() || !alleleCounts.containsKey(b = DEL)) continue;
            alleleCounts.put(b, (Integer)alleleCounts.get(b) + 1);
        }
        if (mq0 == totalDepth) {
            return map;
        }
        String[] fracs = new String[alleleCounts.size()];
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            fracs[i] = String.format("%.3f", Float.valueOf((float)((Integer)alleleCounts.get(this.getAlleleRepresentation(vc.getAlternateAllele(i)))).intValue() / (float)(totalDepth - mq0)));
        }
        map.put(this.getKeyNames().get(1), fracs);
        return map;
    }

    private String getAlleleRepresentation(Allele allele) {
        if (allele.isNull()) {
            return DEL;
        }
        return allele.getBaseString();
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("DP", "FA");
    }

    @Override
    public List<VCFFormatHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFFormatHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Integer, "Total read depth per sample, including MQ0"), new VCFFormatHeaderLine(this.getKeyNames().get(1), VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.Float, "Fractions of reads (excluding MQ0 from both ref and alt) supporting each reported alternative allele, per sample"));
    }
}

