/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.NotImplementedException;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.ExactAFCalculationModel;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class UGBoundAF
extends RodWalker<VariantContext, Integer> {
    @Output(shortName="vcf", fullName="VCF", doc="file to write to", required=true)
    VCFWriter writer;
    @Input(shortName="V", fullName="Variants", doc="variant tracks to use in calculation", required=true)
    List<RodBinding<VariantContext>> variants;
    private static double EPS_LOWER_LIMIT = Math.pow(10.0, -6.0);
    private HashMap<Integer, Pair<Double, Double>> epsilonPosteriorCache = new HashMap(8192);
    private HashMap<Integer, Double> logAC0Cache = new HashMap(8192);
    private int QUANTIZATION_FACTOR = 1000;
    private int N_ITERATIONS = 1;

    @Override
    public void initialize() {
        HashSet<VCFHeaderLine> allHeaderLines = new HashSet<VCFHeaderLine>(1024);
        for (RodBinding<VariantContext> v : this.variants) {
            String trackName = v.getName();
            Map<String, VCFHeader> vcfHeaders = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(trackName));
            HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>(vcfHeaders.get(trackName).getMetaData());
        }
        allHeaderLines.add(new VCFInfoHeaderLine("AFB", 2, VCFHeaderLineType.Float, "The 95% bounds on the allele frequency. First value=95% probability AF>x. Second value=95% probability AF<x."));
        this.writer.writeHeader(new VCFHeader(allHeaderLines));
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public VariantContext map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext unused) {
        List<VariantContext> allVariants = tracker.getValues(this.variants);
        if (allVariants.size() == 0) {
            return null;
        }
        List<Allele> alternateAlleles = this.getAllAlternateAlleles(allVariants);
        VariantContextBuilder builder = new VariantContextBuilder(allVariants.get(0).subContextFromSamples(new TreeSet<String>()));
        if (alternateAlleles.size() > 1) {
            logger.warn("Multiple Segregating Variants at position " + ref.getLocus().toString());
            alternateAlleles.add(allVariants.get(0).getReference());
            builder.alleles(alternateAlleles);
            builder.filters(String.format("MULTIPLE_SEGREGATING[%s]", Utils.join(",", alternateAlleles)));
        } else {
            GenotypesContext context = GenotypesContext.create();
            int numNoCall = 0;
            for (VariantContext v : allVariants) {
                numNoCall += v.getNoCallCount();
                context.addAll(v.getGenotypes());
            }
            builder.attribute("AFB", this.boundAlleleFrequency(this.getACPosteriors(context)));
        }
        return builder.make();
    }

    private List<Allele> getAllAlternateAlleles(List<VariantContext> variants) {
        ArrayList<Allele> alleles = new ArrayList<Allele>(3);
        for (VariantContext v : variants) {
            alleles.addAll(v.getAlternateAlleles());
        }
        return alleles;
    }

    @Override
    public Integer reduce(VariantContext value, Integer sum) {
        if (value == null) {
            return sum;
        }
        this.writer.add(value);
        sum = sum + 1;
        return sum;
    }

    private double[] getACPosteriors(GenotypesContext gc) {
        double[][] zeroPriors = new double[1][1 + 2 * gc.size()];
        AlleleFrequencyCalculationResult result = new AlleleFrequencyCalculationResult(2, 2 * gc.size());
        for (int i = 0; i < this.N_ITERATIONS; ++i) {
            ExactAFCalculationModel.linearExactMultiAllelic(gc, 2, zeroPriors, result, false);
        }
        return result.log10AlleleFrequencyPosteriors[0];
    }

    private String boundAlleleFrequency(double[] ACLikelihoods) {
        throw new ReviewedStingException("This walker is unsupported, and is not fully implemented", new NotImplementedException("bound allele frequency not implemented"));
    }

    private double calculateAFPosterior(double[] likelihoods, double af) {
        double[] probLiks = new double[likelihoods.length];
        for (int c = 0; c < likelihoods.length; ++c) {
            probLiks[c] = this.calculateAFPosterior(c, likelihoods.length, af);
        }
        return MathUtils.log10sumLog10(probLiks);
    }

    private double calculateAFPosterior(int ac, int n, double af) {
        switch (ac) {
            case 0: {
                return this.logAC0Coef(n) + (double)n * Math.log10(1.0 - af) - Math.log10(af);
            }
            case 1: {
                return Math.log10(n) + (double)(n - 1) * Math.log10(1.0 - af) - (double)n * Math.log10(1.0 - EPS_LOWER_LIMIT);
            }
            case 2: {
                return Math.log10(n) + Math.log10(n - 1) + Math.log10(af) + (double)(n - 2) * Math.log10(1.0 - af) - Math.log10(1.0 - (double)(n - 1) * EPS_LOWER_LIMIT) - (double)(n - 1) * Math.log10(EPS_LOWER_LIMIT);
            }
        }
        return (double)(ac - 1) * Math.log10(af) + (double)ac * Math.log10((double)n - (double)ac) - (double)(n - ac) * af * Math.log10(Math.E) - MathUtils.log10Gamma(ac);
    }

    private double logAC0Coef(int an) {
        if (!this.logAC0Cache.containsKey(an)) {
            double coef = -Math.log10(EPS_LOWER_LIMIT);
            for (int k = 1; k <= an; ++k) {
                double binom = MathUtils.binomialCoefficient(an, k);
                double eps_correction = EPS_LOWER_LIMIT * Math.pow(binom, 1 / k);
                double term = binom / (double)k - Math.pow(eps_correction, k);
                if (k % 2 == 0) {
                    coef += term;
                    continue;
                }
                coef -= term;
            }
            this.logAC0Cache.put(an, coef);
        }
        return this.logAC0Cache.get(an);
    }

    private double adaptiveSimpson(double[] likelihoods, double start, double stop, double err, int cap) {
        double mid = (start + stop) / 2.0;
        double size = stop - start;
        double fa = this.calculateAFPosterior(likelihoods, start);
        double fb = this.calculateAFPosterior(likelihoods, mid);
        double fc = this.calculateAFPosterior(likelihoods, stop);
        double s = size / 6.0 * (fa + 4.0 * fc + fb);
        double h = this.simpAux(likelihoods, start, stop, err, s, fa, fb, fc, cap);
        return h;
    }

    private double simpAux(double[] likelihoods, double a, double b, double eps, double s, double fa, double fb, double fc, double cap) {
        if (s == 0.0) {
            return -300.0;
        }
        double c = (a + b) / 2.0;
        double h = b - a;
        double d = (a + c) / 2.0;
        double e = (c + b) / 2.0;
        double fd = this.calculateAFPosterior(likelihoods, d);
        double fe = this.calculateAFPosterior(likelihoods, e);
        double s_l = h / 12.0 * (fa + 4.0 * fd + fc);
        double s_r = h / 12.0 * (fc + 4.0 * fe + fb);
        double s_2 = s_l + s_r;
        if (cap <= 0.0 || Math.abs(s_2 - s) <= 15.0 * eps) {
            return Math.log10(s_2 + (s_2 - s) / 15.0);
        }
        return MathUtils.approximateLog10SumLog10(this.simpAux(likelihoods, a, c, eps / 2.0, s_l, fa, fc, fd, cap - 1.0), this.simpAux(likelihoods, c, b, eps / 2.0, s_r, fc, fb, fe, cap - 1.0));
    }
}

