/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(description="Counts different classes of variants in the sample")
public class CountVariants
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="Number of processed loci")
    public long nProcessedLoci = 0L;
    @DataPoint(description="Number of called loci")
    public long nCalledLoci = 0L;
    @DataPoint(description="Number of reference loci")
    public long nRefLoci = 0L;
    @DataPoint(description="Number of variant loci")
    public long nVariantLoci = 0L;
    @DataPoint(description="Variants per loci rate")
    public double variantRate = 0.0;
    @DataPoint(description="Number of variants per base")
    public double variantRatePerBp = 0.0;
    @DataPoint(description="Number of snp loci")
    public long nSNPs = 0L;
    @DataPoint(description="Number of mnp loci")
    public long nMNPs = 0L;
    @DataPoint(description="Number of insertions")
    public long nInsertions = 0L;
    @DataPoint(description="Number of deletions")
    public long nDeletions = 0L;
    @DataPoint(description="Number of complex indels")
    public long nComplex = 0L;
    @DataPoint(description="Number of symbolic events")
    public long nSymbolic = 0L;
    @DataPoint(description="Number of mixed loci (loci that can't be classified as a SNP, Indel or MNP)")
    public long nMixed = 0L;
    @DataPoint(description="Number of no calls loci")
    public long nNoCalls = 0L;
    @DataPoint(description="Number of het loci")
    public long nHets = 0L;
    @DataPoint(description="Number of hom ref loci")
    public long nHomRef = 0L;
    @DataPoint(description="Number of hom var loci")
    public long nHomVar = 0L;
    @DataPoint(description="Number of singletons")
    public long nSingletons = 0L;
    @DataPoint(description="Number of derived homozygotes")
    public long nHomDerived = 0L;
    @DataPoint(description="heterozygosity per locus rate", format="%.2e")
    public double heterozygosity = 0.0;
    @DataPoint(description="heterozygosity per base pair", format="%.2f")
    public double heterozygosityPerBp = 0.0;
    @DataPoint(description="heterozygosity to homozygosity ratio", format="%.2f")
    public double hetHomRatio = 0.0;
    @DataPoint(description="indel rate (insertion count + deletion count)", format="%.2e")
    public double indelRate = 0.0;
    @DataPoint(description="indel rate per base pair", format="%.2f")
    public double indelRatePerBp = 0.0;
    @DataPoint(description="deletion to insertion ratio", format="%.2f")
    public double deletionInsertionRatio = 0.0;

    private double perLocusRate(long n) {
        return this.rate(n, this.nProcessedLoci);
    }

    private long perLocusRInverseRate(long n) {
        return this.inverseRate(n, this.nProcessedLoci);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public void update0(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        this.nProcessedLoci += context.getSkippedBases() + (long)(ref == null ? 0 : 1);
    }

    @Override
    public String update1(VariantContext vc1, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        ++this.nCalledLoci;
        if (vc1.isMonomorphicInSamples()) {
            ++this.nRefLoci;
        } else {
            switch (vc1.getType()) {
                case NO_VARIATION: {
                    break;
                }
                case SNP: {
                    ++this.nVariantLoci;
                    ++this.nSNPs;
                    if (!vc1.getAttributeAsBoolean("ISSINGLETON", false)) break;
                    ++this.nSingletons;
                    break;
                }
                case MNP: {
                    ++this.nVariantLoci;
                    ++this.nMNPs;
                    if (!vc1.getAttributeAsBoolean("ISSINGLETON", false)) break;
                    ++this.nSingletons;
                    break;
                }
                case INDEL: {
                    ++this.nVariantLoci;
                    if (vc1.isSimpleInsertion()) {
                        ++this.nInsertions;
                        break;
                    }
                    if (vc1.isSimpleDeletion()) {
                        ++this.nDeletions;
                        break;
                    }
                    ++this.nComplex;
                    break;
                }
                case MIXED: {
                    ++this.nVariantLoci;
                    ++this.nMixed;
                    break;
                }
                case SYMBOLIC: {
                    ++this.nSymbolic;
                    break;
                }
                default: {
                    throw new ReviewedStingException("Unexpected VariantContext type " + (Object)((Object)vc1.getType()));
                }
            }
        }
        String refStr = vc1.getReference().getBaseString().toUpperCase();
        String aaStr = vc1.hasAttribute("ANCESTRALALLELE") ? vc1.getAttributeAsString("ANCESTRALALLELE", null).toUpperCase() : null;
        block15: for (Genotype g : vc1.getGenotypes()) {
            String altStr = vc1.getAlternateAlleles().size() > 0 ? vc1.getAlternateAllele(0).getBaseString().toUpperCase() : null;
            switch (g.getType()) {
                case NO_CALL: {
                    ++this.nNoCalls;
                    continue block15;
                }
                case HOM_REF: {
                    ++this.nHomRef;
                    if (aaStr == null || altStr == null || refStr.equalsIgnoreCase(aaStr)) continue block15;
                    ++this.nHomDerived;
                    continue block15;
                }
                case HET: {
                    ++this.nHets;
                    continue block15;
                }
                case HOM_VAR: {
                    ++this.nHomVar;
                    if (aaStr == null || altStr == null || altStr.equalsIgnoreCase(aaStr)) continue block15;
                    ++this.nHomDerived;
                    continue block15;
                }
                case MIXED: {
                    continue block15;
                }
            }
            throw new ReviewedStingException("BUG: Unexpected genotype type: " + g);
        }
        return null;
    }

    @Override
    public void finalizeEvaluation() {
        this.variantRate = this.perLocusRate(this.nVariantLoci);
        this.variantRatePerBp = this.perLocusRInverseRate(this.nVariantLoci);
        this.heterozygosity = this.perLocusRate(this.nHets);
        this.heterozygosityPerBp = this.perLocusRInverseRate(this.nHets);
        this.hetHomRatio = this.ratio(this.nHets, this.nHomVar);
        this.indelRate = this.perLocusRate(this.nDeletions + this.nInsertions + this.nComplex);
        this.indelRatePerBp = this.perLocusRInverseRate(this.nDeletions + this.nInsertions + this.nComplex);
        this.deletionInsertionRatio = this.ratio(this.nDeletions, this.nInsertions);
    }
}

