/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.PhaseStats;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;

class SamplePhasingStatistics
implements TableType {
    private HashMap<String, PhaseStats> sampleStats = new HashMap();
    private double minPhaseQuality;

    public SamplePhasingStatistics(double minPhaseQuality) {
        this.minPhaseQuality = minPhaseQuality;
    }

    public PhaseStats ensureSampleStats(String samp) {
        PhaseStats ps = this.sampleStats.get(samp);
        if (ps == null) {
            ps = new PhaseStats();
            this.sampleStats.put(samp, ps);
        }
        return ps;
    }

    public String[] getRowKeys() {
        return this.sampleStats.keySet().toArray(new String[this.sampleStats.size()]);
    }

    public String[] getColumnKeys() {
        return PhaseStats.getFieldNamesArray();
    }

    @Override
    public Object getCell(int x, int y) {
        String[] rowKeys = this.getRowKeys();
        PhaseStats ps = this.sampleStats.get(rowKeys[x]);
        return ps.getField(y);
    }

    @Override
    public String getName() {
        return "Sample Phasing Statistics (for PQ >= " + this.minPhaseQuality + ")";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, PhaseStats> sampPhaseStatsEnt : this.sampleStats.entrySet()) {
            String sample = sampPhaseStatsEnt.getKey();
            PhaseStats ps = sampPhaseStatsEnt.getValue();
            sb.append(sample + "\t" + ps);
        }
        return sb.toString();
    }
}

