/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class IndelSize
extends VariantStratifier {
    static final int MAX_INDEL_SIZE = 100;

    @Override
    public void initialize() {
        this.states = new ArrayList();
        for (int a = -100; a <= 100; ++a) {
            this.states.add(String.format("%d", a));
        }
    }

    @Override
    public List<String> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        ArrayList<String> relevantStates = new ArrayList<String>();
        if (eval != null && eval.isIndel() && eval.isBiallelic()) {
            try {
                int eventLength = 0;
                if (eval.isSimpleInsertion()) {
                    eventLength = eval.getAlternateAllele(0).length();
                } else if (eval.isSimpleDeletion()) {
                    eventLength = -eval.getReference().length();
                }
                if (eventLength > 100) {
                    eventLength = 100;
                } else if (eventLength < -100) {
                    eventLength = -100;
                }
                relevantStates.add(String.format("%d", eventLength));
            }
            catch (Exception e) {
                return relevantStates;
            }
        }
        return relevantStates;
    }
}

