/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.clipping;

import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.utils.clipping.ClippingOp;
import org.broadinstitute.sting.utils.clipping.ClippingRepresentation;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class ReadClipper {
    final GATKSAMRecord read;
    boolean wasClipped;
    List<ClippingOp> ops = null;

    public ReadClipper(GATKSAMRecord read) {
        this.read = read;
        this.wasClipped = false;
    }

    public void addOp(ClippingOp op) {
        if (this.ops == null) {
            this.ops = new ArrayList<ClippingOp>();
        }
        this.ops.add(op);
    }

    public List<ClippingOp> getOps() {
        return this.ops;
    }

    public boolean wasClipped() {
        return this.wasClipped;
    }

    public GATKSAMRecord getRead() {
        return this.read;
    }

    public GATKSAMRecord clipRead(ClippingRepresentation algorithm) {
        if (this.ops == null) {
            return this.getRead();
        }
        try {
            GATKSAMRecord clippedRead = (GATKSAMRecord)this.read.clone();
            for (ClippingOp op : this.getOps()) {
                if (op.start >= clippedRead.getReadLength()) continue;
                ClippingOp fixedOperation = op;
                if (op.stop >= clippedRead.getReadLength()) {
                    fixedOperation = new ClippingOp(op.start, clippedRead.getReadLength() - 1);
                }
                clippedRead = fixedOperation.apply(algorithm, clippedRead);
            }
            this.wasClipped = true;
            this.ops.clear();
            if (clippedRead.isEmpty()) {
                return GATKSAMRecord.emptyRead(clippedRead);
            }
            return clippedRead;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Requires(value={"!read.getReadUnmappedFlag()"})
    private GATKSAMRecord hardClipByReferenceCoordinatesLeftTail(int refStop) {
        return this.hardClipByReferenceCoordinates(-1, refStop);
    }

    public static GATKSAMRecord hardClipByReferenceCoordinatesLeftTail(GATKSAMRecord read, int refStop) {
        return new ReadClipper(read).hardClipByReferenceCoordinates(-1, refStop);
    }

    @Requires(value={"!read.getReadUnmappedFlag()"})
    private GATKSAMRecord hardClipByReferenceCoordinatesRightTail(int refStart) {
        return this.hardClipByReferenceCoordinates(refStart, -1);
    }

    public static GATKSAMRecord hardClipByReferenceCoordinatesRightTail(GATKSAMRecord read, int refStart) {
        return new ReadClipper(read).hardClipByReferenceCoordinates(refStart, -1);
    }

    @Requires(value={"start >= 0 && stop <= read.getReadLength() - 1", "start == 0 || stop == read.getReadLength() - 1"})
    private GATKSAMRecord hardClipByReadCoordinates(int start, int stop) {
        if (this.read.isEmpty() || start == 0 && stop == this.read.getReadLength() - 1) {
            return GATKSAMRecord.emptyRead(this.read);
        }
        this.addOp(new ClippingOp(start, stop));
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKSAMRecord hardClipByReadCoordinates(GATKSAMRecord read, int start, int stop) {
        return new ReadClipper(read).hardClipByReadCoordinates(start, stop);
    }

    @Requires(value={"left <= right", "left >= read.getAlignmentStart()", "right <= read.getAlignmentEnd()"})
    private GATKSAMRecord hardClipBothEndsByReferenceCoordinates(int left, int right) {
        if (this.read.isEmpty() || left == right) {
            return GATKSAMRecord.emptyRead(this.read);
        }
        GATKSAMRecord leftTailRead = this.hardClipByReferenceCoordinates(right, -1);
        if (left > leftTailRead.getAlignmentEnd()) {
            return GATKSAMRecord.emptyRead(this.read);
        }
        ReadClipper clipper = new ReadClipper(leftTailRead);
        return clipper.hardClipByReferenceCoordinatesLeftTail(left);
    }

    public static GATKSAMRecord hardClipBothEndsByReferenceCoordinates(GATKSAMRecord read, int left, int right) {
        return new ReadClipper(read).hardClipBothEndsByReferenceCoordinates(left, right);
    }

    private GATKSAMRecord hardClipLowQualEnds(byte lowQual) {
        int rightClipIndex;
        if (this.read.isEmpty()) {
            return this.read;
        }
        byte[] quals = this.read.getBaseQualities();
        int leftClipIndex = 0;
        for (rightClipIndex = this.read.getReadLength() - 1; rightClipIndex >= 0 && quals[rightClipIndex] <= lowQual; --rightClipIndex) {
        }
        while (leftClipIndex < this.read.getReadLength() && quals[leftClipIndex] <= lowQual) {
            ++leftClipIndex;
        }
        if (leftClipIndex > rightClipIndex) {
            return GATKSAMRecord.emptyRead(this.read);
        }
        if (rightClipIndex < this.read.getReadLength() - 1) {
            this.addOp(new ClippingOp(rightClipIndex + 1, this.read.getReadLength() - 1));
        }
        if (leftClipIndex > 0) {
            this.addOp(new ClippingOp(0, leftClipIndex - 1));
        }
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKSAMRecord hardClipLowQualEnds(GATKSAMRecord read, byte lowQual) {
        return new ReadClipper(read).hardClipLowQualEnds(lowQual);
    }

    private GATKSAMRecord hardClipSoftClippedBases() {
        if (this.read.isEmpty()) {
            return this.read;
        }
        int readIndex = 0;
        int cutLeft = -1;
        int cutRight = -1;
        boolean rightTail = false;
        for (CigarElement cigarElement : this.read.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() == CigarOperator.SOFT_CLIP) {
                if (rightTail) {
                    cutRight = readIndex;
                } else {
                    cutLeft = readIndex + cigarElement.getLength() - 1;
                }
            } else if (cigarElement.getOperator() != CigarOperator.HARD_CLIP) {
                rightTail = true;
            }
            if (!cigarElement.getOperator().consumesReadBases()) continue;
            readIndex += cigarElement.getLength();
        }
        if (cutRight >= 0) {
            this.addOp(new ClippingOp(cutRight, this.read.getReadLength() - 1));
        }
        if (cutLeft >= 0) {
            this.addOp(new ClippingOp(0, cutLeft));
        }
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKSAMRecord hardClipSoftClippedBases(GATKSAMRecord read) {
        return new ReadClipper(read).hardClipSoftClippedBases();
    }

    private GATKSAMRecord hardClipAdaptorSequence() {
        Integer adaptorBoundary = ReadUtils.getAdaptorBoundary(this.read);
        if (adaptorBoundary == null || !ReadUtils.isInsideRead(this.read, adaptorBoundary)) {
            return this.read;
        }
        return this.read.getReadNegativeStrandFlag() ? this.hardClipByReferenceCoordinatesLeftTail(adaptorBoundary) : this.hardClipByReferenceCoordinatesRightTail(adaptorBoundary);
    }

    public static GATKSAMRecord hardClipAdaptorSequence(GATKSAMRecord read) {
        return new ReadClipper(read).hardClipAdaptorSequence();
    }

    private GATKSAMRecord hardClipLeadingInsertions() {
        if (this.read.isEmpty()) {
            return this.read;
        }
        for (CigarElement cigarElement : this.read.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.HARD_CLIP && cigarElement.getOperator() != CigarOperator.SOFT_CLIP && cigarElement.getOperator() != CigarOperator.INSERTION) break;
            if (cigarElement.getOperator() != CigarOperator.INSERTION) continue;
            this.addOp(new ClippingOp(0, cigarElement.getLength() - 1));
        }
        return this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
    }

    public static GATKSAMRecord hardClipLeadingInsertions(GATKSAMRecord read) {
        return new ReadClipper(read).hardClipLeadingInsertions();
    }

    private GATKSAMRecord revertSoftClippedBases() {
        this.addOp(new ClippingOp(0, 0));
        return this.clipRead(ClippingRepresentation.REVERT_SOFTCLIPPED_BASES);
    }

    public static GATKSAMRecord revertSoftClippedBases(GATKSAMRecord read) {
        return new ReadClipper(read).revertSoftClippedBases();
    }

    @Requires(value={"!read.getReadUnmappedFlag()", "refStart < 0 || refStop < 0"})
    protected GATKSAMRecord hardClipByReferenceCoordinates(int refStart, int refStop) {
        int stop;
        int start;
        if (this.read.isEmpty()) {
            return this.read;
        }
        if (refStart < 0) {
            if (refStop < 0) {
                throw new ReviewedStingException("Only one of refStart or refStop must be < 0, not both (" + refStart + ", " + refStop + ")");
            }
            start = 0;
            stop = ReadUtils.getReadCoordinateForReferenceCoordinate(this.read, refStop, ReadUtils.ClippingTail.LEFT_TAIL);
        } else {
            if (refStop >= 0) {
                throw new ReviewedStingException("Either refStart or refStop must be < 0 (" + refStart + ", " + refStop + ")");
            }
            start = ReadUtils.getReadCoordinateForReferenceCoordinate(this.read, refStart, ReadUtils.ClippingTail.RIGHT_TAIL);
            stop = this.read.getReadLength() - 1;
        }
        if (start < 0 || stop > this.read.getReadLength() - 1) {
            throw new ReviewedStingException("Trying to clip before the start or after the end of a read");
        }
        if (start > stop) {
            throw new ReviewedStingException(String.format("START (%d) > (%d) STOP -- this should never happen -- call Mauricio!", start, stop));
        }
        if (start > 0 && stop < this.read.getReadLength() - 1) {
            throw new ReviewedStingException(String.format("Trying to clip the middle of the read: start %d, stop %d, cigar: %s", start, stop, this.read.getCigarString()));
        }
        this.addOp(new ClippingOp(start, stop));
        GATKSAMRecord clippedRead = this.clipRead(ClippingRepresentation.HARDCLIP_BASES);
        this.ops = null;
        return clippedRead;
    }
}

