/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceRecord;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ArtificialSAMIterator;

public class ArtificialSAMQueryIterator
extends ArtificialSAMIterator {
    protected int finalPos = 0;
    protected int startPos = 0;
    protected int contigIndex = -1;
    protected boolean overlapping = false;
    protected int startingChr = 0;
    protected boolean seeked = false;

    ArtificialSAMQueryIterator(int startingChr, int endingChr, int readCount, int unmappedReadCount, SAMFileHeader header) {
        super(startingChr, endingChr, readCount, unmappedReadCount, header);
        this.startingChr = startingChr;
    }

    @Override
    protected void reset() {
        this.startPos = 0;
        this.finalPos = 0;
        this.contigIndex = -1;
        this.startingChr = 0;
        this.seeked = false;
        super.reset();
    }

    public void queryContained(String contig, int start, int stop) {
        this.overlapping = false;
        this.initialize(contig, start, stop);
    }

    public void queryOverlapping(String contig, int start, int stop) {
        this.overlapping = true;
        this.initialize(contig, start, stop);
    }

    public void query(String contig, int start, int stop, boolean contained) {
        if (contained) {
            this.queryContained(contig, start, stop);
        } else {
            this.queryOverlapping(contig, start, stop);
        }
    }

    public void queryUnmappedReads() {
        this.initializeUnmapped();
    }

    public void initializeUnmapped() {
        this.ensureUntouched();
        this.reset();
        while (super.hasNext() && this.peek().getReferenceIndex() >= 0) {
            super.next();
        }
        SAMRecord rec = this.peek();
        if (rec == null) {
            throw new ReviewedStingException("The next read doesn't match");
        }
        this.seeked = true;
    }

    private void initialize(String contig, int start, int stop) {
        this.ensureUntouched();
        this.reset();
        this.finalPos = stop;
        this.startPos = start;
        if (this.finalPos < 0) {
            this.finalPos = Integer.MAX_VALUE;
        }
        this.contigIndex = -1;
        List<SAMSequenceRecord> list = this.header.getSequenceDictionary().getSequences();
        for (SAMSequenceRecord rec : list) {
            if (!rec.getSequenceName().equals(contig)) continue;
            this.contigIndex = rec.getSequenceIndex();
        }
        if (this.contigIndex < 0) {
            throw new IllegalArgumentException("ArtificialContig" + contig + " doesn't exist");
        }
        while (super.hasNext() && this.peek().getReferenceIndex() < this.contigIndex) {
            super.next();
        }
        if (!super.hasNext()) {
            throw new ReviewedStingException("Unable to find the target chromosome");
        }
        while (super.hasNext() && this.peek().getAlignmentStart() < start) {
            super.next();
        }
        SAMRecord rec = this.peek();
        if (!this.matches(rec)) {
            throw new ReviewedStingException("The next read doesn't match");
        }
        this.seeked = true;
    }

    public boolean matches(SAMRecord rec) {
        if (rec.getReferenceIndex() != this.contigIndex) {
            return false;
        }
        if (rec.getReferenceIndex() < 0) {
            return true;
        }
        return !this.overlapping ? rec.getAlignmentStart() >= this.startPos && rec.getAlignmentEnd() <= this.finalPos : rec.getAlignmentStart() <= this.finalPos && rec.getAlignmentStart() >= this.startPos || rec.getAlignmentEnd() <= this.finalPos && rec.getAlignmentEnd() >= this.startPos;
    }

    @Override
    public boolean hasNext() {
        boolean res = super.hasNext();
        if (!this.seeked) {
            return res;
        }
        return res && this.matches(this.next);
    }

    public void ensureUntouched() {
        if (this.open) {
            throw new UnsupportedOperationException("We've already been used as an iterator; you can't query after that");
        }
    }
}

