/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class LoggerAction
extends Action {
    boolean inError = false;

    public void begin(InterpretationContext ec, String name, Attributes attributes) {
        this.inError = false;
        LoggerContext loggerContext = (LoggerContext)this.context;
        String loggerName = attributes.getValue("name");
        if (OptionHelper.isEmpty(loggerName)) {
            this.inError = true;
            String line = ", around line " + this.getLineNumber(ec) + " column " + this.getColumnNumber(ec);
            String errorMsg = "No 'name' attribute in element " + name + line;
            this.addError(errorMsg);
            return;
        }
        Logger l = loggerContext.getLogger(loggerName);
        boolean additive = OptionHelper.toBoolean(attributes.getValue("additivity"), true);
        l.setAdditive(additive);
        ec.pushObject(l);
    }

    public void end(InterpretationContext ec, String e) {
        if (!this.inError) {
            ec.popObject();
        }
    }

    public void finish(InterpretationContext ec) {
    }
}

