/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.runtime;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EnumMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.io.HardThresholdingOutputStream;
import org.broadinstitute.sting.utils.runtime.OutputStreamSettings;
import org.broadinstitute.sting.utils.runtime.StreamLocation;
import org.broadinstitute.sting.utils.runtime.StreamOutput;

public class CapturedStreamOutput
extends StreamOutput {
    private final InputStream processStream;
    private final EnumMap<StreamLocation, OutputStream> outputStreams = new EnumMap(StreamLocation.class);
    private final ByteArrayOutputStream bufferStream;
    private boolean bufferTruncated = false;

    public CapturedStreamOutput(OutputStreamSettings settings, InputStream processStream, PrintStream standardStream) {
        this.processStream = processStream;
        int bufferSize = settings.getBufferSize();
        this.bufferStream = bufferSize < 0 ? new ByteArrayOutputStream() : new ByteArrayOutputStream(bufferSize);
        for (StreamLocation location : settings.getStreamLocations()) {
            OutputStream outputStream;
            switch (location) {
                case Buffer: {
                    if (bufferSize < 0) {
                        outputStream = this.bufferStream;
                        break;
                    }
                    outputStream = new HardThresholdingOutputStream(bufferSize){

                        @Override
                        protected OutputStream getStream() throws IOException {
                            return CapturedStreamOutput.this.bufferTruncated ? NullOutputStream.NULL_OUTPUT_STREAM : CapturedStreamOutput.this.bufferStream;
                        }

                        @Override
                        protected void thresholdReached() throws IOException {
                            CapturedStreamOutput.this.bufferTruncated = true;
                        }
                    };
                    break;
                }
                case File: {
                    try {
                        outputStream = new FileOutputStream(settings.getOutputFile(), settings.isAppendFile());
                        break;
                    }
                    catch (IOException e) {
                        throw new UserException.BadInput(e.getMessage());
                    }
                }
                case Standard: {
                    outputStream = standardStream;
                    break;
                }
                default: {
                    throw new ReviewedStingException("Unexpected stream location: " + (Object)((Object)location));
                }
            }
            this.outputStreams.put(location, outputStream);
        }
    }

    @Override
    public byte[] getBufferBytes() {
        return this.bufferStream.toByteArray();
    }

    @Override
    public boolean isBufferTruncated() {
        return this.bufferTruncated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndClose() throws IOException {
        try {
            int readCount;
            byte[] buf = new byte[4096];
            while ((readCount = this.processStream.read(buf)) >= 0) {
                for (OutputStream outputStream : this.outputStreams.values()) {
                    outputStream.write(buf, 0, readCount);
                }
            }
        }
        finally {
            for (StreamLocation location : this.outputStreams.keySet()) {
                OutputStream outputStream = this.outputStreams.get((Object)location);
                outputStream.flush();
                if (location == StreamLocation.Standard) continue;
                IOUtils.closeQuietly(outputStream);
            }
        }
    }
}

