/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFormatException;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMValidationError;
import net.sf.samtools.util.StringUtil;

public final class SAMUtils {
    private static final byte COMPRESSED_EQUAL_LOW = 0;
    private static final byte COMPRESSED_A_LOW = 1;
    private static final byte COMPRESSED_C_LOW = 2;
    private static final byte COMPRESSED_M_LOW = 3;
    private static final byte COMPRESSED_G_LOW = 4;
    private static final byte COMPRESSED_R_LOW = 5;
    private static final byte COMPRESSED_S_LOW = 6;
    private static final byte COMPRESSED_V_LOW = 7;
    private static final byte COMPRESSED_T_LOW = 8;
    private static final byte COMPRESSED_W_LOW = 9;
    private static final byte COMPRESSED_Y_LOW = 10;
    private static final byte COMPRESSED_H_LOW = 11;
    private static final byte COMPRESSED_K_LOW = 12;
    private static final byte COMPRESSED_D_LOW = 13;
    private static final byte COMPRESSED_B_LOW = 14;
    private static final byte COMPRESSED_N_LOW = 15;
    private static final byte COMPRESSED_EQUAL_HIGH = 0;
    private static final byte COMPRESSED_A_HIGH = 16;
    private static final byte COMPRESSED_C_HIGH = 32;
    private static final byte COMPRESSED_G_HIGH = 64;
    private static final byte COMPRESSED_T_HIGH = -128;
    private static final byte COMPRESSED_N_HIGH = -16;
    private static final byte COMPRESSED_M_HIGH = 48;
    private static final byte COMPRESSED_R_HIGH = 80;
    private static final byte COMPRESSED_S_HIGH = 96;
    private static final byte COMPRESSED_V_HIGH = 112;
    private static final byte COMPRESSED_W_HIGH = -112;
    private static final byte COMPRESSED_Y_HIGH = -96;
    private static final byte COMPRESSED_H_HIGH = -80;
    private static final byte COMPRESSED_K_HIGH = -64;
    private static final byte COMPRESSED_D_HIGH = -48;
    private static final byte COMPRESSED_B_HIGH = -32;
    public static final int MAX_PHRED_SCORE = 93;

    static byte[] bytesToCompressedBases(byte[] readBases) {
        int i;
        byte[] compressedBases = new byte[(readBases.length + 1) / 2];
        for (i = 1; i < readBases.length; i += 2) {
            compressedBases[i / 2] = (byte)(SAMUtils.charToCompressedBaseHigh(readBases[i - 1]) | SAMUtils.charToCompressedBaseLow(readBases[i]));
        }
        if (i == readBases.length) {
            compressedBases[i / 2] = SAMUtils.charToCompressedBaseHigh((char)readBases[i - 1]);
        }
        return compressedBases;
    }

    public static byte[] compressedBasesToBytes(int length, byte[] compressedBases, int compressedOffset) {
        int i;
        byte[] ret = new byte[length];
        for (i = 1; i < length; i += 2) {
            int compressedIndex = i / 2 + compressedOffset;
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[compressedIndex]);
            ret[i] = SAMUtils.compressedBaseToByteLow(compressedBases[compressedIndex]);
        }
        if (i == length) {
            ret[i - 1] = SAMUtils.compressedBaseToByteHigh(compressedBases[i / 2 + compressedOffset]);
        }
        return ret;
    }

    private static byte charToCompressedBaseLow(int base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 1;
            }
            case 67: 
            case 99: {
                return 2;
            }
            case 71: 
            case 103: {
                return 4;
            }
            case 84: 
            case 116: {
                return 8;
            }
            case 46: 
            case 78: 
            case 110: {
                return 15;
            }
            case 77: 
            case 109: {
                return 3;
            }
            case 82: 
            case 114: {
                return 5;
            }
            case 83: 
            case 115: {
                return 6;
            }
            case 86: 
            case 118: {
                return 7;
            }
            case 87: 
            case 119: {
                return 9;
            }
            case 89: 
            case 121: {
                return 10;
            }
            case 72: 
            case 104: {
                return 11;
            }
            case 75: 
            case 107: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 66: 
            case 98: {
                return 14;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte charToCompressedBaseHigh(int base) {
        switch (base) {
            case 61: {
                return 0;
            }
            case 65: 
            case 97: {
                return 16;
            }
            case 67: 
            case 99: {
                return 32;
            }
            case 71: 
            case 103: {
                return 64;
            }
            case 84: 
            case 116: {
                return -128;
            }
            case 46: 
            case 78: 
            case 110: {
                return -16;
            }
            case 77: 
            case 109: {
                return 48;
            }
            case 82: 
            case 114: {
                return 80;
            }
            case 83: 
            case 115: {
                return 96;
            }
            case 86: 
            case 118: {
                return 112;
            }
            case 87: 
            case 119: {
                return -112;
            }
            case 89: 
            case 121: {
                return -96;
            }
            case 72: 
            case 104: {
                return -80;
            }
            case 75: 
            case 107: {
                return -64;
            }
            case 68: 
            case 100: {
                return -48;
            }
            case 66: 
            case 98: {
                return -32;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte compressedBaseToByteLow(int base) {
        switch (base & 0xF) {
            case 0: {
                return 61;
            }
            case 1: {
                return 65;
            }
            case 2: {
                return 67;
            }
            case 4: {
                return 71;
            }
            case 8: {
                return 84;
            }
            case 15: {
                return 78;
            }
            case 3: {
                return 77;
            }
            case 5: {
                return 82;
            }
            case 6: {
                return 83;
            }
            case 7: {
                return 86;
            }
            case 9: {
                return 87;
            }
            case 10: {
                return 89;
            }
            case 11: {
                return 72;
            }
            case 12: {
                return 75;
            }
            case 13: {
                return 68;
            }
            case 14: {
                return 66;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    private static byte compressedBaseToByteHigh(int base) {
        switch ((byte)(base & 0xF0)) {
            case 0: {
                return 61;
            }
            case 16: {
                return 65;
            }
            case 32: {
                return 67;
            }
            case 64: {
                return 71;
            }
            case -128: {
                return 84;
            }
            case -16: {
                return 78;
            }
            case 48: {
                return 77;
            }
            case 80: {
                return 82;
            }
            case 96: {
                return 83;
            }
            case 112: {
                return 86;
            }
            case -112: {
                return 87;
            }
            case -96: {
                return 89;
            }
            case -80: {
                return 72;
            }
            case -64: {
                return 75;
            }
            case -48: {
                return 68;
            }
            case -32: {
                return 66;
            }
        }
        throw new IllegalArgumentException("Bad  byte passed to charToCompressedBase: " + base);
    }

    static void normalizeBases(byte[] bases) {
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase(bases[i]);
            if (bases[i] != 46) continue;
            bases[i] = 78;
        }
    }

    public static String phredToFastq(byte[] data) {
        if (data == null) {
            return null;
        }
        return SAMUtils.phredToFastq(data, 0, data.length);
    }

    public static String phredToFastq(byte[] buffer, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = SAMUtils.phredToFastq(buffer[offset + i] & 0xFF);
        }
        return new String(chars);
    }

    public static char phredToFastq(int phredScore) {
        if (phredScore < 0 || phredScore > 93) {
            throw new IllegalArgumentException("Cannot encode phred score: " + phredScore);
        }
        return (char)(33 + phredScore);
    }

    public static byte[] fastqToPhred(String fastq) {
        if (fastq == null) {
            return null;
        }
        int length = fastq.length();
        byte[] scores = new byte[length];
        for (int i = 0; i < length; ++i) {
            scores[i] = (byte)SAMUtils.fastqToPhred(fastq.charAt(i));
        }
        return scores;
    }

    public static void fastqToPhred(byte[] fastq) {
        for (int i = 0; i < fastq.length; ++i) {
            fastq[i] = (byte)SAMUtils.fastqToPhred((char)(fastq[i] & 0xFF));
        }
    }

    public static int fastqToPhred(char ch) {
        if (ch < '!' || ch > '~') {
            throw new IllegalArgumentException("Invalid fastq character: " + ch);
        }
        return ch - 33;
    }

    static int reg2bin(int beg, int end) {
        if (beg >> 14 == --end >> 14) {
            return 4681 + (beg >> 14);
        }
        if (beg >> 17 == end >> 17) {
            return 585 + (beg >> 17);
        }
        if (beg >> 20 == end >> 20) {
            return 73 + (beg >> 20);
        }
        if (beg >> 23 == end >> 23) {
            return 9 + (beg >> 23);
        }
        if (beg >> 26 == end >> 26) {
            return 1 + (beg >> 26);
        }
        return 0;
    }

    static void processValidationErrors(List<SAMValidationError> validationErrors, long samRecordIndex, SAMFileReader.ValidationStringency validationStringency) {
        if (validationErrors != null && validationErrors.size() > 0) {
            for (SAMValidationError validationError : validationErrors) {
                validationError.setRecordNumber(samRecordIndex);
            }
            if (validationStringency == SAMFileReader.ValidationStringency.STRICT) {
                throw new SAMFormatException("SAM validation error: " + validationErrors.get(0));
            }
            if (validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
                for (SAMValidationError error : validationErrors) {
                    System.err.println("Ignoring SAM validation error: " + error);
                }
            }
        }
    }

    static void processValidationError(SAMValidationError validationError, SAMFileReader.ValidationStringency validationStringency) {
        if (validationStringency == SAMFileReader.ValidationStringency.STRICT) {
            throw new SAMFormatException("SAM validation error: " + validationError);
        }
        if (validationStringency == SAMFileReader.ValidationStringency.LENIENT) {
            System.err.println("Ignoring SAM validation error: " + validationError);
        }
    }

    public static void chainSAMProgramRecord(SAMFileHeader header, SAMProgramRecord program) {
        List<SAMProgramRecord> pgs = header.getProgramRecords();
        if (pgs.size() > 0) {
            ArrayList<String> referencedIds = new ArrayList<String>();
            for (SAMProgramRecord pg : pgs) {
                if (pg.getPreviousProgramGroupId() == null) continue;
                referencedIds.add(pg.getPreviousProgramGroupId());
            }
            for (SAMProgramRecord pg : pgs) {
                if (pg.getProgramGroupId().equals(program.getProgramGroupId()) || referencedIds.contains(pg.getProgramGroupId())) continue;
                program.setPreviousProgramGroupId(pg.getProgramGroupId());
                break;
            }
        }
    }
}

