/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.GATKBAMFileSpan;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

class BAMScheduleEntry {
    public final int start;
    public final int stop;
    public final Map<SAMReaderID, GATKBAMFileSpan> fileSpans = new HashMap<SAMReaderID, GATKBAMFileSpan>();

    BAMScheduleEntry(int start, int stop) {
        this.start = start;
        this.stop = stop;
    }

    public void addFileSpan(SAMReaderID reader, GATKBAMFileSpan fileSpan) {
        this.fileSpans.put(reader, fileSpan);
    }

    public void mergeInto(BAMScheduleEntry other) {
        int thisSize = this.fileSpans.size();
        int otherSize = other.fileSpans.size();
        this.fileSpans.putAll(other.fileSpans);
        if (this.fileSpans.size() != thisSize + otherSize) {
            throw new ReviewedStingException("Unable to handle overlaps when merging BAM schedule entries.");
        }
    }

    public boolean isBefore(GenomeLoc locus) {
        return this.stop < locus.getStart();
    }

    public boolean overlaps(GenomeLoc position) {
        return position.getStop() >= this.start && position.getStart() <= this.stop;
    }
}

