/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.rna;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.reference.ReferenceSequenceFileWalker;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomicMap;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;

public class RemapAlignments
extends CommandLineProgram {
    @Usage(programVersion="1.0")
    public String USAGE = "Remaps custom-reference (e.g. transcriptome) alignments onto the genomic reference\n";
    @Option(shortName="M", doc="Map file: from the reference the reads were aligned to, to the master reference the alignments should be remapped to. In other words, for each custom-reference contig C this map must provide a (possibly disjoint) list of intervals on the target reference, onto which C maps base-by-base. ", optional=false)
    public File MAP_FILE = null;
    @Option(shortName="I", doc="Input file (bam or sam) with alignments to be remapped", optional=false)
    public File IN = null;
    @Option(shortName="O", doc="File to write remapped reads to.", optional=false)
    public File OUT = null;
    @Option(shortName="R", doc="Target reference to remap alignments onto.", optional=false)
    public File REFERENCE = null;
    @Option(doc="If a read has multiple alignments that are exactly the same after remapping, then keep only one copy of such alignment in output file. Multiple alignments that are not equivalent after remapping are not affected by this flag. Multiple alignments for the same query must be grouped on adjacent lines of the input file to be detected (i.e. input file must be sorted by read name), otherwise REDUCE will have no effect.", optional=true)
    public boolean REDUCE = false;
    private GenomicMap map = null;
    private String lastReadName = null;
    private int totalReads = 0;
    private int totalRecords = 0;
    private int badRecords = 0;
    private int totalUnmappedReads = 0;
    private int writtenRecords = 0;
    private Set<SAMRecord> remappedReads = null;
    private SAMFileWriter writer = null;
    private SAMFileReader reader = null;
    private static int[] g_log_n;

    public static void main(String[] argv) {
        System.exit(new RemapAlignments().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        g_log_n = new int[256];
        for (int i = 1; i < 256; ++i) {
            RemapAlignments.g_log_n[i] = (int)(4.343 * Math.log(i) + 0.5);
        }
        this.reader = new SAMFileReader(this.IN);
        this.reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        SAMFileHeader oldHeader = this.reader.getFileHeader();
        if (oldHeader == null) {
            throw new RuntimeException("Failed to retrieve SAM file header from the input bam file");
        }
        if (this.REDUCE && oldHeader.getSortOrder() != SAMFileHeader.SortOrder.queryname) {
            System.out.println("WARNING: Input file is not sorted by query name, REDUCE may have no effect. Sort order: " + (Object)((Object)oldHeader.getSortOrder()));
        }
        this.remappedReads = new TreeSet<SAMRecord>(new AlignmentComparator());
        SAMFileHeader h = new SAMFileHeader();
        for (Map.Entry<String, String> attr : oldHeader.getAttributes()) {
            h.setAttribute(attr.getKey(), attr.getValue());
        }
        h.setGroupOrder(oldHeader.getGroupOrder());
        h.setProgramRecords(oldHeader.getProgramRecords());
        h.setReadGroups(oldHeader.getReadGroups());
        if (oldHeader.getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            h.setSortOrder(SAMFileHeader.SortOrder.queryname);
        } else {
            h.setSortOrder(SAMFileHeader.SortOrder.unsorted);
        }
        ReferenceSequenceFileWalker reference = new ReferenceSequenceFileWalker(this.REFERENCE);
        if (reference.getSequenceDictionary() == null) {
            System.out.println("No reference sequence dictionary found. Aborting.");
            this.reader.close();
            System.exit(1);
        }
        h.setSequenceDictionary(reference.getSequenceDictionary());
        GenomeLocParser genomeLocParser = new GenomeLocParser(reference.getSequenceDictionary());
        this.map = new GenomicMap(10000);
        this.map.read(genomeLocParser, this.MAP_FILE);
        System.out.println("Map loaded successfully: " + this.map.size() + " contigs");
        this.writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(h, true, this.OUT);
        for (SAMRecord read : this.reader) {
            if (this.map.remapToMasterReference(read, h, true) == null) {
                ++this.badRecords;
                continue;
            }
            if (AlignmentUtils.isReadUnmapped(read)) {
                ++this.totalUnmappedReads;
            }
            read.setMateReferenceIndex(-1);
            read.setMateAlignmentStart(0);
            ++this.totalRecords;
            if (this.totalRecords % 1000000 == 0) {
                System.out.println(this.totalRecords + " valid records processed");
            }
            if (!read.getReadName().equals(this.lastReadName)) {
                ++this.totalReads;
                this.lastReadName = read.getReadName();
                if (this.REDUCE) {
                    this.updateCountsAndQuals(this.remappedReads);
                    for (SAMRecord r : this.remappedReads) {
                        this.writer.addAlignment(r);
                        ++this.writtenRecords;
                    }
                    this.remappedReads.clear();
                }
            }
            if (this.REDUCE) {
                this.remappedReads.add(read);
                continue;
            }
            this.writer.addAlignment(read);
            ++this.writtenRecords;
        }
        if (this.REDUCE) {
            this.updateCountsAndQuals(this.remappedReads);
            for (SAMRecord r : this.remappedReads) {
                this.writer.addAlignment(r);
                ++this.writtenRecords;
            }
        }
        System.out.println("Total valid records processed: " + this.totalRecords);
        System.out.println("Incorrect records (alignments across contig boundary) detected: " + this.badRecords + " (discarded and excluded from any other stats)");
        System.out.println("Total reads processed: " + this.totalReads);
        System.out.println("Total mapped reads: " + (this.totalReads - this.totalUnmappedReads));
        System.out.println("Average hits per mapped read: " + (double)(this.totalRecords - this.totalUnmappedReads) / (double)(this.totalReads - this.totalUnmappedReads));
        System.out.println("Records written: " + this.writtenRecords);
        System.out.println("Average hits per mapped read written (after reduction): " + (double)(this.writtenRecords - this.totalUnmappedReads) / (double)(this.totalReads - this.totalUnmappedReads));
        this.reader.close();
        this.writer.close();
        return 0;
    }

    private void updateCountsAndQuals(Set<SAMRecord> reads) {
        if (reads.size() == 1) {
            SAMRecord r = reads.iterator().next();
            if (AlignmentUtils.isReadUnmapped(r)) {
                r.setMappingQuality(0);
            } else {
                r.setMappingQuality(37);
                r.setAttribute("X0", (Object)new Integer(1));
                r.setAttribute("X1", (Object)new Integer(0));
            }
            r.setNotPrimaryAlignmentFlag(false);
        } else {
            SAMRecord r;
            int minNM = 1000000;
            int cnt = 0;
            Iterator<SAMRecord> it = reads.iterator();
            int n = reads.size();
            boolean canComputeMapQ = true;
            while (it.hasNext()) {
                int nm;
                r = it.next();
                if (AlignmentUtils.isReadUnmapped(r) && n > 1) {
                    it.remove();
                    --n;
                    continue;
                }
                if (!canComputeMapQ) continue;
                Object attr = r.getAttribute("NM");
                if (attr == null) {
                    canComputeMapQ = false;
                    continue;
                }
                if (attr instanceof Short) {
                    nm = ((Short)attr).intValue();
                } else if (attr instanceof Integer) {
                    nm = (Integer)attr;
                } else {
                    throw new RuntimeException("NM attribute is neither Short nor Integer, don't know what to do.");
                }
                if (nm < minNM) {
                    minNM = nm;
                    cnt = 1;
                    continue;
                }
                if (nm != minNM) continue;
                ++cnt;
            }
            if (n == 1 && AlignmentUtils.isReadUnmapped(r = reads.iterator().next())) {
                r.setAttribute("X0", (Object)new Integer(0));
                r.setAttribute("X1", (Object)new Integer(0));
                return;
            }
            for (SAMRecord r2 : reads) {
                int nm_attr;
                Object attr;
                int cnt2 = reads.size() - cnt;
                r2.setAttribute("X0", (Object)new Integer(cnt));
                r2.setAttribute("X1", (Object)new Integer(cnt2));
                if (!canComputeMapQ) continue;
                if (cnt2 > 255) {
                    cnt2 = 255;
                }
                if ((attr = r2.getAttribute("NM")) instanceof Short) {
                    nm_attr = ((Short)attr).intValue();
                } else if (attr instanceof Integer) {
                    nm_attr = (Integer)attr;
                } else {
                    throw new RuntimeException("NM attribute is neither Short nor Integer, don't know what to do.");
                }
                if (nm_attr == minNM) {
                    r2.setNotPrimaryAlignmentFlag(false);
                    if (cnt == 1) {
                        r2.setMappingQuality(23 < g_log_n[cnt2] ? 0 : 23 - g_log_n[cnt2]);
                        continue;
                    }
                    r2.setMappingQuality(0);
                    continue;
                }
                r2.setNotPrimaryAlignmentFlag(true);
                r2.setMappingQuality(0);
            }
        }
    }

    class AlignmentComparator
    implements Comparator<SAMRecord> {
        AlignmentComparator() {
        }

        @Override
        public int compare(SAMRecord r1, SAMRecord r2) {
            if (r1.getReferenceIndex() < r2.getReferenceIndex()) {
                return -1;
            }
            if (r1.getReferenceIndex() > r2.getReferenceIndex()) {
                return 1;
            }
            if (r1.getAlignmentStart() < r2.getAlignmentStart()) {
                return -1;
            }
            if (r1.getAlignmentStart() > r2.getAlignmentStart()) {
                return 1;
            }
            return r1.getCigarString().compareTo(r2.getCigarString());
        }
    }
}

