/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

public class SimpleTimer {
    private final String name;
    private long elapsed = 0L;
    private long startTime = 0L;
    boolean running = false;

    public SimpleTimer() {
        this("Anonymous");
    }

    public SimpleTimer(String name) {
        this.name = name;
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized SimpleTimer start() {
        this.elapsed = 0L;
        this.restart();
        return this;
    }

    public synchronized SimpleTimer restart() {
        this.running = true;
        this.startTime = this.currentTime();
        return this;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized long currentTime() {
        return System.currentTimeMillis();
    }

    public synchronized SimpleTimer stop() {
        this.running = false;
        this.elapsed += this.currentTime() - this.startTime;
        return this;
    }

    public synchronized double getElapsedTime() {
        return (double)(this.running ? this.currentTime() - this.startTime + this.elapsed : this.elapsed) / 1000.0;
    }
}

