/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.WriterAppender;
import ch.qos.logback.core.status.WarnStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleAppender<E>
extends WriterAppender<E> {
    public static final String SYSTEM_OUT = "System.out";
    public static final String SYSTEM_ERR = "System.err";
    protected String target = "System.out";

    public void setTarget(String value) {
        String v = value.trim();
        if (SYSTEM_OUT.equalsIgnoreCase(v)) {
            this.target = SYSTEM_OUT;
        } else if (SYSTEM_ERR.equalsIgnoreCase(v)) {
            this.target = SYSTEM_ERR;
        } else {
            this.targetWarn(value);
        }
    }

    public String getTarget() {
        return this.target;
    }

    void targetWarn(String val) {
        WarnStatus status = new WarnStatus("[" + val + " should be System.out or System.err.", this);
        status.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus(status);
    }

    @Override
    public void start() {
        if (this.target.equals(SYSTEM_OUT)) {
            this.setWriter(this.createWriter(System.out));
        } else {
            this.setWriter(this.createWriter(System.err));
        }
        super.start();
    }

    @Override
    protected final void closeWriter() {
        this.writeFooter();
    }
}

