/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileSpan;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIteratorAdapter;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class ReadShard
extends Shard {
    public static int MAX_READS = 10000;
    private final Collection<SAMRecord> reads = new ArrayList<SAMRecord>(MAX_READS);

    public ReadShard(GenomeLocParser parser, SAMDataSource readsDataSource, Map<SAMReaderID, SAMFileSpan> fileSpans, List<GenomeLoc> loci, boolean isUnmapped) {
        super(parser, Shard.ShardType.READ, loci, readsDataSource, fileSpans, isUnmapped);
    }

    static void setReadBufferSize(int bufferSize) {
        MAX_READS = bufferSize;
    }

    @Override
    public boolean buffersReads() {
        return true;
    }

    @Override
    public boolean isBufferEmpty() {
        return this.reads.size() == 0;
    }

    @Override
    public boolean isBufferFull() {
        return this.reads.size() > MAX_READS;
    }

    @Override
    public void addRead(SAMRecord read) {
        this.reads.add(read);
    }

    @Override
    public StingSAMIterator iterator() {
        return StingSAMIteratorAdapter.adapt(this.reads.iterator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<SAMReaderID, SAMFileSpan> entry : this.getFileSpans().entrySet()) {
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue());
            sb.append(' ');
        }
        return sb.toString();
    }
}

