/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RequiredCovariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class QualityScoreCovariate
implements RequiredCovariate {
    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
    }

    @Override
    public CovariateValues getValues(GATKSAMRecord read) {
        int readLength = read.getReadLength();
        Object[] mismatches = new Integer[readLength];
        Object[] insertions = new Integer[readLength];
        Object[] deletions = new Integer[readLength];
        byte[] baseQualities = read.getBaseQualities();
        byte[] baseInsertionQualities = read.getBaseInsertionQualities();
        byte[] baseDeletionQualities = read.getBaseDeletionQualities();
        for (int i = 0; i < baseQualities.length; ++i) {
            mismatches[i] = (int)baseQualities[i];
            insertions[i] = (int)baseInsertionQualities[i];
            deletions[i] = (int)baseDeletionQualities[i];
        }
        return new CovariateValues(mismatches, insertions, deletions);
    }

    @Override
    public final Object getValue(String str) {
        return Integer.parseInt(str);
    }
}

