/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

public class DoCOutputType {
    private final Partition partition;
    private final Aggregation aggregation;
    private final FileType fileType;

    public DoCOutputType(Partition partition, Aggregation aggregation, FileType fileType) {
        this.partition = partition;
        this.aggregation = aggregation;
        this.fileType = fileType;
    }

    public String getFileName(String baseName) {
        String partitionType;
        if (this.partition == null) {
            return baseName;
        }
        if (baseName.trim().equals("/dev/null")) {
            return "/dev/null";
        }
        String string = partitionType = this.partition == Partition.readgroup ? "read_group" : this.partition.toString();
        if (this.fileType == FileType.coverage_counts || this.fileType == FileType.coverage_proportions) {
            return baseName + "." + partitionType + "_" + (Object)((Object)this.aggregation) + "_" + (Object)((Object)this.fileType);
        }
        return baseName + "." + partitionType + "_" + (this.aggregation == Aggregation.interval || this.aggregation == Aggregation.gene ? (Object)((Object)this.aggregation) + "_" : "") + (Object)((Object)this.fileType);
    }

    public int hashCode() {
        return (this.partition != null ? this.partition.ordinal() + 1 : 0) * this.aggregation.ordinal() * this.fileType.ordinal();
    }

    public boolean equals(Object other) {
        if (!(other instanceof DoCOutputType)) {
            return false;
        }
        DoCOutputType otherOutputType = (DoCOutputType)other;
        return this.partition == otherOutputType.partition && this.aggregation == otherOutputType.aggregation && this.fileType == otherOutputType.fileType;
    }

    public static enum FileType {
        summary,
        statistics,
        coverage_counts,
        coverage_proportions;

    }

    public static enum Aggregation {
        locus,
        interval,
        gene,
        cumulative;

    }

    public static enum Partition {
        readgroup,
        sample,
        library,
        platform,
        center,
        sample_by_platform,
        sample_by_center,
        sample_by_platform_by_center;

    }
}

