/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidIndelGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.ExactAFCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.SNPGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

public class UnifiedGenotyperEngine {
    public static final String LOW_QUAL_FILTER_NAME = "LowQual";
    protected static final List<Allele> NO_CALL_ALLELES = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    protected static final double SUM_GL_THRESH_NOCALL = -0.001;
    private final UnifiedArgumentCollection UAC;
    private final VariantAnnotatorEngine annotationEngine;
    private ThreadLocal<Map<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel>> glcm = new ThreadLocal();
    private ThreadLocal<AlleleFrequencyCalculationModel> afcm = new ThreadLocal();
    private ThreadLocal<AlleleFrequencyCalculationResult> alleleFrequencyCalculationResult = new ThreadLocal();
    private ThreadLocal<double[]> posteriorsArray = new ThreadLocal();
    private final double[][] log10AlleleFrequencyPriorsSNPs;
    private final double[][] log10AlleleFrequencyPriorsIndels;
    private final GenotypePriors genotypePriorsSNPs;
    private final GenotypePriors genotypePriorsIndels;
    private final Set<String> samples;
    private final Logger logger;
    private final PrintStream verboseWriter;
    private final int N;
    private static final Set<String> filter = new HashSet<String>(1);
    private final GenomeLocParser genomeLocParser;
    private final boolean BAQEnabledOnCMDLine;
    private static final double[] binomialProbabilityDepthCache = new double[10000];

    public UnifiedArgumentCollection getUAC() {
        return this.UAC;
    }

    @Requires(value={"toolkit != null", "UAC != null"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC) {
        this(toolkit, UAC, Logger.getLogger(UnifiedGenotyperEngine.class), null, null, SampleUtils.getSAMFileSamples(toolkit.getSAMFileHeader()));
    }

    @Requires(value={"toolkit != null", "UAC != null", "logger != null", "samples != null && samples.size() > 0"})
    public UnifiedGenotyperEngine(GenomeAnalysisEngine toolkit, UnifiedArgumentCollection UAC, Logger logger, PrintStream verboseWriter, VariantAnnotatorEngine engine, Set<String> samples) {
        this.BAQEnabledOnCMDLine = toolkit.getArguments().BAQMode != BAQ.CalculationMode.OFF;
        this.genomeLocParser = toolkit.getGenomeLocParser();
        this.samples = new TreeSet<String>(samples);
        this.UAC = UAC.clone();
        this.logger = logger;
        this.verboseWriter = verboseWriter;
        this.annotationEngine = engine;
        this.N = 2 * this.samples.size();
        this.log10AlleleFrequencyPriorsSNPs = new double[UAC.MAX_ALTERNATE_ALLELES][this.N + 1];
        this.log10AlleleFrequencyPriorsIndels = new double[UAC.MAX_ALTERNATE_ALLELES][this.N + 1];
        UnifiedGenotyperEngine.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsSNPs, UAC.heterozygosity);
        UnifiedGenotyperEngine.computeAlleleFrequencyPriors(this.N, this.log10AlleleFrequencyPriorsIndels, UAC.INDEL_HETEROZYGOSITY);
        this.genotypePriorsSNPs = UnifiedGenotyperEngine.createGenotypePriors(GenotypeLikelihoodsCalculationModel.Model.SNP);
        this.genotypePriorsIndels = UnifiedGenotyperEngine.createGenotypePriors(GenotypeLikelihoodsCalculationModel.Model.INDEL);
        filter.add(LOW_QUAL_FILTER_NAME);
    }

    public VariantCallContext calculateLikelihoodsAndGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        GenotypeLikelihoodsCalculationModel.Model model = this.getCurrentGLModel(tracker, refContext, rawContext);
        if (model == null) {
            return this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, null, rawContext) : null;
        }
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        if (stratifiedContexts == null) {
            return this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_SITES && this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext) : null;
        }
        VariantContext vc = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model);
        if (vc == null) {
            return null;
        }
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model);
    }

    public VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        GenotypeLikelihoodsCalculationModel.Model model = this.getCurrentGLModel(tracker, refContext, rawContext);
        if (model == null) {
            return null;
        }
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        if (stratifiedContexts == null) {
            return null;
        }
        return this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.COMPLETE, null, true, model);
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, VariantContext vc) {
        GenotypeLikelihoodsCalculationModel.Model model = this.getCurrentGLModel(tracker, refContext, rawContext);
        if (model == null) {
            return null;
        }
        Map<String, AlignmentContext> stratifiedContexts = this.getFilteredAndStratifiedContexts(this.UAC, refContext, rawContext, model);
        return this.calculateGenotypes(tracker, refContext, rawContext, stratifiedContexts, vc, model);
    }

    private VariantContext calculateLikelihoods(RefMetaDataTracker tracker, ReferenceContext refContext, Map<String, AlignmentContext> stratifiedContexts, AlignmentContextUtils.ReadOrientation type, List<Allele> alternateAllelesToUse, boolean useBAQedPileup, GenotypeLikelihoodsCalculationModel.Model model) {
        if (this.glcm.get() == null) {
            this.glcm.set(UnifiedGenotyperEngine.getGenotypeLikelihoodsCalculationObject(this.logger, this.UAC));
        }
        return this.glcm.get().get((Object)model).getLikelihoods(tracker, refContext, stratifiedContexts, type, this.getGenotypePriors(model), alternateAllelesToUse, useBAQedPileup && this.BAQEnabledOnCMDLine, this.genomeLocParser);
    }

    private VariantCallContext generateEmptyContext(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, AlignmentContext rawContext) {
        VariantContext vc;
        if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
            if (vcInput == null) {
                return null;
            }
            vc = new VariantContextBuilder("UG_call", ref.getLocus().getContig(), vcInput.getStart(), vcInput.getEnd(), vcInput.getAlleles()).referenceBaseForIndel(vcInput.getReferenceBaseForIndel()).make();
        } else {
            if (!Allele.acceptableAlleleBases(new byte[]{ref.getBase()})) {
                return null;
            }
            HashSet<Allele> alleles = new HashSet<Allele>();
            alleles.add(Allele.create(ref.getBase(), true));
            vc = new VariantContextBuilder("UG_call", ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStart(), alleles).make();
        }
        if (this.annotationEngine != null) {
            ReadBackedPileup pileup = null;
            if (rawContext.hasExtendedEventPileup()) {
                pileup = rawContext.getExtendedEventPileup();
            } else if (rawContext.hasBasePileup()) {
                pileup = rawContext.getBasePileup();
            }
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            vc = this.annotationEngine.annotateContext(tracker, ref, stratifiedContexts, vc);
        }
        return new VariantCallContext(vc, false);
    }

    public VariantCallContext calculateGenotypes(VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model) {
        return this.calculateGenotypes(null, null, null, null, vc, model);
    }

    public VariantCallContext calculateGenotypes(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc, GenotypeLikelihoodsCalculationModel.Model model) {
        double phredScaledConfidence;
        boolean limitedContext;
        boolean bl = limitedContext = tracker == null || refContext == null || rawContext == null || stratifiedContexts == null;
        if (this.afcm.get() == null) {
            this.afcm.set(UnifiedGenotyperEngine.getAlleleFrequencyCalculationObject(this.N, this.logger, this.verboseWriter, this.UAC));
            this.alleleFrequencyCalculationResult.set(new AlleleFrequencyCalculationResult(this.UAC.MAX_ALTERNATE_ALLELES, this.N));
            this.posteriorsArray.set(new double[this.N + 2]);
        }
        AlleleFrequencyCalculationResult AFresult = this.alleleFrequencyCalculationResult.get();
        if (vc.getNSamples() == 0) {
            if (limitedContext) {
                return null;
            }
            return this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES ? this.estimateReferenceConfidence(vc, stratifiedContexts, this.getGenotypePriors(model).getHeterozygosity(), false, 1.0) : this.generateEmptyContext(tracker, refContext, stratifiedContexts, rawContext);
        }
        UnifiedGenotyperEngine.clearAFarray(AFresult.log10AlleleFrequencyLikelihoods);
        UnifiedGenotyperEngine.clearAFarray(AFresult.log10AlleleFrequencyPosteriors);
        List<Allele> allelesUsedInGenotyping = this.afcm.get().getLog10PNonRef(vc, this.getAlleleFrequencyPriors(model), AFresult);
        boolean bestGuessIsRef = true;
        ArrayList<Allele> myAlleles = new ArrayList<Allele>(vc.getAlleles().size());
        myAlleles.add(vc.getReference());
        for (int i = 0; i < vc.getAlternateAlleles().size(); ++i) {
            Allele alternateAllele = vc.getAlternateAllele(i);
            int indexOfAllele = allelesUsedInGenotyping.indexOf(alternateAllele);
            if (indexOfAllele == -1) continue;
            int indexOfBestAC = MathUtils.maxElementIndex(AFresult.log10AlleleFrequencyPosteriors[indexOfAllele - 1]);
            if (indexOfBestAC != 0 && AFresult.log10AlleleFrequencyPosteriors[indexOfAllele - 1][indexOfBestAC] > AFresult.log10PosteriorOfAFzero) {
                myAlleles.add(alternateAllele);
                bestGuessIsRef = false;
                continue;
            }
            if (this.UAC.GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) continue;
            myAlleles.add(alternateAllele);
        }
        double[] normalizedPosteriors = this.generateNormalizedPosteriors(AFresult, this.posteriorsArray.get());
        double PofF = 1.0 - normalizedPosteriors[0];
        if (!bestGuessIsRef || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            phredScaledConfidence = QualityUtils.phredScaleErrorRate(normalizedPosteriors[0]);
            if (Double.isInfinite(phredScaledConfidence)) {
                phredScaledConfidence = -10.0 * AFresult.log10PosteriorOfAFzero;
            }
        } else {
            phredScaledConfidence = QualityUtils.phredScaleErrorRate(PofF);
            if (Double.isInfinite(phredScaledConfidence)) {
                double sum = AFresult.log10AlleleFrequencyPosteriors[0][0];
                if (sum == Double.NEGATIVE_INFINITY) {
                    sum = 0.0;
                }
                for (int i = 1; i <= this.N && AFresult.log10AlleleFrequencyPosteriors[0][i] != Double.NEGATIVE_INFINITY; ++i) {
                    sum += AFresult.log10AlleleFrequencyPosteriors[0][i];
                }
                double d = phredScaledConfidence = MathUtils.compareDoubles(sum, 0.0) == 0 ? 0.0 : -10.0 * sum;
            }
        }
        if (this.UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES && !this.passesEmitThreshold(phredScaledConfidence, bestGuessIsRef)) {
            return limitedContext ? null : this.estimateReferenceConfidence(vc, stratifiedContexts, this.getGenotypePriors(model).getHeterozygosity(), true, 1.0 - PofF);
        }
        GenomeLoc loc = this.genomeLocParser.createGenomeLoc(vc);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), loc.getStop(), myAlleles);
        builder.log10PError(phredScaledConfidence / -10.0);
        if (!this.passesCallThreshold(phredScaledConfidence)) {
            builder.filters(filter);
        }
        if (limitedContext) {
            builder.referenceBaseForIndel(vc.getReferenceBaseForIndel());
        } else {
            builder.referenceBaseForIndel(refContext.getBase());
        }
        GenotypesContext genotypes = UnifiedGenotyperEngine.subsetAlleles(vc, myAlleles, true);
        if (this.verboseWriter != null && !limitedContext) {
            this.printVerboseData(refContext.getLocus().toString(), vc, PofF, phredScaledConfidence, normalizedPosteriors, model);
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (!limitedContext && rawContext.hasPileupBeenDownsampled()) {
            attributes.put("DS", true);
        }
        if (!(this.UAC.NO_SLOD || limitedContext || bestGuessIsRef)) {
            double overallLog10PofF = MathUtils.log10sumLog10(AFresult.log10AlleleFrequencyPosteriors[0], 0);
            List<Allele> alternateAllelesToUse = builder.make().getAlternateAlleles();
            VariantContext vcForward = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.FORWARD, alternateAllelesToUse, false, model);
            UnifiedGenotyperEngine.clearAFarray(AFresult.log10AlleleFrequencyLikelihoods);
            UnifiedGenotyperEngine.clearAFarray(AFresult.log10AlleleFrequencyPosteriors);
            this.afcm.get().getLog10PNonRef(vcForward, this.getAlleleFrequencyPriors(model), AFresult);
            double forwardLog10PofNull = AFresult.log10PosteriorOfAFzero;
            double forwardLog10PofF = MathUtils.log10sumLog10(AFresult.log10AlleleFrequencyPosteriors[0], 0);
            VariantContext vcReverse = this.calculateLikelihoods(tracker, refContext, stratifiedContexts, AlignmentContextUtils.ReadOrientation.REVERSE, alternateAllelesToUse, false, model);
            UnifiedGenotyperEngine.clearAFarray(AFresult.log10AlleleFrequencyLikelihoods);
            UnifiedGenotyperEngine.clearAFarray(AFresult.log10AlleleFrequencyPosteriors);
            this.afcm.get().getLog10PNonRef(vcReverse, this.getAlleleFrequencyPriors(model), AFresult);
            double reverseLog10PofNull = AFresult.log10PosteriorOfAFzero;
            double reverseLog10PofF = MathUtils.log10sumLog10(AFresult.log10AlleleFrequencyPosteriors[0], 0);
            double forwardLod = forwardLog10PofF + reverseLog10PofNull - overallLog10PofF;
            double reverseLod = reverseLog10PofF + forwardLog10PofNull - overallLog10PofF;
            double strandScore = Math.max(forwardLod, reverseLod);
            if (!Double.isNaN(strandScore *= 10.0)) {
                attributes.put("SB", strandScore);
            }
        }
        builder.genotypes(genotypes);
        builder.attributes(attributes);
        VariantContext vcCall = builder.make();
        if (this.annotationEngine != null && !limitedContext) {
            ReadBackedPileup pileup = null;
            if (rawContext.hasExtendedEventPileup()) {
                pileup = rawContext.getExtendedEventPileup();
            } else if (rawContext.hasBasePileup()) {
                pileup = rawContext.getBasePileup();
            }
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            vcCall = this.annotationEngine.annotateContext(tracker, refContext, stratifiedContexts, vcCall);
        }
        return new VariantCallContext(vcCall, this.confidentlyCalled(phredScaledConfidence, PofF));
    }

    private double[] generateNormalizedPosteriors(AlleleFrequencyCalculationResult AFresult, double[] normalizedPosteriors) {
        normalizedPosteriors[0] = AFresult.log10PosteriorOfAFzero;
        System.arraycopy(AFresult.log10AlleleFrequencyPosteriors[0], 0, normalizedPosteriors, 1, normalizedPosteriors.length - 1);
        return MathUtils.normalizeFromLog10(normalizedPosteriors);
    }

    private Map<String, AlignmentContext> getFilteredAndStratifiedContexts(UnifiedArgumentCollection UAC, ReferenceContext refContext, AlignmentContext rawContext, GenotypeLikelihoodsCalculationModel.Model model) {
        Map<String, AlignmentContext> stratifiedContexts = null;
        if (!BaseUtils.isRegularBase(refContext.getBase())) {
            return null;
        }
        if (model == GenotypeLikelihoodsCalculationModel.Model.INDEL) {
            if (UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                ReadBackedPileup pileup = rawContext.getBasePileup().getMappingFilteredPileup(UAC.MIN_BASE_QUALTY_SCORE);
                if (pileup.getNumberOfElements() == 0 && UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES) {
                    return null;
                }
                stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            } else {
                if (!rawContext.hasExtendedEventPileup()) {
                    return null;
                }
                ReadBackedExtendedEventPileup rawPileup = rawContext.getExtendedEventPileup();
                ReadBackedExtendedEventPileup pileup = rawPileup.getMappingFilteredPileup(UAC.MIN_BASE_QUALTY_SCORE);
                if (pileup.getNumberOfElements() == 0 && UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES) {
                    return null;
                }
                stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(pileup);
            }
        } else if (model == GenotypeLikelihoodsCalculationModel.Model.SNP) {
            stratifiedContexts = AlignmentContextUtils.splitContextBySampleName(rawContext.getBasePileup());
            if (UAC.OutputMode != OUTPUT_MODE.EMIT_ALL_SITES || UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                int numDeletions = 0;
                for (PileupElement p : rawContext.getBasePileup()) {
                    if (!p.isDeletion()) continue;
                    ++numDeletions;
                }
                if ((double)numDeletions / (double)rawContext.getBasePileup().getNumberOfElements() > UAC.MAX_DELETION_FRACTION) {
                    return null;
                }
            }
        }
        return stratifiedContexts;
    }

    protected static void clearAFarray(double[][] AFs) {
        for (int i = 0; i < AFs.length; ++i) {
            for (int j = 0; j < AFs[i].length; ++j) {
                AFs[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
    }

    private final double getRefBinomialProb(int depth) {
        if (depth < binomialProbabilityDepthCache.length) {
            return binomialProbabilityDepthCache[depth];
        }
        return MathUtils.binomialProbability(0, depth, 0.5);
    }

    private VariantCallContext estimateReferenceConfidence(VariantContext vc, Map<String, AlignmentContext> contexts, double theta, boolean ignoreCoveredSamples, double initialPofRef) {
        if (contexts == null) {
            return null;
        }
        double P_of_ref = initialPofRef;
        for (String sample : this.samples) {
            boolean isCovered = contexts.containsKey(sample);
            if (ignoreCoveredSamples && isCovered) continue;
            int depth = 0;
            if (isCovered) {
                AlignmentContext context = contexts.get(sample);
                if (context.hasBasePileup()) {
                    depth = context.getBasePileup().depthOfCoverage();
                } else if (context.hasExtendedEventPileup()) {
                    depth = context.getExtendedEventPileup().depthOfCoverage();
                }
            }
            P_of_ref *= 1.0 - theta / 2.0 * this.getRefBinomialProb(depth);
        }
        return new VariantCallContext(vc, QualityUtils.phredScaleErrorRate(1.0 - P_of_ref) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, false);
    }

    protected void printVerboseData(String pos, VariantContext vc, double PofF, double phredScaledConfidence, double[] normalizedPosteriors, GenotypeLikelihoodsCalculationModel.Model model) {
        Allele refAllele = null;
        Allele altAllele = null;
        for (Allele allele : vc.getAlleles()) {
            if (allele.isReference()) {
                refAllele = allele;
                continue;
            }
            altAllele = allele;
        }
        for (int i = 0; i <= this.N; ++i) {
            StringBuilder AFline = new StringBuilder("AFINFO\t");
            AFline.append(pos);
            AFline.append("\t");
            AFline.append(refAllele);
            AFline.append("\t");
            if (altAllele != null) {
                AFline.append(altAllele);
            } else {
                AFline.append("N/A");
            }
            AFline.append("\t");
            AFline.append(i + "/" + this.N + "\t");
            AFline.append(String.format("%.2f\t", Float.valueOf((float)i / (float)this.N)));
            AFline.append(String.format("%.8f\t", new Object[]{this.getAlleleFrequencyPriors(model)[i]}));
            if (this.alleleFrequencyCalculationResult.get().log10AlleleFrequencyPosteriors[0][i] == Double.NEGATIVE_INFINITY) {
                AFline.append("0.00000000\t");
            } else {
                AFline.append(String.format("%.8f\t", new Object[]{this.alleleFrequencyCalculationResult.get().log10AlleleFrequencyPosteriors[i]}));
            }
            AFline.append(String.format("%.8f\t", normalizedPosteriors[i]));
            this.verboseWriter.println(AFline.toString());
        }
        this.verboseWriter.println("P(f>0) = " + PofF);
        this.verboseWriter.println("Qscore = " + phredScaledConfidence);
        this.verboseWriter.println();
    }

    protected boolean passesEmitThreshold(double conf, boolean bestGuessIsRef) {
        return (this.UAC.OutputMode == OUTPUT_MODE.EMIT_ALL_CONFIDENT_SITES || !bestGuessIsRef) && conf >= Math.min(this.UAC.STANDARD_CONFIDENCE_FOR_CALLING, this.UAC.STANDARD_CONFIDENCE_FOR_EMITTING);
    }

    protected boolean passesCallThreshold(double conf) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    protected boolean confidentlyCalled(double conf, double PofF) {
        return conf >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING || this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES && QualityUtils.phredScaleErrorRate(PofF) >= this.UAC.STANDARD_CONFIDENCE_FOR_CALLING;
    }

    private GenotypeLikelihoodsCalculationModel.Model getCurrentGLModel(RefMetaDataTracker tracker, ReferenceContext refContext, AlignmentContext rawContext) {
        if (rawContext.hasExtendedEventPileup()) {
            if ((this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.INDEL) && this.UAC.GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
                return GenotypeLikelihoodsCalculationModel.Model.INDEL;
            }
        } else if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vcInput = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, refContext, rawContext.getLocation(), false, this.logger, this.UAC.alleles);
            if (vcInput == null) {
                return null;
            }
            if (vcInput.isMNP()) {
                return null;
            }
            if (vcInput.isSNP()) {
                if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.SNP) {
                    return GenotypeLikelihoodsCalculationModel.Model.SNP;
                }
                return null;
            }
            if ((vcInput.isIndel() || vcInput.isMixed()) && (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.INDEL)) {
                return GenotypeLikelihoodsCalculationModel.Model.INDEL;
            }
        } else {
            if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.BOTH || this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.SNP) {
                return GenotypeLikelihoodsCalculationModel.Model.SNP;
            }
            if (this.UAC.GLmodel == GenotypeLikelihoodsCalculationModel.Model.INDEL) {
                return GenotypeLikelihoodsCalculationModel.Model.INDEL;
            }
        }
        return null;
    }

    protected static void computeAlleleFrequencyPriors(int N, double[][] priors, double theta) {
        for (int alleles = 1; alleles <= priors.length; ++alleles) {
            double sum = 0.0;
            for (int i = 1; i <= N; ++i) {
                double value = Math.pow(theta, alleles) / (double)i;
                priors[alleles - 1][i] = Math.log10(value);
                sum += value;
            }
            priors[alleles - 1][0] = Math.log10(1.0 - sum);
        }
    }

    protected double[][] getAlleleFrequencyPriors(GenotypeLikelihoodsCalculationModel.Model model) {
        switch (model) {
            case SNP: {
                return this.log10AlleleFrequencyPriorsSNPs;
            }
            case INDEL: {
                return this.log10AlleleFrequencyPriorsIndels;
            }
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    private static GenotypePriors createGenotypePriors(GenotypeLikelihoodsCalculationModel.Model model) {
        GenotypePriors priors;
        switch (model) {
            case SNP: {
                priors = new DiploidSNPGenotypePriors();
                break;
            }
            case INDEL: {
                priors = new DiploidIndelGenotypePriors();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
            }
        }
        return priors;
    }

    protected GenotypePriors getGenotypePriors(GenotypeLikelihoodsCalculationModel.Model model) {
        switch (model) {
            case SNP: {
                return this.genotypePriorsSNPs;
            }
            case INDEL: {
                return this.genotypePriorsIndels;
            }
        }
        throw new IllegalArgumentException("Unexpected GenotypeCalculationModel " + (Object)((Object)model));
    }

    private static Map<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel> getGenotypeLikelihoodsCalculationObject(Logger logger, UnifiedArgumentCollection UAC) {
        HashMap<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel> glcm = new HashMap<GenotypeLikelihoodsCalculationModel.Model, GenotypeLikelihoodsCalculationModel>();
        glcm.put(GenotypeLikelihoodsCalculationModel.Model.SNP, new SNPGenotypeLikelihoodsCalculationModel(UAC, logger));
        glcm.put(GenotypeLikelihoodsCalculationModel.Model.INDEL, new IndelGenotypeLikelihoodsCalculationModel(UAC, logger));
        return glcm;
    }

    private static AlleleFrequencyCalculationModel getAlleleFrequencyCalculationObject(int N, Logger logger, PrintStream verboseWriter, UnifiedArgumentCollection UAC) {
        ExactAFCalculationModel afcm;
        switch (UAC.AFmodel) {
            case EXACT: {
                afcm = new ExactAFCalculationModel(UAC, N, logger, verboseWriter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected AlleleFrequencyCalculationModel " + (Object)((Object)UAC.AFmodel));
            }
        }
        return afcm;
    }

    public static VariantContext getVCFromAllelesRod(RefMetaDataTracker tracker, ReferenceContext ref, GenomeLoc loc, boolean requireSNP, Logger logger, RodBinding<VariantContext> allelesBinding) {
        if (tracker == null || ref == null || logger == null) {
            throw new ReviewedStingException("Bad arguments: tracker=" + tracker + " ref=" + ref + " logger=" + logger);
        }
        VariantContext vc = null;
        for (VariantContext vc_input : tracker.getValues(allelesBinding, loc)) {
            if (vc_input == null || vc_input.isFiltered() || requireSNP && !vc_input.isSNP()) continue;
            if (vc == null) {
                vc = vc_input;
                continue;
            }
            logger.warn("Multiple valid VCF records detected in the alleles input file at site " + ref.getLocus() + ", only considering the first record");
        }
        return vc;
    }

    public static GenotypesContext assignGenotypes(VariantContext vc) {
        return UnifiedGenotyperEngine.subsetAlleles(vc, vc.getAlleles(), true);
    }

    public static GenotypesContext subsetAlleles(VariantContext vc, List<Allele> allelesToUse, boolean assignGenotypes) {
        GenotypesContext oldGTs = vc.getGenotypes();
        List<String> sampleIndices = oldGTs.getSampleNamesOrderedByName();
        GenotypesContext newGTs = GenotypesContext.create();
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        int numNewAltAlleles = allelesToUse.size() - 1;
        ArrayList<Integer> likelihoodIndexesToUse = null;
        if (numNewAltAlleles != numOriginalAltAlleles && numNewAltAlleles > 0) {
            likelihoodIndexesToUse = new ArrayList<Integer>(30);
            boolean[] altAlleleIndexToUse = new boolean[numOriginalAltAlleles];
            for (int i = 0; i < numOriginalAltAlleles; ++i) {
                if (!allelesToUse.contains(vc.getAlternateAllele(i))) continue;
                altAlleleIndexToUse[i] = true;
            }
            int numLikelihoods = GenotypeLikelihoods.calculateNumLikelihoods(numOriginalAltAlleles);
            for (int PLindex = 0; PLindex < numLikelihoods; ++PLindex) {
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
                if (alleles.alleleIndex1 != 0 && !altAlleleIndexToUse[alleles.alleleIndex1 - 1] || alleles.alleleIndex2 != 0 && !altAlleleIndexToUse[alleles.alleleIndex2 - 1]) continue;
                likelihoodIndexesToUse.add(PLindex);
            }
        }
        for (int k = 0; k < oldGTs.size(); ++k) {
            double[] newLikelihoods;
            Genotype g = oldGTs.get(sampleIndices.get(k));
            if (!g.hasLikelihoods()) {
                newGTs.add(new Genotype(g.getSampleName(), NO_CALL_ALLELES, 1.0, null, null, false));
                continue;
            }
            double[] originalLikelihoods = g.getLikelihoods().getAsVector();
            if (likelihoodIndexesToUse == null) {
                newLikelihoods = originalLikelihoods;
            } else {
                newLikelihoods = new double[likelihoodIndexesToUse.size()];
                int newIndex = 0;
                Iterator i$ = likelihoodIndexesToUse.iterator();
                while (i$.hasNext()) {
                    int oldIndex = (Integer)i$.next();
                    newLikelihoods[newIndex++] = originalLikelihoods[oldIndex];
                }
                newLikelihoods = MathUtils.normalizeFromLog10(newLikelihoods, false, true);
            }
            if (MathUtils.sum(newLikelihoods) > -0.001) {
                newGTs.add(new Genotype(g.getSampleName(), NO_CALL_ALLELES, 1.0, null, null, false));
                continue;
            }
            HashMap<String, Object> attrs = new HashMap<String, Object>(g.getAttributes());
            if (numNewAltAlleles == 0) {
                attrs.remove("PL");
            } else {
                attrs.put("PL", GenotypeLikelihoods.fromLog10Likelihoods(newLikelihoods));
            }
            if (!assignGenotypes || MathUtils.sum(newLikelihoods) > -0.001) {
                newGTs.add(new Genotype(g.getSampleName(), NO_CALL_ALLELES, 1.0, null, attrs, false));
                continue;
            }
            newGTs.add(UnifiedGenotyperEngine.assignGenotype(g, newLikelihoods, allelesToUse, numNewAltAlleles, attrs));
        }
        return newGTs;
    }

    protected static Genotype assignGenotype(Genotype originalGT, double[] newLikelihoods, List<Allele> allelesToUse, int numNewAltAlleles, Map<String, Object> attrs) {
        int PLindex = numNewAltAlleles == 0 ? 0 : MathUtils.maxElementIndex(newLikelihoods);
        GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
        ArrayList<Allele> myAlleles = new ArrayList<Allele>();
        myAlleles.add(allelesToUse.get(alleles.alleleIndex1));
        myAlleles.add(allelesToUse.get(alleles.alleleIndex2));
        double qual = numNewAltAlleles == 0 ? 1.0 : GenotypeLikelihoods.getQualFromLikelihoods(PLindex, newLikelihoods);
        return new Genotype(originalGT.getSampleName(), myAlleles, qual, null, attrs, false);
    }

    static {
        for (int i = 1; i < binomialProbabilityDepthCache.length; ++i) {
            UnifiedGenotyperEngine.binomialProbabilityDepthCache[i] = MathUtils.binomialProbability(0, i, 0.5);
        }
    }

    public static enum OUTPUT_MODE {
        EMIT_VARIANTS_ONLY,
        EMIT_ALL_CONFIDENT_SITES,
        EMIT_ALL_SITES;

    }
}

