/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SampleStats;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SampleSummaryStats;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Genotype Concordance", description="Determine the genotype concordance between the genotypes in difference tracks")
public class GenotypeConcordance
extends VariantEvaluator {
    private static final boolean PRINT_INTERESTING_SITES = true;
    protected static final Logger logger = Logger.getLogger(GenotypeConcordance.class);
    @DataPoint(description="the detailed concordance statistics for each sample")
    SampleStats detailedStats = null;
    @DataPoint(description="the simplified concordance statistics for each sample")
    SampleSummaryStats simplifiedStats = null;
    private static final int MAX_MISSED_VALIDATION_DATA = 100;
    private boolean discordantInteresting = false;
    private HashSet<VariantContext> missedValidationData = new HashSet();
    private boolean warnedAboutValidationData = false;

    public String getName() {
        return "genotypeConcordance";
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String toString() {
        return this.getName() + ": <table>";
    }

    @Override
    public String update2(VariantContext eval, VariantContext validation, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        String interesting = null;
        if (validation != null && !validation.hasGenotypes() || eval == null && !GenotypeConcordance.isValidVC(validation)) {
            return interesting;
        }
        if (this.detailedStats == null) {
            if (eval != null) {
                this.detailedStats = new SampleStats(eval, Genotype.Type.values().length);
                this.simplifiedStats = new SampleSummaryStats(eval);
                for (VariantContext vc : this.missedValidationData) {
                    this.determineStats(null, vc);
                }
                this.missedValidationData = null;
            } else {
                if (this.missedValidationData.size() > 100) {
                    if (!this.warnedAboutValidationData) {
                        this.warnedAboutValidationData = true;
                    }
                } else {
                    this.missedValidationData.add(validation);
                }
                return interesting;
            }
        }
        interesting = this.determineStats(eval, validation);
        return interesting;
    }

    private String determineStats(VariantContext eval, VariantContext validation) {
        String validationAC;
        String interesting = null;
        boolean validationIsValidVC = GenotypeConcordance.isValidVC(validation);
        String evalAC = this.vcHasGoodAC(eval) ? String.format("evalAC%d", this.getAC(eval)) : null;
        String string = validationAC = this.vcHasGoodAC(validation) ? String.format("compAC%d", this.getAC(validation)) : null;
        if (eval != null) {
            for (Genotype g : eval.getGenotypes()) {
                Genotype.Type truth;
                String sample = g.getSampleName();
                Genotype.Type called = g.getType();
                if (!validationIsValidVC || !validation.hasGenotype(sample)) {
                    truth = Genotype.Type.NO_CALL;
                } else {
                    truth = validation.getGenotype(sample).getType();
                    if (this.discordantInteresting && truth.ordinal() != called.ordinal()) {
                        interesting = "ConcordanceStatus=" + (Object)((Object)truth) + "/" + (Object)((Object)called);
                    }
                }
                this.detailedStats.incrValue(sample, truth, called);
            }
        } else {
            Genotype.Type called = Genotype.Type.NO_CALL;
            for (Genotype g : validation.getGenotypes()) {
                Genotype.Type truth = g.getType();
                this.detailedStats.incrValue(g.getSampleName(), truth, called);
            }
        }
        return interesting;
    }

    private static boolean isValidVC(VariantContext vc) {
        return vc != null && !vc.isFiltered();
    }

    @Override
    public void finalizeEvaluation() {
        if (this.simplifiedStats != null && this.detailedStats != null) {
            this.simplifiedStats.generateSampleSummaryStats(this.detailedStats);
        }
    }

    private boolean vcHasGoodAC(VariantContext vc) {
        return vc != null && vc.getAlternateAlleles().size() == 1 && vc.hasAttribute("AC");
    }

    private int getAC(VariantContext vc) {
        if (List.class.isAssignableFrom(vc.getAttribute("AC").getClass())) {
            return (Integer)((List)vc.getAttribute("AC")).get(0);
        }
        if (Integer.class.isAssignableFrom(vc.getAttribute("AC").getClass())) {
            return (Integer)vc.getAttribute("AC");
        }
        if (String.class.isAssignableFrom(vc.getAttribute("AC").getClass())) {
            String ac = (String)vc.getAttribute("AC");
            if (ac.startsWith("[")) {
                return Integer.parseInt(ac.replaceAll("\\[", "").replaceAll("\\]", ""));
            }
            try {
                return Integer.parseInt(ac);
            }
            catch (NumberFormatException e) {
                throw new UserException(String.format("The format of the AC field is improperly formatted: AC=%s", ac));
            }
        }
        throw new UserException(String.format("The format of the AC field does not appear to be of integer-list or String format, class was %s", vc.getAttribute("AC").getClass()));
    }

    static class QualityScoreHistograms
    implements TableType {
        static final int NUM_BINS = 20;
        final HashMap<Integer, Integer> truePositiveQualityScoreMap = new HashMap();
        final HashMap<Integer, Integer> falsePositiveQualityScoreMap = new HashMap();
        final int[] truePositiveHist = new int[20];
        final int[] falsePositiveHist = new int[20];
        final String[] rowKeys = new String[]{"true_positive_hist", "false_positive_hist"};

        QualityScoreHistograms() {
        }

        @Override
        public Object[] getRowKeys() {
            return this.rowKeys;
        }

        @Override
        public Object[] getColumnKeys() {
            Object[] columnKeys = new String[20];
            for (int iii = 0; iii < 20; ++iii) {
                columnKeys[iii] = "histBin" + iii;
            }
            return columnKeys;
        }

        @Override
        public String getName() {
            return "QualityScoreHistogram";
        }

        @Override
        public String getCell(int x, int y) {
            if (x == 0) {
                return String.valueOf(this.truePositiveHist[y]);
            }
            if (x == 1) {
                return String.valueOf(this.falsePositiveHist[y]);
            }
            throw new ReviewedStingException("Unknown row in " + this.getName() + ", row = " + x);
        }

        public String toString() {
            int iii;
            String returnString = "";
            returnString = returnString + "TP: ";
            for (iii = 0; iii < 20; ++iii) {
                returnString = returnString + this.truePositiveHist[iii] + " ";
            }
            returnString = returnString + "\nFP: ";
            for (iii = 0; iii < 20; ++iii) {
                returnString = returnString + this.falsePositiveHist[iii] + " ";
            }
            return returnString;
        }

        public void incrValue(double qual, boolean isTruePositiveCall) {
            Integer qualKey;
            HashMap<Integer, Integer> qualScoreMap = isTruePositiveCall ? this.truePositiveQualityScoreMap : this.falsePositiveQualityScoreMap;
            if (qualScoreMap.containsKey(qualKey = Integer.valueOf(Math.round((float)qual)))) {
                qualScoreMap.put(qualKey, qualScoreMap.get(qualKey) + 1);
            } else {
                qualScoreMap.put(qualKey, 1);
            }
        }

        public void organizeHistogramTables() {
            int index;
            for (int iii = 0; iii < 20; ++iii) {
                this.truePositiveHist[iii] = 0;
                this.falsePositiveHist[iii] = 0;
            }
            int maxQual = 0;
            for (Integer qual : this.truePositiveQualityScoreMap.keySet()) {
                if (qual <= maxQual) continue;
                maxQual = qual;
            }
            for (Integer qual : this.falsePositiveQualityScoreMap.keySet()) {
                if (qual <= maxQual) continue;
                maxQual = qual;
            }
            double binSize = (double)maxQual / 19.0;
            for (Integer qual : this.truePositiveQualityScoreMap.keySet()) {
                index = (int)Math.floor((double)qual.intValue() / binSize);
                if (index < 0) continue;
                int n = index;
                this.truePositiveHist[n] = this.truePositiveHist[n] + this.truePositiveQualityScoreMap.get(qual);
            }
            for (Integer qual : this.falsePositiveQualityScoreMap.keySet()) {
                index = (int)Math.floor((double)qual.intValue() / binSize);
                if (index < 0) continue;
                int n = index;
                this.falsePositiveHist[n] = this.falsePositiveHist[n] + this.falsePositiveQualityScoreMap.get(qual);
            }
        }
    }

    static class FrequencyStats
    implements TableType {
        public HashMap<Integer, Stats> foundMissedByAC = new HashMap();

        FrequencyStats() {
        }

        @Override
        public Object[] getRowKeys() {
            Object[] rows = new String[this.foundMissedByAC.size()];
            int index = 0;
            for (int i : this.foundMissedByAC.keySet()) {
                rows[index++] = "AlleleCount_" + i;
            }
            return rows;
        }

        @Override
        public Object[] getColumnKeys() {
            return new String[]{"number_found", "number_missing"};
        }

        @Override
        public String getName() {
            return "FrequencyStats";
        }

        @Override
        public String getCell(int x, int y) {
            if (x >= this.foundMissedByAC.size()) {
                throw new IllegalStateException(x + " is greater than the max index of " + (this.foundMissedByAC.size() - 1));
            }
            if (y == 0) {
                return String.valueOf(this.foundMissedByAC.get((Object)this.foundMissedByAC.keySet().toArray(new Integer[this.foundMissedByAC.size()])[x]).nFound);
            }
            return String.valueOf(this.foundMissedByAC.get((Object)this.foundMissedByAC.keySet().toArray(new Integer[this.foundMissedByAC.size()])[x]).nMissed);
        }

        public void incrementFoundCount(int alleleFreq) {
            if (!this.foundMissedByAC.containsKey(alleleFreq)) {
                this.foundMissedByAC.put(alleleFreq, new Stats(1, 0));
            } else {
                ++this.foundMissedByAC.get((Object)Integer.valueOf((int)alleleFreq)).nFound;
            }
        }

        public void incrementMissedCount(int alleleFreq) {
            if (!this.foundMissedByAC.containsKey(alleleFreq)) {
                this.foundMissedByAC.put(alleleFreq, new Stats(0, 1));
            } else {
                ++this.foundMissedByAC.get((Object)Integer.valueOf((int)alleleFreq)).nMissed;
            }
        }

        class Stats {
            public long nFound = 0L;
            public long nMissed = 0L;

            public Stats(int found, int missed) {
                this.nFound = found;
                this.nMissed = missed;
            }
        }
    }
}

