/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.EnumSet;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SampleStats;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

class SampleSummaryStats
implements TableType {
    protected static final String ALL_SAMPLES_KEY = "allSamples";
    protected static final String[] COLUMN_KEYS = new String[]{"percent_comp_ref_called_ref", "percent_comp_het_called_het", "percent_comp_hom_called_hom", "percent_non_reference_sensitivity", "percent_overall_genotype_concordance", "percent_non_reference_discrepancy_rate"};
    protected final HashMap<String, double[]> concordanceSummary = new HashMap();
    final long[] allSamplesNumerators = new long[COLUMN_KEYS.length];
    final long[] allSamplesDenominators = new long[COLUMN_KEYS.length];

    @Override
    public Object[] getRowKeys() {
        return this.concordanceSummary.keySet().toArray(new String[this.concordanceSummary.size()]);
    }

    @Override
    public Object[] getColumnKeys() {
        return COLUMN_KEYS;
    }

    public SampleSummaryStats(VariantContext vc) {
        this.concordanceSummary.put(ALL_SAMPLES_KEY, new double[COLUMN_KEYS.length]);
        for (Genotype g : vc.getGenotypes()) {
            this.concordanceSummary.put(g.getSampleName(), new double[COLUMN_KEYS.length]);
        }
    }

    public SampleSummaryStats() {
    }

    @Override
    public Object getCell(int x, int y) {
        Object[] rowKeys = this.getRowKeys();
        return String.format("%.2f", this.concordanceSummary.get(rowKeys[x])[y]);
    }

    private long sumStatsAllPairs(long[][] stats, EnumSet<Genotype.Type> d1, EnumSet<Genotype.Type> d2) {
        long sum = 0L;
        for (Genotype.Type e1 : d1) {
            for (Genotype.Type e2 : d2) {
                sum += stats[e1.ordinal()][e2.ordinal()];
            }
        }
        return sum;
    }

    private long sumStatsDiag(long[][] stats, EnumSet<Genotype.Type> d1) {
        long sum = 0L;
        for (Genotype.Type e1 : d1) {
            sum += stats[e1.ordinal()][e1.ordinal()];
        }
        return sum;
    }

    private double ratio(long numer, long denom) {
        return denom != 0L ? 100.0 * ((double)numer / (double)denom) : 0.0;
    }

    private void updateSummaries(int i, double[] summary, long numer, long denom) {
        int n = i;
        this.allSamplesNumerators[n] = this.allSamplesNumerators[n] + numer;
        int n2 = i;
        this.allSamplesDenominators[n2] = this.allSamplesDenominators[n2] + denom;
        summary[i] = this.ratio(numer, denom);
    }

    public void generateSampleSummaryStats(SampleStats sampleStats) {
        EnumSet<Genotype.Type> allVariantGenotypes = EnumSet.of(Genotype.Type.HOM_VAR, Genotype.Type.HET);
        EnumSet<Genotype.Type> allCalledGenotypes = EnumSet.of(Genotype.Type.HOM_VAR, Genotype.Type.HET, Genotype.Type.HOM_REF);
        EnumSet<Genotype.Type> allGenotypes = EnumSet.allOf(Genotype.Type.class);
        for (String sample : this.concordanceSummary.keySet()) {
            if (sample.equals(ALL_SAMPLES_KEY)) continue;
            long[][] stats = sampleStats.concordanceStats.get(sample);
            double[] summary = this.concordanceSummary.get(sample);
            if (stats == null) {
                throw new ReviewedStingException("SampleStats and SampleSummaryStats contain different samples! sample = " + sample);
            }
            long numer = stats[Genotype.Type.HOM_REF.ordinal()][Genotype.Type.HOM_REF.ordinal()];
            long denom = this.sumStatsAllPairs(stats, EnumSet.of(Genotype.Type.HOM_REF), allGenotypes);
            this.updateSummaries(0, summary, numer, denom);
            numer = stats[Genotype.Type.HET.ordinal()][Genotype.Type.HET.ordinal()];
            denom = this.sumStatsAllPairs(stats, EnumSet.of(Genotype.Type.HET), allGenotypes);
            this.updateSummaries(1, summary, numer, denom);
            numer = stats[Genotype.Type.HOM_VAR.ordinal()][Genotype.Type.HOM_VAR.ordinal()];
            denom = this.sumStatsAllPairs(stats, EnumSet.of(Genotype.Type.HOM_VAR), allGenotypes);
            this.updateSummaries(2, summary, numer, denom);
            numer = this.sumStatsAllPairs(stats, allVariantGenotypes, allVariantGenotypes);
            denom = this.sumStatsAllPairs(stats, allVariantGenotypes, allGenotypes);
            this.updateSummaries(3, summary, numer, denom);
            numer = this.sumStatsDiag(stats, allCalledGenotypes);
            denom = this.sumStatsAllPairs(stats, allCalledGenotypes, allCalledGenotypes);
            this.updateSummaries(4, summary, numer, denom);
            long homrefConcords = stats[Genotype.Type.HOM_REF.ordinal()][Genotype.Type.HOM_REF.ordinal()];
            long diag = this.sumStatsDiag(stats, allVariantGenotypes);
            long allNoHomRef = this.sumStatsAllPairs(stats, allCalledGenotypes, allCalledGenotypes) - homrefConcords;
            numer = allNoHomRef - diag;
            denom = allNoHomRef;
            this.updateSummaries(5, summary, numer, denom);
        }
        double[] allSamplesSummary = this.concordanceSummary.get(ALL_SAMPLES_KEY);
        for (int i = 0; i < allSamplesSummary.length; ++i) {
            allSamplesSummary[i] = this.ratio(this.allSamplesNumerators[i], this.allSamplesDenominators[i]);
        }
    }

    @Override
    public String getName() {
        return "Sample Summary Statistics";
    }
}

