/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

public class CoordMath {
    public static int getLength(int start, int end) {
        return end - start + 1;
    }

    public static int getStart(int end, int length) {
        return end - length + 1;
    }

    public static int getEnd(int start, int length) {
        return start + length - 1;
    }

    public static boolean overlaps(int start, int end, int start2, int end2) {
        return start2 >= start && start2 <= end || end2 >= start && end2 <= end || CoordMath.encloses(start2, end2, start, end);
    }

    public static boolean encloses(int outerStart, int outerEnd, int innerStart, int innerEnd) {
        return innerStart >= outerStart && innerEnd <= outerEnd;
    }

    public static int getOverlap(int start, int end, int start2, int end2) {
        return CoordMath.getLength(Math.max(start, start2), Math.min(end, end2));
    }

    public static int getCycle(boolean isNegativeStrand, int readLength, int readBaseIndex) {
        return isNegativeStrand ? readLength - readBaseIndex : readBaseIndex + 1;
    }
}

