/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.Bin;
import net.sf.samtools.GATKChunk;

public class GATKBin
implements Comparable<GATKBin> {
    private final int referenceSequence;
    private final int binNumber;
    private GATKChunk[] chunkList;

    public GATKBin(Bin bin) {
        this(bin.getReferenceSequence(), bin.getBinNumber());
    }

    public GATKBin(int referenceSequence, int binNumber) {
        this.referenceSequence = referenceSequence;
        this.binNumber = binNumber;
    }

    public int getReferenceSequence() {
        return this.referenceSequence;
    }

    public int getBinNumber() {
        return this.binNumber;
    }

    public Bin toBin() {
        return new Bin(this.referenceSequence, this.binNumber);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof GATKBin)) {
            return false;
        }
        GATKBin otherBin = (GATKBin)other;
        return this.referenceSequence == otherBin.referenceSequence && this.binNumber == otherBin.binNumber;
    }

    public int hashCode() {
        return Integer.valueOf(this.referenceSequence).hashCode() ^ Integer.valueOf(this.binNumber).hashCode();
    }

    @Override
    public int compareTo(GATKBin other) {
        if (other == null) {
            throw new ClassCastException("Cannot compare to a null object");
        }
        if (this.referenceSequence != other.referenceSequence) {
            return this.referenceSequence - other.referenceSequence;
        }
        return this.binNumber - other.binNumber;
    }

    public void setChunkList(GATKChunk[] list) {
        this.chunkList = list;
    }

    public GATKChunk[] getChunkList() {
        if (this.chunkList == null) {
            return new GATKChunk[0];
        }
        return this.chunkList;
    }
}

