/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.Positional;

public class AsciiLineReader
implements LineReader,
Positional {
    private static final int BUFFER_OVERFLOW_INCREASE_FACTOR = 2;
    private static final byte LINEFEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    InputStream is;
    byte[] buffer;
    int nextChar;
    int nChars;
    char[] lineBuffer;
    long lineNumber = 0L;
    long position;

    public AsciiLineReader(InputStream is) {
        this(is, 512000);
    }

    public AsciiLineReader(InputStream is, int bufferSize) {
        this.is = is;
        this.buffer = new byte[bufferSize];
        this.nChars = 0;
        this.nextChar = 0;
        this.lineBuffer = new char[10000];
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    public void skip(long nBytes) throws IOException {
        this.is.skip(nBytes);
    }

    @Override
    public String readLine() throws IOException {
        int linePosition = 0;
        while (this.nChars != -1) {
            char c;
            if (this.nextChar == this.nChars) {
                this.fill();
                if (this.nextChar == this.nChars || this.nChars == -1) {
                    if (linePosition > 0) {
                        ++this.lineNumber;
                        this.position += (long)linePosition;
                        return new String(this.lineBuffer, 0, linePosition);
                    }
                    return null;
                }
            }
            if ((c = (char)(this.buffer[this.nextChar++] & 0xFF)) == '\n' || c == '\r') {
                this.position += (long)(linePosition + 1);
                if (c == '\r' && this.peek() == '\n') {
                    ++this.nextChar;
                    ++this.position;
                }
                ++this.lineNumber;
                return new String(this.lineBuffer, 0, linePosition);
            }
            if (linePosition > this.lineBuffer.length - 3) {
                char[] temp = new char[2 * this.lineBuffer.length];
                System.arraycopy(this.lineBuffer, 0, temp, 0, this.lineBuffer.length);
                this.lineBuffer = temp;
            }
            this.lineBuffer[linePosition++] = c;
        }
        return null;
    }

    private char peek() throws IOException {
        if (this.nextChar == this.nChars) {
            this.fill();
            if (this.nextChar == this.nChars) {
                return '\u0000';
            }
        }
        return (char)this.buffer[this.nextChar];
    }

    private void fill() throws IOException {
        this.nChars = this.is.read(this.buffer);
        this.nextChar = 0;
    }

    @Override
    public void close() {
        try {
            this.is.close();
            this.lineNumber = 0L;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public long getCurrentLineNumber() {
        return this.lineNumber;
    }

    public static void main(String[] args) throws Exception {
        File testFile = new File("test/data/HindForGISTIC.hg16.cn");
        for (int i = 0; i < 3; ++i) {
            BufferedReader reader2 = new BufferedReader(new FileReader(testFile));
            long t0 = System.currentTimeMillis();
            long lineCount = 0L;
            while (reader2.readLine() != null) {
                ++lineCount;
            }
            long dt = System.currentTimeMillis() - t0;
            double rate = (double)lineCount / (double)dt;
            System.out.println("BR: " + lineCount + " lines read.  Rate = " + rate + " lines per second.   DT = " + dt);
            reader2.close();
            AsciiLineReader reader = new AsciiLineReader(new FileInputStream(testFile));
            t0 = System.currentTimeMillis();
            lineCount = 0L;
            while (reader.readLine() != null) {
                ++lineCount;
            }
            dt = System.currentTimeMillis() - t0;
            rate = (double)lineCount / (double)dt;
            System.out.println("AR: " + lineCount + " lines read.  Rate = " + rate + " lines per second.     DT = " + dt);
            reader.close();
        }
    }
}

