/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads.utilities;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.GATKChunk;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class PrintBAMRegion
extends CommandLineProgram {
    @Argument(fullName="input", shortName="I", doc="Input file to process", required=true)
    private File input = null;
    @Argument(fullName="region", shortName="R", doc="BAM region to process, in chunk format (mmmm:nn-xxxx:yy)", required=true)
    private String region;
    private static final long MIN_BLOCK_SIZE = 0L;
    private static final long MAX_BLOCK_SIZE = (long)Math.pow(2.0, 48.0) - 1L;
    private static final int MIN_OFFSET_SIZE = 0;
    private static final int MAX_OFFSET_SIZE = (int)Math.pow(2.0, 16.0) - 1;

    @Override
    public int execute() {
        SAMFileReader reader = new SAMFileReader(this.input);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        Pattern regionPattern = Pattern.compile("(\\d+):(\\d+)-(\\d+):(\\d+)");
        Matcher matcher = regionPattern.matcher(this.region);
        if (!matcher.matches()) {
            throw new UserException("BAM region to process must be in chunk format (mmmm:nn-xxxx:yy)");
        }
        long firstBlock = Long.parseLong(matcher.group(1));
        int firstOffset = Integer.parseInt(matcher.group(2));
        long lastBlock = Long.parseLong(matcher.group(3));
        int lastOffset = Integer.parseInt(matcher.group(4));
        if (firstBlock < 0L || firstBlock > MAX_BLOCK_SIZE) {
            throw new UserException(String.format("First block is invalid; must be between %d and %d; actually is %d", 0L, MAX_BLOCK_SIZE, firstBlock));
        }
        if (lastBlock < 0L || lastBlock > MAX_BLOCK_SIZE) {
            throw new UserException(String.format("Last block is invalid; must be between %d and %d; actually is %d", 0L, MAX_BLOCK_SIZE, lastBlock));
        }
        if (firstOffset < 0 || firstOffset > MAX_OFFSET_SIZE) {
            throw new UserException(String.format("First offset is invalid; must be between %d and %d; actually is %d", 0, MAX_OFFSET_SIZE, firstOffset));
        }
        if (lastOffset < 0 || lastOffset > MAX_OFFSET_SIZE) {
            throw new UserException(String.format("Last offset is invalid; must be between %d and %d; actually is %d", 0, MAX_OFFSET_SIZE, lastOffset));
        }
        GATKChunk chunk = new GATKChunk(firstBlock << 16 | (long)firstOffset, lastBlock << 16 | (long)lastOffset);
        GATKBAMFileSpan fileSpan = new GATKBAMFileSpan(chunk);
        SAMRecordIterator iterator = reader.iterator(fileSpan);
        long readCount = 0L;
        while (iterator.hasNext()) {
            System.out.printf("%s%n", ((SAMRecord)iterator.next()).format());
            ++readCount;
        }
        System.out.printf("%d reads shown.", readCount);
        iterator.close();
        reader.close();
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        try {
            PrintBAMRegion instance = new PrintBAMRegion();
            PrintBAMRegion.start(instance, argv);
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }
}

