/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class AlleleBalance
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        if (!vc.isBiallelic()) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (!vc.hasGenotypes()) {
            return null;
        }
        double ratio = 0.0;
        double totalWeights = 0.0;
        for (Genotype genotype : genotypes) {
            int altCount;
            ReadBackedExtendedEventPileup indelPileup;
            AlignmentContext context;
            if (!genotype.isHet() || (context = stratifiedContexts.get(genotype.getSampleName())) == null) continue;
            if (vc.isSNP() && context.hasBasePileup()) {
                int altCount2;
                String bases = new String(context.getBasePileup().getBases());
                if (bases.length() == 0) {
                    return null;
                }
                char refChr = vc.getReference().toString().charAt(0);
                char altChr = vc.getAlternateAllele(0).toString().charAt(0);
                int refCount = MathUtils.countOccurrences(refChr, bases);
                if (refCount + (altCount2 = MathUtils.countOccurrences(altChr, bases)) == 0) continue;
                ratio += genotype.getLog10PError() * ((double)refCount / (double)(refCount + altCount2));
                totalWeights += genotype.getLog10PError();
                continue;
            }
            if (!vc.isIndel() || !context.hasExtendedEventPileup() || (indelPileup = context.getExtendedEventPileup()) == null) continue;
            int refCount = indelPileup.getNumberOfElements();
            int n = altCount = vc.isSimpleInsertion() ? indelPileup.getNumberOfInsertions() : indelPileup.getNumberOfDeletions();
            if (refCount + altCount == 0) continue;
            ratio += 1.0 * (double)refCount / (double)(refCount + altCount);
            totalWeights += 1.0;
        }
        if (MathUtils.compareDoubles(totalWeights, 0.0) == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.3f", ratio / totalWeights));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("AB");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("AB", 1, VCFHeaderLineType.Float, "Allele Balance for hets (ref/(ref+alt))"));
    }
}

