/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.Arrays;
import java.util.BitSet;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.StandardCovariate;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ContextCovariate
implements StandardCovariate {
    private int mismatchesContextSize;
    private int insertionsContextSize;
    private int deletionsContextSize;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.mismatchesContextSize = RAC.MISMATCHES_CONTEXT_SIZE;
        this.insertionsContextSize = RAC.INSERTIONS_CONTEXT_SIZE;
        this.deletionsContextSize = RAC.DELETIONS_CONTEXT_SIZE;
        if (this.mismatchesContextSize <= 0 || this.insertionsContextSize <= 0 || this.deletionsContextSize <= 0) {
            throw new UserException(String.format("Context Size must be positive, if you don't want to use the context covariate, just turn it off instead. Mismatches: %d Insertions: %d Deletions:%d", this.mismatchesContextSize, this.insertionsContextSize, this.deletionsContextSize));
        }
    }

    @Override
    public CovariateValues getValues(GATKSAMRecord read) {
        int l = read.getReadLength();
        Object[] mismatches = new BitSet[l];
        Object[] insertions = new BitSet[l];
        Object[] deletions = new BitSet[l];
        boolean negativeStrand = read.getReadNegativeStrandFlag();
        byte[] bases = read.getReadBases();
        if (negativeStrand) {
            bases = BaseUtils.simpleReverseComplement(bases);
        }
        for (int i = 0; i < read.getReadLength(); ++i) {
            mismatches[i] = this.contextWith(bases, i, this.mismatchesContextSize);
            insertions[i] = this.contextWith(bases, i, this.insertionsContextSize);
            deletions[i] = this.contextWith(bases, i, this.deletionsContextSize);
        }
        if (negativeStrand) {
            ContextCovariate.reverse(mismatches);
            ContextCovariate.reverse(insertions);
            ContextCovariate.reverse(deletions);
        }
        return new CovariateValues(mismatches, insertions, deletions);
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    private BitSet contextWith(byte[] bases, int offset, int contextSize) {
        if (offset < contextSize) {
            return null;
        }
        String context = new String(Arrays.copyOfRange(bases, offset - contextSize, offset));
        if (context.contains("N")) {
            return null;
        }
        return MathUtils.bitSetFrom(context);
    }

    private static void reverse(Object[] array) {
        int arrayLength = array.length;
        int l = 0;
        for (int r = arrayLength - 1; l < r; ++l, --r) {
            Object temp = array[l];
            array[l] = array[r];
            array[r] = temp;
        }
    }
}

