/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.coverage;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.SeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrack;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.refdata.utils.LocationAwareSeekableRODIterator;
import org.broadinstitute.sting.gatk.refdata.utils.RODRecordList;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Downsample;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.Multiplex;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.coverage.CoveragePartitioner;
import org.broadinstitute.sting.gatk.walkers.coverage.CoverageUtils;
import org.broadinstitute.sting.gatk.walkers.coverage.DepthOfCoverageStats;
import org.broadinstitute.sting.gatk.walkers.coverage.DoCOutputMultiplexer;
import org.broadinstitute.sting.gatk.walkers.coverage.DoCOutputType;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.refseq.RefSeqCodec;
import org.broadinstitute.sting.utils.codecs.refseq.RefSeqFeature;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

@By(value=DataSource.REFERENCE)
@PartitionBy(value=PartitionType.NONE)
@Downsample(by=DownsampleType.NONE, toCoverage=0x7FFFFFFF)
public class DepthOfCoverageWalker
extends LocusWalker<Map<DoCOutputType.Partition, Map<String, int[]>>, CoveragePartitioner>
implements TreeReducible<CoveragePartitioner> {
    @Output
    @Multiplex(value=DoCOutputMultiplexer.class, arguments={"partitionTypes", "refSeqGeneList", "omitDepthOutput", "omitIntervals", "omitSampleSummary", "omitLocusTable"})
    Map<DoCOutputType, PrintStream> out;
    @Argument(fullName="minMappingQuality", shortName="mmq", doc="Minimum mapping quality of reads to count towards depth. Defaults to -1.", required=false)
    int minMappingQuality = -1;
    @Argument(fullName="maxMappingQuality", doc="Maximum mapping quality of reads to count towards depth. Defaults to 2^31-1 (Integer.MAX_VALUE).", required=false)
    int maxMappingQuality = Integer.MAX_VALUE;
    @Argument(fullName="minBaseQuality", shortName="mbq", doc="Minimum quality of bases to count towards depth. Defaults to -1.", required=false)
    byte minBaseQuality = (byte)-1;
    @Argument(fullName="maxBaseQuality", doc="Maximum quality of bases to count towards depth. Defaults to 127 (Byte.MAX_VALUE).", required=false)
    byte maxBaseQuality = (byte)127;
    @Argument(fullName="printBaseCounts", shortName="baseCounts", doc="Will add base counts to per-locus output.", required=false)
    boolean printBaseCounts = false;
    @Argument(fullName="omitLocusTable", shortName="omitLocusTable", doc="Will not calculate the per-sample per-depth counts of loci, which should result in speedup", required=false)
    boolean omitLocusTable = false;
    @Argument(fullName="omitIntervalStatistics", shortName="omitIntervals", doc="Will omit the per-interval statistics section, which should result in speedup", required=false)
    boolean omitIntervals = false;
    @Argument(fullName="omitDepthOutputAtEachBase", shortName="omitBaseOutput", doc="Will omit the output of the depth of coverage at each base, which should result in speedup", required=false)
    boolean omitDepthOutput = false;
    @Argument(fullName="calculateCoverageOverGenes", shortName="geneList", doc="Calculate the coverage statistics over this list of genes. Currently accepts RefSeq.", required=false)
    File refSeqGeneList = null;
    @Argument(fullName="outputFormat", doc="the format of the output file (e.g. csv, table, rtable); defaults to r-readable table", required=false)
    String outputFormat = "rtable";
    @Advanced
    @Argument(fullName="includeRefNSites", doc="If provided, sites with reference N bases but with coverage from neighboring reads will be included in DoC calculations.", required=false)
    boolean includeRefNBases = false;
    @Advanced
    @Argument(fullName="printBinEndpointsAndExit", doc="Prints the bin values and exits immediately. Use to calibrate what bins you want before running on data.", required=false)
    boolean printBinEndpointsAndExit = false;
    @Advanced
    @Argument(fullName="start", doc="Starting (left endpoint) for granular binning", required=false)
    int start = 1;
    @Advanced
    @Argument(fullName="stop", doc="Ending (right endpoint) for granular binning", required=false)
    int stop = 500;
    @Advanced
    @Argument(fullName="nBins", doc="Number of bins to use for granular binning", required=false)
    int nBins = 499;
    @Argument(fullName="omitPerSampleStats", shortName="omitSampleSummary", doc="Omits the summary files per-sample. These statistics are still calculated, so this argument will not improve runtime.", required=false)
    boolean omitSampleSummary = false;
    @Argument(fullName="partitionType", shortName="pt", doc="Partition type for depth of coverage. Defaults to sample. Can be any combination of sample, readgroup, library.", required=false)
    Set<DoCOutputType.Partition> partitionTypes = EnumSet.of(DoCOutputType.Partition.sample);
    @Advanced
    @Argument(fullName="includeDeletions", shortName="dels", doc="Include information on deletions", required=false)
    boolean includeDeletions = false;
    @Advanced
    @Argument(fullName="ignoreDeletionSites", doc="Ignore sites consisting only of deletions", required=false)
    boolean ignoreDeletionSites = false;
    @Advanced
    @Argument(fullName="summaryCoverageThreshold", shortName="ct", doc="for summary file outputs, report the % of bases coverd to >= this number. Defaults to 15; can take multiple arguments.", required=false)
    int[] coverageThresholds = new int[]{15};
    String[] OUTPUT_FORMATS = new String[]{"table", "rtable", "csv"};
    String separator = "\t";
    Map<DoCOutputType.Partition, List<String>> orderCheck = new HashMap<DoCOutputType.Partition, List<String>>();

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return this.includeDeletions && !this.ignoreDeletionSites;
    }

    @Override
    public void initialize() {
        if (this.printBinEndpointsAndExit) {
            int[] endpoints = DepthOfCoverageStats.calculateBinEndpoints(this.start, this.stop, this.nBins);
            System.out.print("[ ");
            for (int e : endpoints) {
                System.out.print(e + " ");
            }
            System.out.println("]");
            System.exit(0);
        }
        boolean goodOutputFormat = false;
        for (String f : this.OUTPUT_FORMATS) {
            goodOutputFormat = goodOutputFormat || f.equals(this.outputFormat);
        }
        if (!goodOutputFormat) {
            throw new IllegalArgumentException("Improper output format. Can be one of table,rtable,csv. Was " + this.outputFormat);
        }
        if (this.outputFormat.equals("csv")) {
            this.separator = ",";
        }
        if (!this.omitDepthOutput) {
            PrintStream printStream = this.getCorrectStream(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary);
            printStream.printf("%s\t%s", "Locus", "Total_Depth");
            for (DoCOutputType.Partition type : this.partitionTypes) {
                printStream.printf("\t%s_%s", "Average_Depth", type.toString());
            }
            HashSet<String> allSamples = this.getSamplesFromToolKit(this.partitionTypes);
            ArrayList<String> allSampleList = new ArrayList<String>(allSamples.size());
            for (String s : allSamples) {
                allSampleList.add(s);
            }
            Collections.sort(allSampleList);
            for (String s : allSampleList) {
                printStream.printf("\t%s_%s", "Depth_for", s);
                if (!this.printBaseCounts) continue;
                printStream.printf("\t%s_%s", s, "base_counts");
            }
            printStream.printf("%n", new Object[0]);
        } else {
            logger.info("Per-Locus Depth of Coverage output was omitted");
        }
        for (DoCOutputType.Partition type : this.partitionTypes) {
            this.orderCheck.put(type, new ArrayList());
            for (String id : this.getSamplesFromToolKit(type)) {
                this.orderCheck.get((Object)type).add(id);
            }
            Collections.sort(this.orderCheck.get((Object)type));
        }
    }

    private HashSet<String> getSamplesFromToolKit(Collection<DoCOutputType.Partition> types) {
        HashSet<String> partitions = new HashSet<String>();
        for (DoCOutputType.Partition t : types) {
            partitions.addAll(this.getSamplesFromToolKit(t));
        }
        return partitions;
    }

    private HashSet<String> getSamplesFromToolKit(DoCOutputType.Partition type) {
        HashSet<String> partition = new HashSet<String>();
        if (type == DoCOutputType.Partition.sample) {
            partition.addAll(SampleUtils.getSAMFileSamples(this.getToolkit()));
        } else if (type == DoCOutputType.Partition.readgroup) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(rg.getSample() + "_rg_" + rg.getReadGroupId());
            }
        } else if (type == DoCOutputType.Partition.library) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(rg.getLibrary());
            }
        } else if (type == DoCOutputType.Partition.center) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(rg.getSequencingCenter());
            }
        } else if (type == DoCOutputType.Partition.platform) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(rg.getPlatform());
            }
        } else if (type == DoCOutputType.Partition.sample_by_center) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(String.format("%s_cn_%s", rg.getSample(), rg.getSequencingCenter()));
            }
        } else if (type == DoCOutputType.Partition.sample_by_platform) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(String.format("%s_pl_%s", rg.getSample(), rg.getPlatform()));
            }
        } else if (type == DoCOutputType.Partition.sample_by_platform_by_center) {
            for (SAMReadGroupRecord rg : this.getToolkit().getSAMFileHeader().getReadGroups()) {
                partition.add(String.format("%s_pl_%s_cn_%s", rg.getSample(), rg.getPlatform(), rg.getSequencingCenter()));
            }
        } else {
            throw new ReviewedStingException("Invalid aggregation type sent to getSamplesFromToolKit");
        }
        return partition;
    }

    @Override
    public boolean isReduceByInterval() {
        return !this.omitIntervals;
    }

    @Override
    public CoveragePartitioner reduceInit() {
        CoveragePartitioner aggro = new CoveragePartitioner(this.partitionTypes, this.start, this.stop, this.nBins);
        for (DoCOutputType.Partition t : this.partitionTypes) {
            aggro.addIdentifiers(t, this.getSamplesFromToolKit(t));
        }
        aggro.initialize(this.includeDeletions, this.omitLocusTable);
        this.checkOrder(aggro);
        return aggro;
    }

    @Override
    public Map<DoCOutputType.Partition, Map<String, int[]>> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (this.includeRefNBases || BaseUtils.isRegularBase(ref.getBase())) {
            if (!this.omitDepthOutput) {
                this.getCorrectStream(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary).printf("%s", ref.getLocus());
            }
            return CoverageUtils.getBaseCountsByPartition(context, this.minMappingQuality, this.maxMappingQuality, this.minBaseQuality, this.maxBaseQuality, this.partitionTypes);
        }
        return null;
    }

    @Override
    public CoveragePartitioner reduce(Map<DoCOutputType.Partition, Map<String, int[]>> thisMap, CoveragePartitioner prevReduce) {
        if (thisMap != null) {
            if (!this.omitDepthOutput) {
                this.printDepths(this.getCorrectStream(null, DoCOutputType.Aggregation.locus, DoCOutputType.FileType.summary), thisMap, prevReduce.getIdentifiersByType());
            }
            prevReduce.update(thisMap);
        }
        return prevReduce;
    }

    @Override
    public CoveragePartitioner treeReduce(CoveragePartitioner left, CoveragePartitioner right) {
        left.merge(right);
        return left;
    }

    @Override
    public void onTraversalDone(List<Pair<GenomeLoc, CoveragePartitioner>> statsByInterval) {
        if (this.refSeqGeneList != null && this.partitionTypes.contains((Object)DoCOutputType.Partition.sample)) {
            this.printGeneStats(statsByInterval);
        }
        for (DoCOutputType.Partition partition : this.partitionTypes) {
            if (this.checkType(statsByInterval.get(0).getSecond().getCoverageByAggregationType(partition), partition)) {
                this.printIntervalStats(statsByInterval, this.getCorrectStream(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.summary), this.getCorrectStream(partition, DoCOutputType.Aggregation.interval, DoCOutputType.FileType.statistics), partition);
                continue;
            }
            throw new ReviewedStingException("Partition type " + partition.toString() + " had no entries. Please check that your .bam header has all appropriate partition types.");
        }
        this.onTraversalDone(this.mergeAll(statsByInterval));
    }

    public CoveragePartitioner mergeAll(List<Pair<GenomeLoc, CoveragePartitioner>> stats) {
        CoveragePartitioner first = (CoveragePartitioner)stats.remove((int)0).second;
        for (Pair<GenomeLoc, CoveragePartitioner> iStat : stats) {
            this.treeReduce(first, (CoveragePartitioner)iStat.second);
        }
        return first;
    }

    private DepthOfCoverageStats printIntervalStats(List<Pair<GenomeLoc, CoveragePartitioner>> statsByInterval, PrintStream summaryOut, PrintStream statsOut, DoCOutputType.Partition type) {
        Pair<GenomeLoc, CoveragePartitioner> firstPair = statsByInterval.get(0);
        CoveragePartitioner firstAggregator = (CoveragePartitioner)firstPair.second;
        DepthOfCoverageStats firstStats = firstAggregator.getCoverageByAggregationType(type);
        StringBuilder summaryHeader = new StringBuilder();
        summaryHeader.append("Target");
        summaryHeader.append(this.separator);
        summaryHeader.append("total_coverage");
        summaryHeader.append(this.separator);
        summaryHeader.append("average_coverage");
        for (String s : firstStats.getAllSamples()) {
            summaryHeader.append(this.separator);
            summaryHeader.append(s);
            summaryHeader.append("_total_cvg");
            summaryHeader.append(this.separator);
            summaryHeader.append(s);
            summaryHeader.append("_mean_cvg");
            summaryHeader.append(this.separator);
            summaryHeader.append(s);
            summaryHeader.append("_granular_Q1");
            summaryHeader.append(this.separator);
            summaryHeader.append(s);
            summaryHeader.append("_granular_median");
            summaryHeader.append(this.separator);
            summaryHeader.append(s);
            summaryHeader.append("_granular_Q3");
            for (int thresh : this.coverageThresholds) {
                summaryHeader.append(this.separator);
                summaryHeader.append(s);
                summaryHeader.append("_%_above_");
                summaryHeader.append(thresh);
            }
        }
        summaryOut.printf("%s%n", summaryHeader);
        int[][] nTargetsByAvgCvgBySample = new int[firstStats.getHistograms().size()][firstStats.getEndpoints().length + 1];
        for (Pair<GenomeLoc, CoveragePartitioner> targetAggregator : statsByInterval) {
            Pair targetStats = new Pair(targetAggregator.first, ((CoveragePartitioner)targetAggregator.second).getCoverageByAggregationType(type));
            this.printTargetSummary(summaryOut, targetStats);
            this.updateTargetTable(nTargetsByAvgCvgBySample, (DepthOfCoverageStats)targetStats.second);
        }
        this.printIntervalTable(statsOut, nTargetsByAvgCvgBySample, firstStats.getEndpoints());
        return firstStats;
    }

    private void printGeneStats(List<Pair<GenomeLoc, CoveragePartitioner>> statsByTarget) {
        logger.debug("statsByTarget size is " + Integer.toString(statsByTarget.size()));
        logger.debug("Initializing refseq...");
        LocationAwareSeekableRODIterator refseqIterator = this.initializeRefSeq();
        logger.debug("Refseq init done.");
        ArrayList<Pair<String, DepthOfCoverageStats>> statsByGene = new ArrayList<Pair<String, DepthOfCoverageStats>>();
        HashMap<String, DepthOfCoverageStats> geneNamesToStats = new HashMap<String, DepthOfCoverageStats>();
        for (Pair<GenomeLoc, CoveragePartitioner> targetStats : statsByTarget) {
            String string = this.getGeneName((GenomeLoc)targetStats.first, refseqIterator);
            if (geneNamesToStats.keySet().contains(string)) {
                logger.debug("Merging " + ((DepthOfCoverageStats)geneNamesToStats.get(string)).toString() + " and " + ((CoveragePartitioner)targetStats.second).getCoverageByAggregationType(DoCOutputType.Partition.sample).toString());
                ((DepthOfCoverageStats)geneNamesToStats.get(string)).merge(((CoveragePartitioner)targetStats.second).getCoverageByAggregationType(DoCOutputType.Partition.sample));
                continue;
            }
            DepthOfCoverageStats merger = new DepthOfCoverageStats(((CoveragePartitioner)targetStats.second).getCoverageByAggregationType(DoCOutputType.Partition.sample));
            geneNamesToStats.put(string, merger);
            statsByGene.add(new Pair<String, DepthOfCoverageStats>(string, merger));
        }
        PrintStream geneSummaryOut = this.getCorrectStream(DoCOutputType.Partition.sample, DoCOutputType.Aggregation.gene, DoCOutputType.FileType.summary);
        for (Pair pair : statsByGene) {
            this.printTargetSummary(geneSummaryOut, pair);
        }
    }

    private String getGeneName(GenomeLoc target, LocationAwareSeekableRODIterator refseqIterator) {
        logger.debug("Examining " + target.toString());
        if (refseqIterator == null) {
            return "UNKNOWN";
        }
        RODRecordList annotationList = refseqIterator.seekForward(target);
        logger.debug("Annotation list is " + (annotationList == null ? "null" : annotationList.getName()));
        if (annotationList == null) {
            return "UNKNOWN";
        }
        for (GATKFeature rec : annotationList) {
            if (((RefSeqFeature)rec.getUnderlyingObject()).overlapsExonP(target)) {
                logger.debug("We do overlap " + rec.getUnderlyingObject().toString());
                return ((RefSeqFeature)rec.getUnderlyingObject()).getGeneName();
            }
            logger.debug("No overlap");
        }
        return "UNKNOWN";
    }

    private LocationAwareSeekableRODIterator initializeRefSeq() {
        RMDTrackBuilder builder = new RMDTrackBuilder(this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary(), this.getToolkit().getGenomeLocParser(), this.getToolkit().getArguments().unsafe);
        RMDTrack refseq = builder.createInstanceOfTrack(RefSeqCodec.class, this.refSeqGeneList);
        return new SeekableRODIterator(refseq.getHeader(), refseq.getSequenceDictionary(), this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary(), this.getToolkit().getGenomeLocParser(), refseq.getIterator());
    }

    private void printTargetSummary(PrintStream output, Pair<?, DepthOfCoverageStats> intervalStats) {
        DepthOfCoverageStats stats = (DepthOfCoverageStats)intervalStats.second;
        int[] bins = stats.getEndpoints();
        StringBuilder targetSummary = new StringBuilder();
        targetSummary.append(intervalStats.first.toString());
        targetSummary.append(this.separator);
        targetSummary.append(stats.getTotalCoverage());
        targetSummary.append(this.separator);
        targetSummary.append(String.format("%.2f", stats.getTotalMeanCoverage()));
        for (String s : stats.getAllSamples()) {
            targetSummary.append(this.separator);
            targetSummary.append(stats.getTotals().get(s));
            targetSummary.append(this.separator);
            targetSummary.append(String.format("%.2f", stats.getMeans().get(s)));
            targetSummary.append(this.separator);
            int median = this.getQuantile(stats.getHistograms().get(s), 0.5);
            int q1 = this.getQuantile(stats.getHistograms().get(s), 0.25);
            int q3 = this.getQuantile(stats.getHistograms().get(s), 0.75);
            targetSummary.append(this.formatBin(bins, q1));
            targetSummary.append(this.separator);
            targetSummary.append(this.formatBin(bins, median));
            targetSummary.append(this.separator);
            targetSummary.append(this.formatBin(bins, q3));
            for (int thresh : this.coverageThresholds) {
                targetSummary.append(String.format("%s%.1f", this.separator, this.getPctBasesAbove(stats.getHistograms().get(s), stats.value2bin(thresh))));
            }
        }
        output.printf("%s%n", targetSummary);
    }

    private String formatBin(int[] bins, int quartile) {
        if (quartile >= bins.length) {
            return String.format(">%d", bins[bins.length - 1]);
        }
        if (quartile < 0) {
            return String.format("<%d", bins[0]);
        }
        return String.format("%d", bins[quartile]);
    }

    private void printIntervalTable(PrintStream output, int[][] intervalTable, int[] cutoffs) {
        String colHeader = this.outputFormat.equals("rtable") ? "" : "Number_of_sources";
        output.printf(colHeader + this.separator + "depth>=%d", 0);
        for (int col = 0; col < intervalTable[0].length - 1; ++col) {
            output.printf(this.separator + "depth>=%d", cutoffs[col]);
        }
        output.printf(String.format("%n", new Object[0]), new Object[0]);
        for (int row = 0; row < intervalTable.length; ++row) {
            output.printf("At_least_%d_samples", row + 1);
            for (int col = 0; col < intervalTable[0].length; ++col) {
                output.printf(this.separator + "%d", intervalTable[row][col]);
            }
            output.printf(String.format("%n", new Object[0]), new Object[0]);
        }
    }

    private void updateTargetTable(int[][] table, DepthOfCoverageStats stats) {
        int[] cutoffs = stats.getEndpoints();
        int[] countsOfMediansAboveCutoffs = new int[cutoffs.length + 1];
        for (int i = 0; i < countsOfMediansAboveCutoffs.length; ++i) {
            countsOfMediansAboveCutoffs[i] = 0;
        }
        for (String s : stats.getAllSamples()) {
            int medianBin = this.getQuantile(stats.getHistograms().get(s), 0.5);
            int i = 0;
            while (i <= medianBin) {
                int n = i++;
                countsOfMediansAboveCutoffs[n] = countsOfMediansAboveCutoffs[n] + 1;
            }
        }
        for (int medianBin = 0; medianBin < countsOfMediansAboveCutoffs.length; ++medianBin) {
            while (countsOfMediansAboveCutoffs[medianBin] > 0) {
                int[] nArray = table[countsOfMediansAboveCutoffs[medianBin] - 1];
                int n = medianBin;
                nArray[n] = nArray[n] + 1;
                int n2 = medianBin;
                countsOfMediansAboveCutoffs[n2] = countsOfMediansAboveCutoffs[n2] - 1;
            }
        }
    }

    @Override
    public void onTraversalDone(CoveragePartitioner coverageProfiles) {
        if (!this.omitSampleSummary) {
            logger.info("Printing summary info");
            for (DoCOutputType.Partition type : this.partitionTypes) {
                this.outputSummaryFiles(coverageProfiles, type);
            }
        }
        if (!this.omitLocusTable) {
            logger.info("Printing locus summary");
            for (DoCOutputType.Partition type : this.partitionTypes) {
                this.outputLocusFiles(coverageProfiles, type);
            }
        }
    }

    private void outputLocusFiles(CoveragePartitioner coverageProfiles, DoCOutputType.Partition type) {
        this.printPerLocus(this.getCorrectStream(type, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_counts), this.getCorrectStream(type, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.coverage_proportions), coverageProfiles.getCoverageByAggregationType(type), type);
    }

    private void outputSummaryFiles(CoveragePartitioner coverageProfiles, DoCOutputType.Partition type) {
        this.printPerSample(this.getCorrectStream(type, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.statistics), coverageProfiles.getCoverageByAggregationType(type));
        this.printSummary(this.getCorrectStream(type, DoCOutputType.Aggregation.cumulative, DoCOutputType.FileType.summary), coverageProfiles.getCoverageByAggregationType(type));
    }

    private void printPerSample(PrintStream output, DepthOfCoverageStats stats) {
        int[] leftEnds = stats.getEndpoints();
        StringBuilder hBuilder = new StringBuilder();
        if (!this.outputFormat.equals("rTable")) {
            hBuilder.append("Source_of_reads");
        }
        hBuilder.append(this.separator);
        hBuilder.append(String.format("from_0_to_%d)%s", leftEnds[0], this.separator));
        for (int i = 1; i < leftEnds.length; ++i) {
            hBuilder.append(String.format("from_%d_to_%d)%s", leftEnds[i - 1], leftEnds[i], this.separator));
        }
        hBuilder.append(String.format("from_%d_to_inf%n", leftEnds[leftEnds.length - 1]));
        output.print(hBuilder.toString());
        Map<String, long[]> histograms = stats.getHistograms();
        for (Map.Entry<String, long[]> p : histograms.entrySet()) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(String.format("sample_%s", p.getKey()));
            for (long count : p.getValue()) {
                sBuilder.append(String.format("%s%d", this.separator, count));
            }
            sBuilder.append(String.format("%n", new Object[0]));
            output.print(sBuilder.toString());
        }
    }

    private void printPerLocus(PrintStream output, PrintStream coverageOut, DepthOfCoverageStats stats, DoCOutputType.Partition partitionType) {
        int[] endpoints = stats.getEndpoints();
        int samples = stats.getHistograms().size();
        long[][] baseCoverageCumDist = stats.getLocusCounts();
        boolean printSampleColumnHeader = this.outputFormat.equals("csv") || this.outputFormat.equals("table");
        StringBuilder header = new StringBuilder();
        if (printSampleColumnHeader) {
            header.append(partitionType == DoCOutputType.Partition.readgroup ? "read_group" : partitionType.toString());
        }
        header.append(String.format("%sgte_0", this.separator));
        for (int d : endpoints) {
            header.append(String.format("%sgte_%d", this.separator, d));
        }
        header.append(String.format("%n", new Object[0]));
        output.print(header);
        coverageOut.print(header);
        for (int row = 0; row < samples; ++row) {
            output.printf("%s_%d", "NSamples", row + 1);
            for (int depthBin = 0; depthBin < baseCoverageCumDist[0].length; ++depthBin) {
                output.printf("%s%d", this.separator, baseCoverageCumDist[row][depthBin]);
            }
            output.printf("%n", new Object[0]);
        }
        for (String sample : stats.getAllSamples()) {
            coverageOut.printf("%s", sample);
            double[] coverageDistribution = stats.getCoverageProportions(sample);
            for (int bin = 0; bin < coverageDistribution.length; ++bin) {
                coverageOut.printf("%s%.2f", this.separator, coverageDistribution[bin]);
            }
            coverageOut.printf("%n", new Object[0]);
        }
    }

    private PrintStream getCorrectStream(DoCOutputType.Partition partition, DoCOutputType.Aggregation aggregation, DoCOutputType.FileType fileType) {
        DoCOutputType outputType = new DoCOutputType(partition, aggregation, fileType);
        if (!this.out.containsKey(outputType)) {
            throw new UserException.CommandLineException(String.format("Unable to find appropriate stream for partition = %s, aggregation = %s, file type = %s", new Object[]{partition, aggregation, fileType}));
        }
        return this.out.get(outputType);
    }

    private void printSummary(PrintStream output, DepthOfCoverageStats stats) {
        if (!this.outputFormat.equals("csv")) {
            output.printf("%s\t%s\t%s\t%s\t%s\t%s", "sample_id", "total", "mean", "granular_third_quartile", "granular_median", "granular_first_quartile");
        } else {
            output.printf("%s,%s,%s,%s,%s,%s", "sample_id", "total", "mean", "granular_third_quartile", "granular_median", "granular_first_quartile");
        }
        for (int thresh : this.coverageThresholds) {
            output.printf("%s%s%d", this.separator, "%_bases_above_", thresh);
        }
        output.printf("%n", new Object[0]);
        Map<String, long[]> histograms = stats.getHistograms();
        Map<String, Double> means = stats.getMeans();
        Map<String, Long> totals = stats.getTotals();
        int[] leftEnds = stats.getEndpoints();
        for (Map.Entry<String, long[]> p : histograms.entrySet()) {
            String s = p.getKey();
            long[] histogram = p.getValue();
            int median = this.getQuantile(histogram, 0.5);
            int q1 = this.getQuantile(histogram, 0.25);
            int q3 = this.getQuantile(histogram, 0.75);
            median = median == histogram.length - 1 ? histogram.length - 2 : median;
            q1 = q1 == histogram.length - 1 ? histogram.length - 2 : q1;
            int n = q3 = q3 == histogram.length - 1 ? histogram.length - 2 : q3;
            if (!this.outputFormat.equals("csv")) {
                output.printf("%s\t%d\t%.2f\t%d\t%d\t%d", s, totals.get(s), means.get(s), leftEnds[q3], leftEnds[median], leftEnds[q1]);
            } else {
                output.printf("%s,%d,%.2f,%d,%d,%d", s, totals.get(s), means.get(s), leftEnds[q3], leftEnds[median], leftEnds[q1]);
            }
            for (int thresh : this.coverageThresholds) {
                output.printf("%s%.1f", this.separator, this.getPctBasesAbove(histogram, stats.value2bin(thresh)));
            }
            output.printf("%n", new Object[0]);
        }
        if (!this.outputFormat.equals("csv")) {
            output.printf("%s\t%d\t%.2f\t%s\t%s\t%s%n", "Total", stats.getTotalCoverage(), stats.getTotalMeanCoverage(), "N/A", "N/A", "N/A");
        } else {
            output.printf("%s,%d,%.2f,%s,%s,%s%n", "Total", stats.getTotalCoverage(), stats.getTotalMeanCoverage(), "N/A", "N/A", "N/A");
        }
    }

    private int getQuantile(long[] histogram, double prop) {
        int total = 0;
        for (int i = 0; i < histogram.length; ++i) {
            total = (int)((long)total + histogram[i]);
        }
        int counts = 0;
        int bin = -1;
        while ((double)counts < prop * (double)total) {
            counts = (int)((long)counts + histogram[bin + 1]);
            ++bin;
        }
        return bin == -1 ? 0 : bin;
    }

    private double getPctBasesAbove(long[] histogram, int bin) {
        long below = 0L;
        long above = 0L;
        for (int index = 0; index < histogram.length; ++index) {
            if (index < bin) {
                below += histogram[index];
                continue;
            }
            above += histogram[index];
        }
        return 100.0 * (double)above / (double)(above + below);
    }

    private void printDepths(PrintStream stream, Map<DoCOutputType.Partition, Map<String, int[]>> countsBySampleByType, Map<DoCOutputType.Partition, List<String>> identifiersByType) {
        StringBuilder perSampleOutput = new StringBuilder();
        int tDepth = 0;
        boolean depthCounted = false;
        for (DoCOutputType.Partition type : this.partitionTypes) {
            Map<String, int[]> countsByID = countsBySampleByType.get((Object)type);
            for (String s : identifiersByType.get((Object)type)) {
                perSampleOutput.append(this.separator);
                long dp = countsByID != null && countsByID.keySet().contains(s) ? this.sumArray(countsByID.get(s)) : 0L;
                perSampleOutput.append(dp);
                if (this.printBaseCounts) {
                    perSampleOutput.append(this.separator);
                    perSampleOutput.append(this.baseCounts(countsByID != null ? countsByID.get(s) : null));
                }
                if (depthCounted) continue;
                tDepth = (int)((long)tDepth + dp);
            }
            depthCounted = true;
        }
        stream.printf("%s%d", this.separator, tDepth);
        for (DoCOutputType.Partition type : this.partitionTypes) {
            stream.printf("%s%.2f", this.separator, (double)tDepth / (double)identifiersByType.get((Object)type).size());
        }
        stream.printf("%s%n", perSampleOutput);
    }

    private long sumArray(int[] array) {
        long i = 0L;
        for (int j : array) {
            i += (long)j;
        }
        return i;
    }

    private String baseCounts(int[] counts) {
        if (counts == null) {
            counts = new int[6];
        }
        StringBuilder s = new StringBuilder();
        int nbases = 0;
        for (byte b : BaseUtils.EXTENDED_BASES) {
            ++nbases;
            if (!this.includeDeletions && b == 68) continue;
            s.append((char)b);
            s.append(":");
            s.append(counts[BaseUtils.extendedBaseToBaseIndex(b)]);
            if (nbases >= 6) continue;
            s.append(" ");
        }
        return s.toString();
    }

    private void checkOrder(CoveragePartitioner ag) {
        for (DoCOutputType.Partition t : this.partitionTypes) {
            List<String> order = this.orderCheck.get((Object)t);
            List<String> namesInAg = ag.getIdentifiersByType().get((Object)t);
            Set<String> namesInDOCS = ag.getCoverageByAggregationType(t).getAllSamples();
            int index = 0;
            for (String s : namesInAg) {
                if (!s.equalsIgnoreCase(order.get(index))) {
                    throw new ReviewedStingException("IDs are out of order for type " + (Object)((Object)t) + "! Aggregator has different ordering");
                }
                ++index;
            }
        }
    }

    public boolean checkType(DepthOfCoverageStats stats, DoCOutputType.Partition type) {
        if (stats.getHistograms().size() < 1) {
            logger.warn("The histogram per partition type " + type.toString() + " was empty\n" + "Do your read groups have this type? (Check your .bam header).");
            return false;
        }
        return true;
    }
}

