/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidIndelGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.pileup.ExtendedEventPileupElement;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedExtendedEventPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class IndelGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    private final int HAPLOTYPE_SIZE;
    private final int minIndelCountForGenotyping;
    private final boolean getAlleleListFromVCF;
    private boolean DEBUG = false;
    private final boolean doMultiAllelicCalls = true;
    private boolean ignoreSNPAllelesWhenGenotypingIndels = false;
    private PairHMMIndelErrorModel pairModel;
    private static ThreadLocal<HashMap<PileupElement, LinkedHashMap<Allele, Double>>> indelLikelihoodMap = new ThreadLocal<HashMap<PileupElement, LinkedHashMap<Allele, Double>>>(){

        @Override
        protected synchronized HashMap<PileupElement, LinkedHashMap<Allele, Double>> initialValue() {
            return new HashMap<PileupElement, LinkedHashMap<Allele, Double>>();
        }
    };
    private LinkedHashMap<Allele, Haplotype> haplotypeMap;
    private GenomeLoc lastSiteVisited;
    private ArrayList<Allele> alleleList;
    private static final EnumSet<VariantContext.Type> allowableTypes;

    protected IndelGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, !UAC.DONT_DO_BANDED_INDEL_COMPUTATION);
        this.alleleList = new ArrayList();
        this.getAlleleListFromVCF = UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
        this.minIndelCountForGenotyping = UAC.MIN_INDEL_COUNT_FOR_GENOTYPING;
        this.HAPLOTYPE_SIZE = UAC.INDEL_HAPLOTYPE_SIZE;
        this.DEBUG = UAC.OUTPUT_DEBUG_INDEL_INFO;
        this.haplotypeMap = new LinkedHashMap();
        this.ignoreSNPAllelesWhenGenotypingIndels = UAC.IGNORE_SNP_ALLELES;
    }

    private ArrayList<Allele> computeConsensusAlleles(ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenomeLocParser locParser) {
        ReadBackedExtendedEventPileup indelPileup;
        AlignmentContext context;
        Allele refAllele = null;
        Allele altAllele = null;
        GenomeLoc loc = ref.getLocus();
        ArrayList<Allele> aList = new ArrayList<Allele>();
        HashMap<Object, Object> consensusIndelStrings = new HashMap<Object, Object>();
        int insCount = 0;
        int delCount = 0;
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            indelPileup = context.getExtendedEventPileup();
            insCount += indelPileup.getNumberOfInsertions();
            delCount += indelPileup.getNumberOfDeletions();
        }
        if (insCount < this.minIndelCountForGenotyping && delCount < this.minIndelCountForGenotyping) {
            return aList;
        }
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            indelPileup = context.getExtendedEventPileup();
            for (ExtendedEventPileupElement p : indelPileup.toExtendedIterable()) {
                GATKSAMRecord read = ReadClipper.hardClipAdaptorSequence(p.getRead());
                if (read == null || ReadUtils.is454Read(read)) continue;
                String indelString = p.getEventBases();
                if (p.isInsertion()) {
                    int cnt;
                    int k;
                    boolean foundKey = false;
                    ArrayList<Pair<String, Object>> cList = new ArrayList<Pair<String, Object>>();
                    for (String string : consensusIndelStrings.keySet()) {
                        cList.add(new Pair(string, consensusIndelStrings.get(string)));
                    }
                    if (read.getAlignmentEnd() == loc.getStart()) {
                        for (k = 0; k < cList.size(); ++k) {
                            String string = (String)((Pair)cList.get(k)).getFirst();
                            cnt = (Integer)((Pair)cList.get(k)).getSecond();
                            if (string.startsWith(indelString)) {
                                cList.set(k, new Pair<String, Integer>(string, cnt + 1));
                                foundKey = true;
                                continue;
                            }
                            if (!indelString.startsWith(string)) continue;
                            foundKey = true;
                            cList.set(k, new Pair<String, Integer>(indelString, cnt + 1));
                        }
                        if (!foundKey) {
                            cList.add(new Pair<String, Integer>(indelString, 1));
                        }
                    } else if (read.getAlignmentStart() == loc.getStart() + 1) {
                        for (k = 0; k < cList.size(); ++k) {
                            String string = (String)((Pair)cList.get(k)).getFirst();
                            cnt = (Integer)((Pair)cList.get(k)).getSecond();
                            if (string.endsWith(indelString)) {
                                cList.set(k, new Pair<String, Integer>(string, cnt + 1));
                                foundKey = true;
                                continue;
                            }
                            if (!indelString.endsWith(string)) continue;
                            foundKey = true;
                            cList.set(k, new Pair<String, Integer>(indelString, cnt + 1));
                        }
                        if (!foundKey) {
                            cList.add(new Pair<String, Integer>(indelString, 1));
                        }
                    } else {
                        int cnt2 = consensusIndelStrings.containsKey(indelString) ? (Integer)consensusIndelStrings.get(indelString) : 0;
                        cList.add(new Pair<String, Integer>(indelString, cnt2 + 1));
                    }
                    consensusIndelStrings.clear();
                    for (Pair pair : cList) {
                        consensusIndelStrings.put(pair.getFirst(), pair.getSecond());
                    }
                    continue;
                }
                if (!p.isDeletion()) continue;
                indelString = String.format("D%d", p.getEventLength());
                int cnt = consensusIndelStrings.containsKey(indelString) ? (Integer)consensusIndelStrings.get(indelString) : 0;
                consensusIndelStrings.put(indelString, cnt + 1);
            }
        }
        ArrayList<VariantContext> vcs = new ArrayList<VariantContext>();
        boolean maxAlleleCnt = false;
        String bestAltAllele = "";
        for (String s : consensusIndelStrings.keySet()) {
            int curCnt = (Integer)consensusIndelStrings.get(s);
            int stop = 0;
            if (curCnt < this.minIndelCountForGenotyping) continue;
            if (s.startsWith("D")) {
                int dLen = Integer.valueOf(s.substring(1));
                int startIdxInReference = 1 + loc.getStart() - ref.getWindow().getStart();
                stop = loc.getStart() + dLen;
                byte[] refBases = Arrays.copyOfRange(ref.getBases(), startIdxInReference, startIdxInReference + dLen);
                if (!Allele.acceptableAlleleBases(refBases)) continue;
                refAllele = Allele.create(refBases, true);
                altAllele = Allele.create("-", false);
            } else {
                if (!Allele.acceptableAlleleBases(s)) continue;
                refAllele = Allele.create("-", true);
                altAllele = Allele.create(s, false);
                stop = loc.getStart();
            }
            ArrayList<Allele> vcAlleles = new ArrayList<Allele>();
            vcAlleles.add(refAllele);
            vcAlleles.add(altAllele);
            VariantContextBuilder builder = new VariantContextBuilder().source("");
            builder.loc(loc.getContig(), loc.getStart(), stop);
            builder.alleles(vcAlleles);
            builder.referenceBaseForIndel(ref.getBase());
            builder.noGenotypes();
            vcs.add(builder.make());
            if (vcs.size() < 500) continue;
            break;
        }
        if (vcs.isEmpty()) {
            return aList;
        }
        VariantContext mergedVC = VariantContextUtils.simpleMerge(locParser, vcs, null, VariantContextUtils.FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED, VariantContextUtils.GenotypeMergeType.UNSORTED, false, false, null, false, false);
        aList = new ArrayList<Allele>(mergedVC.getAlleles());
        return aList;
    }

    @Override
    public VariantContext getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenotypePriors priors, List<Allele> alternateAllelesToUse, boolean useBAQedPileup, GenomeLocParser locParser) {
        if (tracker == null) {
            return null;
        }
        GenomeLoc loc = ref.getLocus();
        VariantContext vc = null;
        if (!ref.getLocus().equals(this.lastSiteVisited)) {
            this.alleleList.clear();
            this.lastSiteVisited = ref.getLocus();
            indelLikelihoodMap.set(new HashMap());
            this.haplotypeMap.clear();
            if (this.getAlleleListFromVCF) {
                for (VariantContext vc_input : tracker.getValues(this.UAC.alleles, loc)) {
                    if (vc_input == null || !allowableTypes.contains((Object)vc_input.getType()) || ref.getLocus().getStart() != vc_input.getStart()) continue;
                    vc = vc_input;
                    break;
                }
                if (vc == null) {
                    return null;
                }
                this.alleleList.clear();
                if (this.ignoreSNPAllelesWhenGenotypingIndels) {
                    for (Allele a : vc.getAlleles()) {
                        if (a.isNonReference() && a.getBases().length == vc.getReference().getBases().length) continue;
                        this.alleleList.add(a);
                    }
                } else {
                    for (Allele a : vc.getAlleles()) {
                        this.alleleList.add(a);
                    }
                }
            } else {
                this.alleleList = this.computeConsensusAlleles(ref, contexts, contextType, locParser);
                if (this.alleleList.isEmpty()) {
                    return null;
                }
            }
        }
        if (loc.getStart() <= this.HAPLOTYPE_SIZE) {
            return null;
        }
        if (ref.getWindow().getStop() < loc.getStop() + this.HAPLOTYPE_SIZE) {
            return null;
        }
        if (!(priors instanceof DiploidIndelGenotypePriors)) {
            throw new StingException("Only diploid-based Indel priors are supported in the INDEL GL model");
        }
        if (this.alleleList.isEmpty()) {
            return null;
        }
        Allele refAllele = this.alleleList.get(0);
        Allele altAllele = this.alleleList.get(1);
        int maxLenDiff = 0;
        for (Allele a : this.alleleList) {
            int lenDiff;
            if (!a.isNonReference() || (lenDiff = Math.abs(a.getBaseString().length() - refAllele.getBaseString().length())) <= maxLenDiff) continue;
            maxLenDiff = lenDiff;
            altAllele = a;
        }
        int eventLength = altAllele.getBaseString().length() - refAllele.getBaseString().length();
        int hsize = ref.getWindow().size() - Math.abs(eventLength) - 1;
        int numPrefBases = ref.getLocus().getStart() - ref.getWindow().getStart() + 1;
        if (hsize <= 0) {
            this.logger.warn(String.format("Warning: event at location %s can't be genotyped, skipping", loc.toString()));
            return null;
        }
        this.haplotypeMap = Haplotype.makeHaplotypeListFromAlleles(this.alleleList, loc.getStart(), ref, hsize, numPrefBases);
        int endLoc = this.calculateEndPos(this.alleleList, refAllele, loc);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), endLoc, this.alleleList).referenceBaseForIndel(ref.getBase());
        GenotypesContext genotypes = GenotypesContext.create();
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            AlignmentContext context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            ReadBackedPileup pileup = null;
            if (context.hasExtendedEventPileup()) {
                pileup = context.getExtendedEventPileup();
            } else if (context.hasBasePileup()) {
                pileup = context.getBasePileup();
            }
            if (pileup == null) continue;
            double[] genotypeLikelihoods = this.pairModel.computeReadHaplotypeLikelihoods(pileup, this.haplotypeMap, ref, eventLength, IndelGenotypeLikelihoodsCalculationModel.getIndelLikelihoodMap());
            GenotypeLikelihoods likelihoods = GenotypeLikelihoods.fromLog10Likelihoods(genotypeLikelihoods);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("DP", this.getFilteredDepth(pileup));
            attributes.put("PL", likelihoods);
            genotypes.add(new Genotype(sample.getKey(), noCall, 1.0, null, attributes, false));
            if (!this.DEBUG) continue;
            System.out.format("Sample:%s Alleles:%s GL:", sample.getKey(), this.alleleList.toString());
            for (int k = 0; k < genotypeLikelihoods.length; ++k) {
                System.out.format("%1.4f ", genotypeLikelihoods[k]);
            }
            System.out.println();
        }
        return builder.genotypes(genotypes).make();
    }

    private int calculateEndPos(Collection<Allele> alleles, Allele refAllele, GenomeLoc loc) {
        boolean hasNullAltAllele = false;
        for (Allele a : alleles) {
            if (!a.isNull()) continue;
            hasNullAltAllele = true;
            break;
        }
        int endLoc = loc.getStart() + refAllele.length();
        if (!hasNullAltAllele) {
            --endLoc;
        }
        return endLoc;
    }

    public static HashMap<PileupElement, LinkedHashMap<Allele, Double>> getIndelLikelihoodMap() {
        return indelLikelihoodMap.get();
    }

    @Override
    protected int getFilteredDepth(ReadBackedPileup pileup) {
        int count = 0;
        for (PileupElement p : pileup) {
            if (!p.isDeletion() && !p.isInsertionAtBeginningOfRead() && !BaseUtils.isRegularBase(p.getBase())) continue;
            ++count;
        }
        return count;
    }

    static {
        indelLikelihoodMap.set(new HashMap());
        allowableTypes = EnumSet.of(VariantContext.Type.INDEL, VariantContext.Type.MIXED);
    }
}

